/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.delete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.php.delete.SafeDeleteSupport;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SafeDeletePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient SafeDeleteRefactoring refactoring;
    private boolean regulardelete;
    private ChangeListener parent;
    private final boolean hasVisibleElements;
    private final String fileName;
    private boolean initialized = false;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JPanel checkBoxes;
    private JLabel label;
    private JCheckBox searchInComments;
    private JCheckBox safeDelete;

    public SafeDeletePanel(SafeDeleteRefactoring refactoring, boolean regulardelete, ChangeListener parent) {
        this.setName(NbBundle.getMessage(SafeDeletePanel.class, (String)(regulardelete ? "LBL_SafeDel_Delete" : "LBL_SafeDel")));
        this.refactoring = refactoring;
        SafeDeleteSupport support = (SafeDeleteSupport)this.refactoring.getRefactoringSource().lookup(SafeDeleteSupport.class);
        this.fileName = support.getFile().getNameExt();
        this.hasVisibleElements = support.hasVisibleElements();
        this.regulardelete = regulardelete;
        this.parent = parent;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.methodDeclaringClass;
    }

    public void initialize() {
        this.searchInComments.setEnabled(false);
        this.searchInComments.setVisible(false);
        if (this.initialized) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SafeDeletePanel.this.regulardelete) {
                    SafeDeletePanel.this.safeDelete = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)SafeDeletePanel.this.safeDelete, (String)NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelCheckBox"));
                    SafeDeletePanel.this.safeDelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SafeDeletePanel.class, (String)"SafeDeletePanel.safeDelete.AccessibleContext.accessibleDescription"));
                    SafeDeletePanel.this.safeDelete.setMargin(new Insets(2, 14, 2, 2));
                    SafeDeletePanel.this.searchInComments.setEnabled(false);
                    SafeDeletePanel.this.safeDelete.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent evt) {
                            SafeDeletePanel.this.searchInComments.setEnabled(SafeDeletePanel.this.safeDelete.isSelected());
                            SafeDeletePanel.this.parent.stateChanged(null);
                        }
                    });
                    SafeDeletePanel.this.checkBoxes.add((Component)SafeDeletePanel.this.safeDelete, "Center");
                    if (!SafeDeletePanel.this.hasVisibleElements) {
                        SafeDeletePanel.this.safeDelete.setVisible(true);
                        SafeDeletePanel.this.safeDelete.setEnabled(false);
                    }
                }
                SafeDeletePanel.this.validate();
            }
        });
        this.initialized = true;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    boolean isRegularDelete() {
        return this.safeDelete != null && !this.safeDelete.isSelected() || !this.hasVisibleElements;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.checkBoxes = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.checkBoxes.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.label, (String)(this.regulardelete ? NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_RegularDeleteElement", (Object)this.fileName) : NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Element", (Object)this.fileName)));
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.checkBoxes.add((Component)this.label, "North");
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/php/delete/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)bundle.getString("LBL_SafeDelInComents"));
        this.searchInComments.setMargin(new Insets(2, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SafeDeletePanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.checkBoxes.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.checkBoxes, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        this.refactoring.setCheckInComments(b.booleanValue());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

