/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequest;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreatePreauthenticatedRequestDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="bucketListingAction")
    private final PreauthenticatedRequest.BucketListingAction bucketListingAction;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="accessType")
    private final AccessType accessType;
    @JsonProperty(value="timeExpires")
    private final Date timeExpires;

    @Deprecated
    @ConstructorProperties(value={"name", "bucketListingAction", "objectName", "accessType", "timeExpires"})
    public CreatePreauthenticatedRequestDetails(String name, PreauthenticatedRequest.BucketListingAction bucketListingAction, String objectName, AccessType accessType, Date timeExpires) {
        this.name = name;
        this.bucketListingAction = bucketListingAction;
        this.objectName = objectName;
        this.accessType = accessType;
        this.timeExpires = timeExpires;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public PreauthenticatedRequest.BucketListingAction getBucketListingAction() {
        return this.bucketListingAction;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public Date getTimeExpires() {
        return this.timeExpires;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreatePreauthenticatedRequestDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", bucketListingAction=").append(String.valueOf((Object)this.bucketListingAction));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", accessType=").append(String.valueOf((Object)this.accessType));
        sb.append(", timeExpires=").append(String.valueOf(this.timeExpires));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePreauthenticatedRequestDetails)) {
            return false;
        }
        CreatePreauthenticatedRequestDetails other = (CreatePreauthenticatedRequestDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.bucketListingAction, (Object)other.bucketListingAction) && Objects.equals(this.objectName, other.objectName) && Objects.equals((Object)this.accessType, (Object)other.accessType) && Objects.equals(this.timeExpires, other.timeExpires) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.bucketListingAction == null ? 43 : this.bucketListingAction.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.accessType == null ? 43 : this.accessType.hashCode());
        result = result * 59 + (this.timeExpires == null ? 43 : this.timeExpires.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AccessType implements BmcEnum
    {
        ObjectRead("ObjectRead"),
        ObjectWrite("ObjectWrite"),
        ObjectReadWrite("ObjectReadWrite"),
        AnyObjectWrite("AnyObjectWrite"),
        AnyObjectRead("AnyObjectRead"),
        AnyObjectReadWrite("AnyObjectReadWrite");

        private final String value;
        private static Map<String, AccessType> map;

        private AccessType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessType: " + key);
        }

        static {
            map = new HashMap<String, AccessType>();
            for (AccessType v : AccessType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="bucketListingAction")
        private PreauthenticatedRequest.BucketListingAction bucketListingAction;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="accessType")
        private AccessType accessType;
        @JsonProperty(value="timeExpires")
        private Date timeExpires;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder bucketListingAction(PreauthenticatedRequest.BucketListingAction bucketListingAction) {
            this.bucketListingAction = bucketListingAction;
            this.__explicitlySet__.add("bucketListingAction");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder accessType(AccessType accessType) {
            this.accessType = accessType;
            this.__explicitlySet__.add("accessType");
            return this;
        }

        public Builder timeExpires(Date timeExpires) {
            this.timeExpires = timeExpires;
            this.__explicitlySet__.add("timeExpires");
            return this;
        }

        public CreatePreauthenticatedRequestDetails build() {
            CreatePreauthenticatedRequestDetails model = new CreatePreauthenticatedRequestDetails(this.name, this.bucketListingAction, this.objectName, this.accessType, this.timeExpires);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreatePreauthenticatedRequestDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("bucketListingAction")) {
                this.bucketListingAction(model.getBucketListingAction());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("accessType")) {
                this.accessType(model.getAccessType());
            }
            if (model.wasPropertyExplicitlySet("timeExpires")) {
                this.timeExpires(model.getTimeExpires());
            }
            return this;
        }
    }
}

