/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.IOException;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NbRenameRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private RenameRefactoring rename;

    public NbRenameRefactoringPlugin(AbstractRefactoring refactoring) {
        super(refactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            NonRecursiveFolder nrf;
            Project project;
            this.rename = (RenameRefactoring)this.refactoring;
            Problem problem = null;
            Lookup lkp = this.rename.getRefactoringSource();
            TreePathHandle handle = (TreePathHandle)lkp.lookup(TreePathHandle.class);
            if (handle != null) {
                AbstractRefactoringPlugin.InfoHolder infoholder = this.examineLookup(lkp);
                project = FileOwnerQuery.getOwner((FileObject)handle.getFileObject());
                if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                    Problem problem2 = null;
                    return problem2;
                }
                if (infoholder.isClass) {
                    this.checkManifest(project, infoholder.fullName, refactoringElements);
                    this.checkLayer(project, infoholder.fullName, refactoringElements);
                }
                if (infoholder.isMethod) {
                    this.checkMethodLayer(infoholder, handle.getFileObject(), refactoringElements);
                }
            }
            if ((nrf = (NonRecursiveFolder)lkp.lookup(NonRecursiveFolder.class)) != null) {
                SourceGroup[] grps;
                project = FileOwnerQuery.getOwner((FileObject)nrf.getFolder());
                if (project.getLookup().lookup(NbModuleProvider.class) == null) {
                    Problem problem3 = null;
                    return problem3;
                }
                Sources srcs = ProjectUtils.getSources((Project)project);
                for (SourceGroup gr : grps = srcs.getSourceGroups("java")) {
                    if (!FileUtil.isParentOf((FileObject)gr.getRootFolder(), (FileObject)nrf.getFolder())) continue;
                    String relPath = FileUtil.getRelativePath((FileObject)gr.getRootFolder(), (FileObject)nrf.getFolder());
                    relPath.replace('/', '.');
                }
            }
            Problem problem4 = problem;
            return problem4;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Problem problem = null;
            return problem;
        }
        finally {
            semafor.set(null);
        }
    }

    @Override
    protected RefactoringElementImplementation createManifestRefactoring(String fqname, FileObject manifestFile, String attributeKey, String attributeValue, String section) {
        return new ManifestRenameRefactoringElement(fqname, manifestFile, attributeValue, attributeKey, section);
    }

    @Override
    protected RefactoringElementImplementation createConstructorLayerRefactoring(String constructor, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return null;
    }

    @Override
    protected RefactoringElementImplementation createLayerRefactoring(String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return handle.getLayerFile() != null ? new LayerClassRefactoringElement(fqname, handle, layerFileObject, layerAttribute) : null;
    }

    @Override
    protected RefactoringElementImplementation createMethodLayerRefactoring(String method, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return handle.getLayerFile() != null ? new LayerMethodRefactoringElement(method, handle, layerFileObject, layerAttribute) : null;
    }

    public final class ManifestRenameRefactoringElement
    extends AbstractRefactoringElement {
        private String attrName;
        private String sectionName;
        private String oldName;
        private String oldContent;
        private String newName;

        public ManifestRenameRefactoringElement(String fqname, FileObject parentFile, String attributeValue, String attributeName) {
            super(parentFile);
            this.sectionName = null;
            this.name = attributeValue;
            this.attrName = attributeName;
            this.oldName = fqname;
        }

        public ManifestRenameRefactoringElement(String fqname, FileObject parentFile, String attributeValue, String attributeName, String secName) {
            this(fqname, parentFile, attributeValue, attributeName);
            this.sectionName = secName;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbRenameRefactoringPlugin.class, (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbRenameRefactoringPlugin.class, (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        @Override
        public void performChange() {
            String content;
            this.oldContent = content = Utility.readFileIntoString(this.parentFile);
            if (content != null) {
                String shortName = this.oldName.substring(this.oldName.lastIndexOf(".") + 1);
                if (this.newName == null) {
                    this.newName = NbRenameRefactoringPlugin.this.rename.getNewName();
                    this.newName = this.newName.replace('.', '/') + ".class";
                }
                shortName = shortName + ".class";
                content = content.replaceAll(shortName, this.newName);
                Utility.writeFileFromString(this.parentFile, content);
            }
        }

        @Override
        public void undoChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }

    public final class LayerClassRefactoringElement
    extends LayerAbstractRefactoringElement {
        private String fqname;
        private String newAttrName;
        private String newAttrValue;
        private String newFileName;

        public LayerClassRefactoringElement(String fqname, LayerHandle handle, FileObject layerFile, String attributeName) {
            super(handle, layerFile, attributeName);
            this.fqname = fqname;
        }

        public String getDisplayText() {
            if (this.newFileName != null) {
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerFileRename", (Object)this.oldFileName, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
            }
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        @Override
        public void performChange() {
            String nm = this.fqname.substring(this.fqname.lastIndexOf(46) + 1);
            if (this.oldAttrName == null) {
                this.newFileName = this.oldFileName.replaceAll("\\-" + nm + "$", "-" + NbRenameRefactoringPlugin.this.rename.getNewName());
            } else if (this.oldAttrName.indexOf(this.fqname.replace('.', '-') + ".instance") > 0) {
                this.newAttrName = this.oldAttrName.replaceAll("-" + nm + "\\.", "-" + NbRenameRefactoringPlugin.this.rename.getNewName() + ".");
            } else if (this.oldAttrValue != null) {
                String toReplacePattern = nm;
                this.newAttrValue = this.oldAttrValue.replaceAll(toReplacePattern, NbRenameRefactoringPlugin.this.rename.getNewName());
            }
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.newAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.oldAttrName, this.newAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.newFileName);
            }
        }

        @Override
        public void undoChange() {
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.oldAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.newAttrName, this.oldAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.oldFileName);
            }
        }
    }

    public final class LayerMethodRefactoringElement
    extends LayerAbstractRefactoringElement {
        private String newAttrValue;
        private String method;

        public LayerMethodRefactoringElement(String method, LayerHandle handle, FileObject layerFile, String attributeName) {
            super(handle, layerFile, attributeName);
            this.method = method;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        @Override
        public void performChange() {
            this.newAttrValue = this.oldAttrValue.replaceAll("\\." + this.method + "$", "." + NbRenameRefactoringPlugin.this.rename.getNewName());
            this.doAttributeValueChange(this.newAttrValue, this.valueType);
        }

        @Override
        public void undoChange() {
            this.doAttributeValueChange(this.oldAttrValue, this.valueType);
        }
    }

    public abstract class LayerAbstractRefactoringElement
    extends AbstractRefactoringElement {
        protected FileObject layerFile;
        protected LayerHandle handle;
        protected String oldFileName;
        protected String oldAttrName;
        protected String oldAttrValue;
        protected String valueType;

        public LayerAbstractRefactoringElement(LayerHandle handle, FileObject layerFile, String attributeName) {
            super(handle.getLayerFile());
            this.layerFile = layerFile;
            this.handle = handle;
            this.oldFileName = layerFile.getName();
            this.oldAttrName = attributeName;
            if (attributeName != null) {
                Object val = layerFile.getAttribute("literal:" + attributeName);
                if (val == null) {
                    throw new IllegalStateException();
                }
                if (val instanceof String) {
                    this.oldAttrValue = (String)val;
                    if (this.oldAttrValue.startsWith("new:")) {
                        this.oldAttrValue = ((String)val).substring("new:".length());
                        this.valueType = "newvalue:";
                    } else if (this.oldAttrValue.startsWith("method:")) {
                        this.oldAttrValue = ((String)val).substring("method:".length());
                        this.valueType = "methodvalue:";
                    }
                }
            }
        }

        protected void doAttributeValueChange(String newOne, String type) {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            try {
                this.layerFile.setAttribute(this.oldAttrName, (Object)((type != null ? type : "") + newOne));
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }

        protected void doAttributeMove(String oldKey, String newKey) {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            try {
                Object obj = this.layerFile.getAttribute(oldKey);
                this.layerFile.setAttribute(oldKey, null);
                this.layerFile.setAttribute(newKey, obj);
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFileMove(String newName) {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            FileLock lock = null;
            try {
                lock = this.layerFile.lock();
                this.layerFile.rename(lock, newName, this.layerFile.getExt());
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }
    }
}

