/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.languages.parser.DG;
import org.netbeans.modules.languages.parser.NodeFactory;

public class DGUtils {
    public static <N, E, K, V> DG<N, E, K, V> cloneDG(DG<N, E, K, V> dg, boolean cloneProperties, NodeFactory<N> nodeFactory) {
        DG ndg = DG.createDG();
        HashMap oldToNew = new HashMap();
        for (N oldNode : dg.getNodes()) {
            Object newNode = oldToNew.get(oldNode);
            if (newNode == null) {
                newNode = nodeFactory.createNode();
                ndg.addNode(newNode);
                oldToNew.put(oldNode, newNode);
                if (cloneProperties) {
                    ndg.putAllProperties(newNode, dg.getProperties(oldNode));
                }
            }
            for (E edge : dg.getEdges(oldNode)) {
                N oldEnd = dg.getNode(oldNode, edge);
                Object newEnd = oldToNew.get(oldEnd);
                if (newEnd == null) {
                    newEnd = nodeFactory.createNode();
                    ndg.addNode(newEnd);
                    oldToNew.put(oldEnd, newEnd);
                    if (cloneProperties) {
                        ndg.putAllProperties(newEnd, dg.getProperties(oldEnd));
                    }
                }
                ndg.addEdge(newNode, newEnd, edge);
                if (!cloneProperties) continue;
                ndg.putAllProperties(newNode, edge, dg.getProperties(oldNode, edge));
            }
            if (!dg.getEnds().contains(oldNode)) continue;
            ndg.addEnd(newNode);
        }
        Object newStart = oldToNew.get(dg.getStartNode());
        ndg.setStart(newStart);
        return ndg;
    }

    public static <N, E, K, V> DG<N, E, K, V> append(DG<N, E, K, V> dg1, DG<N, E, K, V> dg2, E star, NodeFactory<N> nodeFactory) {
        DG ndg = DG.createDG();
        HashSet<N> newStart = new HashSet<N>();
        newStart.add(dg1.getStartNode());
        if (dg1.getEnds().contains(dg1.getStartNode())) {
            newStart.add(dg2.getStartNode());
        }
        HashMap newToOld = new HashMap();
        DGUtils.merge(dg1, dg2, newStart, ndg, newToOld, dg1.getEnds(), dg2.getStartNode(), false, true, star, nodeFactory);
        Object nnn = newToOld.get(newStart);
        ndg.setStart(nnn);
        return ndg;
    }

    public static <N, E, K, V> DG<N, E, K, V> plus(DG<N, E, K, V> dg, E star, NodeFactory<N> nodeFactory) {
        DG ndg = DG.createDG();
        N what = dg.getStartNode();
        Set<N> where = dg.getEnds();
        HashSet<N> nn = new HashSet<N>();
        nn.add(dg.getStartNode());
        if (where.contains(dg.getStartNode())) {
            nn.add(what);
        }
        HashMap newToOld = new HashMap();
        DGUtils.merge(dg, dg, nn, ndg, newToOld, where, what, true, true, star, nodeFactory);
        Object nnn = newToOld.get(nn);
        ndg.setStart(nnn);
        return ndg;
    }

    private static <N, E, K, V> void merge(DG<N, E, K, V> dg1, DG<N, E, K, V> dg2, Set<N> nn, DG<N, E, K, V> ndg, Map<Set<N>, N> newToOld, Set<N> where, N what, boolean setEnds1, boolean setEnds2, E star, NodeFactory<N> nodeFactory) {
        Object en;
        DG<N, Object, K, V> cdg;
        N nnn = newToOld.get(nn);
        if (nnn != null) {
            return;
        }
        nnn = nodeFactory.createNode();
        newToOld.put(nn, nnn);
        ndg.addNode(nnn);
        HashMap edges = new HashMap();
        HashMap properties = new HashMap();
        for (N n : nn) {
            cdg = dg1.containsNode(n) ? dg1 : dg2;
            ndg.putAllProperties(nnn, cdg.getProperties(n));
            if (setEnds1 && dg1.getEnds().contains(n)) {
                ndg.addEnd(nnn);
            }
            if (setEnds2 && dg2.getEnds().contains(n)) {
                ndg.addEnd(nnn);
            }
            for (E edge : cdg.getEdges(n)) {
                HashSet<N> ends = (HashSet<N>)edges.get(edge);
                HashMap<K, V> props = (HashMap<K, V>)properties.get(edge);
                if (ends == null) {
                    ends = new HashSet<N>();
                    props = new HashMap<K, V>();
                    edges.put(edge, ends);
                    properties.put(edge, props);
                }
                N en2 = cdg.getNode(n, edge);
                ends.add(en2);
                props.putAll(cdg.getProperties(n, edge));
                if (!where.contains(en2)) continue;
                ends.add(what);
            }
        }
        for (N n : nn) {
            cdg = dg1.containsNode(n) ? dg1 : dg2;
            en = cdg.getNode(n, star);
            if (en == null) continue;
            for (Object e : edges.keySet()) {
                if (cdg.getNode(n, e) != null) continue;
                ((Set)edges.get(e)).add(en);
                ((Map)properties.get(e)).putAll(cdg.getProperties(n, e));
                if (!where.contains(en)) continue;
                ((Set)edges.get(e)).add(what);
            }
        }
        for (Object edge : edges.keySet()) {
            en = (Set)edges.get(edge);
            DGUtils.merge(dg1, dg2, en, ndg, newToOld, where, what, setEnds1, setEnds2, star, nodeFactory);
            N enn = newToOld.get(en);
            ndg.addEdge(nnn, enn, edge);
            ndg.putAllProperties(nnn, edge, (Map)properties.get(edge));
        }
    }

    public static <N, E, K, V> DG<N, E, K, V> merge(DG<N, E, K, V> dg1, DG<N, E, K, V> dg2, E star, NodeFactory<N> nodeFactory) {
        DG ndg = DG.createDG();
        HashMap newToOld = new HashMap();
        N startNode = DGUtils.merge(dg1, dg2, dg1.getStartNode(), dg2.getStartNode(), ndg, true, true, star, nodeFactory, newToOld, 1);
        ndg.setStart(startNode);
        return ndg;
    }

    private static <N, E, K, V> N merge(DG<N, E, K, V> dg1, DG<N, E, K, V> dg2, N n1, N n2, DG<N, E, K, V> ndg, boolean addEnds1, boolean addEnds2, E star, NodeFactory<N> nodeFactory, Map<Set<N>, N> newToOld, int depth) {
        Map<K, V> properties;
        HashSet<N> nNode = new HashSet<N>();
        nNode.add(n1);
        nNode.add(n2);
        if (newToOld.containsKey(nNode)) {
            return newToOld.get(nNode);
        }
        N dnode = nodeFactory.createNode();
        newToOld.put(nNode, dnode);
        ndg.addNode(dnode);
        ndg.putAllProperties(dnode, dg1.getProperties(n1));
        ndg.putAllProperties(dnode, dg2.getProperties(n2));
        if (addEnds1 && dg1.getEnds().contains(n1)) {
            ndg.addEnd(dnode);
        }
        if (addEnds2 && dg2.getEnds().contains(n2)) {
            ndg.addEnd(dnode);
        }
        HashSet<E> edges2 = new HashSet<E>(dg2.getEdges(n2));
        for (E edge : dg1.getEdges(n1)) {
            N nn1 = dg1.getNode(n1, edge);
            N nn2 = dg2.getNode(n2, edge);
            properties = null;
            if (!edge.equals(star) && edges2.contains(star) && nn2 == null) {
                nn2 = dg2.getNode(n2, star);
                properties = dg2.getProperties(n2, star);
            } else if (nn2 != null) {
                properties = dg2.getProperties(n2, edge);
            }
            N nnode = nn2 == null ? DGUtils.merge(dg1, nn1, ndg, addEnds1) : DGUtils.merge(dg1, dg2, nn1, nn2, ndg, addEnds1, addEnds2, star, nodeFactory, newToOld, depth + 1);
            ndg.addEdge(dnode, nnode, edge);
            ndg.putAllProperties(dnode, edge, dg1.getProperties(n1, edge));
            if (properties != null) {
                ndg.putAllProperties(dnode, edge, properties);
            }
            edges2.remove(edge);
        }
        for (E edge : edges2) {
            N nn2 = dg2.getNode(n2, edge);
            Object nnode = null;
            properties = null;
            if (!edge.equals(star) && dg1.getEdges(n1).contains(star)) {
                nnode = DGUtils.merge(dg1, dg2, dg1.getNode(n1, star), nn2, ndg, addEnds1, addEnds2, star, nodeFactory, newToOld, depth + 1);
                properties = dg1.getProperties(n1, star);
            } else {
                nnode = DGUtils.merge(dg2, nn2, ndg, addEnds2);
            }
            ndg.addEdge(dnode, nnode, edge);
            ndg.putAllProperties(dnode, edge, dg2.getProperties(n2, edge));
            if (properties == null) continue;
            ndg.putAllProperties(dnode, edge, properties);
        }
        return dnode;
    }

    private static <N, E, K, V> N merge(DG<N, E, K, V> dg, N n, DG<N, E, K, V> ndg, boolean addEnds) {
        if (ndg.containsNode(n)) {
            return n;
        }
        ndg.addNode(n);
        ndg.putAllProperties(n, dg.getProperties(n));
        if (addEnds && dg.getEnds().contains(n)) {
            ndg.addEnd(n);
        }
        for (E edge : dg.getEdges(n)) {
            N nn = dg.getNode(n, edge);
            N endN = DGUtils.merge(dg, nn, ndg, addEnds);
            ndg.addEdge(n, endN, edge);
            ndg.putAllProperties(n, edge, dg.getProperties(n, edge));
        }
        return n;
    }

    static <N, E, K, V> DG<N, E, K, V> reduce(DG<N, E, K, V> dg, NodeFactory<N> nodeFactory) {
        Object newNode;
        HashMap<Map<K, V>, HashSet<N>> ends = new HashMap<Map<K, V>, HashSet<N>>();
        HashSet<N> other = new HashSet<N>();
        for (N node : dg.getNodes()) {
            if (!dg.getEnds().contains(node)) {
                other.add(node);
                continue;
            }
            HashSet<N> e = (HashSet<N>)ends.get(dg.getProperties(node));
            if (e == null) {
                e = new HashSet<N>();
                ends.put(dg.getProperties(node), e);
            }
            e.add(node);
        }
        HashSet<Set<N>> newNodes = new HashSet<Set<N>>();
        if (other.size() > 0) {
            newNodes.add(other);
        }
        newNodes.addAll(ends.values());
        Map<Set<N>, Map<E, Set<N>>> ng = DGUtils.reduce(dg, newNodes);
        DG ndg = DG.createDG();
        HashMap oldToNewNode = new HashMap();
        for (Set<N> node : ng.keySet()) {
            newNode = oldToNewNode.get(node);
            if (newNode == null) {
                newNode = nodeFactory.createNode();
                oldToNewNode.put(node, newNode);
                ndg.addNode(newNode);
            }
            Map<E, Set<N>> edgeToNode = ng.get(node);
            for (E edge : edgeToNode.keySet()) {
                Set<N> end = edgeToNode.get(edge);
                Object newNode2 = oldToNewNode.get(end);
                if (newNode2 == null) {
                    newNode2 = nodeFactory.createNode();
                    oldToNewNode.put(end, newNode2);
                    ndg.addNode(newNode2);
                }
                ndg.addEdge(newNode, newNode2, edge);
            }
        }
        ndg.setEnds(new HashSet());
        for (Set<N> node : ng.keySet()) {
            newNode = oldToNewNode.get(node);
            for (N n : node) {
                if (dg.containsNode(n) && dg.getProperties(n) != null) {
                    ndg.putAllProperties(newNode, dg.getProperties(n));
                }
                for (Object edge : ndg.getEdges(newNode)) {
                    if (!dg.containsNode(n) || dg.getProperties(n, edge) == null) continue;
                    ndg.putAllProperties(newNode, edge, dg.getProperties(n, edge));
                }
                if (dg.getEnds().contains(n)) {
                    ndg.addEnd(newNode);
                }
                if (!dg.getStartNode().equals(n)) continue;
                ndg.setStart(newNode);
            }
        }
        return ndg;
    }

    private static <N, E, K, V> Map<Set<N>, Map<E, Set<N>>> reduce(DG<N, E, K, V> dg, Set<Set<N>> s) {
        HashMap<N, Set<N>> m = new HashMap<N, Set<N>>();
        for (Set<N> nnode : s) {
            for (N node : nnode) {
                m.put(node, nnode);
            }
        }
        HashMap<Set<N>, Map<E, Set<N>>> nnodes = new HashMap<Set<N>, Map<E, Set<N>>>();
        for (Set<N> nnode : s) {
            HashMap nodes = new HashMap();
            for (N node : nnode) {
                Map<E, Set> edges = new HashMap();
                for (E edge : dg.getEdges(node)) {
                    N endNode = dg.getNode(node, edge);
                    edges.put(edge, (Set)m.get(endNode));
                }
                HashSet<N> n = (HashSet<N>)nodes.get(edges);
                if (n == null) {
                    n = new HashSet<N>();
                    nodes.put(edges, n);
                }
                n.add(node);
            }
            for (Map<E, Set> edges : nodes.keySet()) {
                Set newState = (Set)nodes.get(edges);
                nnodes.put(newState, edges);
            }
        }
        if (nnodes.size() > s.size()) {
            return DGUtils.reduce(dg, nnodes.keySet());
        }
        return nnodes;
    }
}

