/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.impl;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.modules.groovy.refactoring.findusages.impl.AbstractFindUsages;
import org.netbeans.modules.groovy.refactoring.findusages.impl.AbstractFindUsagesVisitor;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.VariableRefactoringElement;

public class FindVariableUsages
extends AbstractFindUsages {
    public FindVariableUsages(RefactoringElement element) {
        super(element);
    }

    @Override
    protected List<AbstractFindUsagesVisitor> getVisitors(ModuleNode moduleNode, String defClass) {
        return this.singleVisitor(new FindVariableUsagesVisitor(moduleNode));
    }

    private class FindVariableUsagesVisitor
    extends AbstractFindUsagesVisitor {
        private final String variableType;
        private final String variableName;

        public FindVariableUsagesVisitor(ModuleNode moduleNode) {
            super(moduleNode);
            assert (FindVariableUsages.this.element instanceof VariableRefactoringElement) : "Expected VariableRefactoringElement but it was: " + findVariableUsages.element.getClass().getSimpleName();
            VariableRefactoringElement varElement = (VariableRefactoringElement)FindVariableUsages.this.element;
            this.variableType = varElement.getVariableTypeName();
            this.variableName = varElement.getVariableName();
        }

        public void visitField(FieldNode field) {
            if (!field.isSynthetic()) {
                this.addField(field);
            }
            super.visitField(field);
        }

        public void visitProperty(PropertyNode property) {
            if (!property.isSynthetic()) {
                this.addField(property.getField());
            }
            super.visitProperty(property);
        }

        private void addField(FieldNode field) {
            String fieldName = field.getName();
            String fieldOwner = field.getOwner().getName();
            this.addIfEqual((ASTNode)field, fieldOwner, fieldName);
        }

        public void visitPropertyExpression(PropertyExpression expression) {
            Expression objectExpression = expression.getObjectExpression();
            if (objectExpression == null) {
                return;
            }
            String varName = expression.getPropertyAsString();
            if (objectExpression instanceof VariableExpression) {
                String varType;
                VariableExpression varExpression = (VariableExpression)objectExpression;
                if ("this".equals(varExpression.getName())) {
                    String fileName = this.getSourceUnit().getName();
                    varType = fileName.substring(0, fileName.indexOf("."));
                } else {
                    varType = varExpression.getType().getName();
                }
                this.addIfEqual((ASTNode)expression.getProperty(), varType, varName);
            } else {
                this.addIfEqual((ASTNode)expression.getProperty(), objectExpression.getType().getName(), varName);
            }
            super.visitPropertyExpression(expression);
        }

        public void visitVariableExpression(VariableExpression expression) {
            VariableExpression variableExpression = expression;
            Variable variable = variableExpression.getAccessedVariable();
            if (variable != null) {
                String varName = variableExpression.getText();
                String varType = variable.getType().getName();
                this.addIfEqual((ASTNode)expression, varType, varName);
            }
            super.visitVariableExpression(expression);
        }

        private void addIfEqual(ASTNode nodeToAdd, String type, String name) {
            if ("java.lang.Object".equals(type)) {
                this.addIfNameEquals(nodeToAdd, name);
            }
            if ("java.lang.Object".equals(this.variableType)) {
                this.addIfNameEquals(nodeToAdd, name);
            }
            if (this.variableType.endsWith(type)) {
                this.addIfNameEquals(nodeToAdd, name);
            }
        }

        private void addIfNameEquals(ASTNode nodeToAdd, String name) {
            if (this.variableName.equals(name)) {
                this.usages.add(nodeToAdd);
            }
        }
    }
}

