/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorPHPStanParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.PHPStanLevelListCellRenderer;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PHPStanCustomizerPanel
extends JPanel {
    public static final String ENABLED = "phpStan.enabled";
    public static final String PATH = "phpStan.path";
    public static final String LEVEL = "phpStan.level";
    public static final String CONFIGURATION = "phpStan.configuration";
    public static final String MEMORY_LIMIT = "phpStan.memory.limit";
    private static final RequestProcessor RP = new RequestProcessor(PHPStanCustomizerPanel.class);
    private static final long serialVersionUID = -3450253368766485405L;
    final Analyzer.CustomizerContext<Void, PHPStanCustomizerPanel> context;
    final Preferences settings;
    private JButton phpStanBrowseButton;
    private JButton phpStanConfigurationBrowseButton;
    private JLabel phpStanConfigurationLabel;
    private JTextField phpStanConfigurationTextField;
    private JCheckBox phpStanEnabledCheckBox;
    private JLabel phpStanLabel;
    private JComboBox<String> phpStanLevelComboBox;
    private JLabel phpStanLevelLabel;
    private JLabel phpStanMemoryLimitLabel;
    private JTextField phpStanMemoryLimitTextField;
    private JButton phpStanSearchButton;
    private JTextField phpStanTextField;

    public PHPStanCustomizerPanel(Analyzer.CustomizerContext<Void, PHPStanCustomizerPanel> context) {
        assert (EventQueue.isDispatchThread());
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initEnabledCheckBox();
        this.initPHPStanField();
        this.initLevelComboBox();
        this.initConfigurationTextField();
        this.initMemoryLimitTextField();
        RP.schedule(() -> EventQueue.invokeLater(() -> {
            this.context.setError(null);
            if (this.phpStanEnabledCheckBox.isSelected()) {
                this.validateData();
            }
        }), 1000L, TimeUnit.MILLISECONDS);
    }

    private void initEnabledCheckBox() {
        assert (EventQueue.isDispatchThread());
        this.phpStanEnabledCheckBox.addItemListener(e -> {
            this.setAllComponetsEnabled(this.phpStanEnabledCheckBox.isSelected());
            this.setPHPStanEnabled();
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.phpStanEnabledCheckBox.setSelected(isEnabled);
        this.setAllComponetsEnabled(isEnabled);
        this.phpStanEnabledCheckBox.addItemListener(e -> {
            if (!this.phpStanEnabledCheckBox.isSelected()) {
                this.context.setError(null);
            } else {
                this.validateData();
            }
        });
    }

    private void initPHPStanField() {
        assert (EventQueue.isDispatchThread());
        this.phpStanTextField.setText(this.settings.get(PATH, AnalysisOptions.getInstance().getPHPStanPath()));
        this.phpStanTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setPHPStanPath()));
    }

    private void initLevelComboBox() {
        assert (EventQueue.isDispatchThread());
        this.phpStanLevelComboBox.removeAllItems();
        this.phpStanLevelComboBox.addItem("");
        for (int i = AnalysisOptions.PHPSTAN_MIN_LEVEL; i <= AnalysisOptions.PHPSTAN_MAX_LEVEL; ++i) {
            this.phpStanLevelComboBox.addItem(String.valueOf(i));
        }
        this.phpStanLevelComboBox.addItem("max");
        this.phpStanLevelComboBox.setRenderer(new PHPStanLevelListCellRenderer(this.phpStanLevelComboBox.getRenderer()));
        this.phpStanLevelComboBox.setSelectedItem(this.getValidLevel());
        this.phpStanLevelComboBox.addItemListener(e -> this.setLevel());
    }

    private String getValidLevel() {
        String level = this.settings.get(LEVEL, AnalysisOptions.getInstance().getPHPStanLevel());
        return AnalysisOptions.getValidPHPStanLevel(level);
    }

    private void initConfigurationTextField() {
        assert (EventQueue.isDispatchThread());
        this.phpStanConfigurationTextField.setText(this.settings.get(CONFIGURATION, AnalysisOptions.getInstance().getPHPStanConfigurationPath()));
        this.phpStanConfigurationTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setConfiguration()));
    }

    private void initMemoryLimitTextField() {
        assert (EventQueue.isDispatchThread());
        this.phpStanMemoryLimitTextField.setText(this.settings.get(MEMORY_LIMIT, AnalysisOptions.getInstance().getPHPStanMemoryLimit()));
        this.phpStanMemoryLimitTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setMemoryLimit()));
    }

    public String getPHPStanPath() {
        return this.phpStanTextField.getText().trim();
    }

    public String getLevel() {
        return (String)this.phpStanLevelComboBox.getSelectedItem();
    }

    public String getConfiguration() {
        return this.phpStanConfigurationTextField.getText().trim();
    }

    public String getMemoryLimit() {
        return this.phpStanMemoryLimitTextField.getText().trim();
    }

    private void setPHPStanEnabled() {
        this.settings.putBoolean(ENABLED, this.phpStanEnabledCheckBox.isSelected());
    }

    private void setPHPStanPath() {
        if (this.validateData()) {
            this.settings.put(PATH, this.getPHPStanPath());
        }
    }

    private void setLevel() {
        this.settings.put(LEVEL, this.getLevel());
    }

    private void setConfiguration() {
        if (this.validateData()) {
            this.settings.put(CONFIGURATION, this.getConfiguration());
        }
    }

    private void setMemoryLimit() {
        if (this.validateData()) {
            this.settings.put(MEMORY_LIMIT, this.getMemoryLimit());
        }
    }

    private boolean validateData() {
        ValidatorPHPStanParameter param = ValidatorPHPStanParameter.create(this);
        ValidationResult result = new AnalysisOptionsValidator().validatePHPStan(param).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setAllComponetsEnabled(boolean isEnabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.phpStanEnabledCheckBox) continue;
            component.setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.phpStanEnabledCheckBox = new JCheckBox();
        this.phpStanConfigurationLabel = new JLabel();
        this.phpStanConfigurationTextField = new JTextField();
        this.phpStanConfigurationBrowseButton = new JButton();
        this.phpStanLevelLabel = new JLabel();
        this.phpStanLevelComboBox = new JComboBox();
        this.phpStanMemoryLimitLabel = new JLabel();
        this.phpStanMemoryLimitTextField = new JTextField();
        this.phpStanLabel = new JLabel();
        this.phpStanTextField = new JTextField();
        this.phpStanBrowseButton = new JButton();
        this.phpStanSearchButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanEnabledCheckBox, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanEnabledCheckBox.text"));
        this.phpStanConfigurationLabel.setLabelFor(this.phpStanConfigurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanConfigurationLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanConfigurationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanConfigurationBrowseButton, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanConfigurationBrowseButton.text"));
        this.phpStanConfigurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanCustomizerPanel.this.phpStanConfigurationBrowseButtonActionPerformed(evt);
            }
        });
        this.phpStanLevelLabel.setLabelFor(this.phpStanLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.phpStanLevelLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanLevelLabel.text"));
        this.phpStanLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"}));
        this.phpStanMemoryLimitLabel.setLabelFor(this.phpStanMemoryLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanMemoryLimitLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanMemoryLimitLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpStanLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanLabel.text"));
        this.phpStanTextField.setText(NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanBrowseButton, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanBrowseButton.text"));
        this.phpStanBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanCustomizerPanel.this.phpStanBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanSearchButton, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanSearchButton.text"));
        this.phpStanSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanCustomizerPanel.this.phpStanSearchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpStanEnabledCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.phpStanLabel, GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanConfigurationLabel).addComponent(this.phpStanLevelLabel).addComponent(this.phpStanMemoryLimitLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanLevelComboBox, -2, -1, -2).addComponent(this.phpStanMemoryLimitTextField, -2, 100, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.phpStanConfigurationTextField).addComponent(this.phpStanTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanBrowseButton, GroupLayout.Alignment.TRAILING).addComponent(this.phpStanConfigurationBrowseButton, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanSearchButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpStanEnabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanLabel).addComponent(this.phpStanTextField, -2, -1, -2).addComponent(this.phpStanBrowseButton).addComponent(this.phpStanSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanConfigurationLabel).addComponent(this.phpStanConfigurationTextField, -2, -1, -2).addComponent(this.phpStanConfigurationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanLevelLabel).addComponent(this.phpStanLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanMemoryLimitLabel).addComponent(this.phpStanMemoryLimitTextField, -2, -1, -2))));
    }

    private void phpStanConfigurationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePHPStanConfiguration();
        if (file != null) {
            this.phpStanConfigurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void phpStanBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePHPStan();
        if (file != null) {
            this.phpStanTextField.setText(file.getAbsolutePath());
        }
    }

    private void phpStanSearchButtonActionPerformed(ActionEvent evt) {
        String phpStan = AnalysisUiUtils.searchPHPStan();
        if (phpStan != null) {
            this.phpStanTextField.setText(phpStan);
        }
    }
}

