/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import javax.servlet.Filter;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.servlet.DispatcherServletCustomizer;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.client.MockMvcHttpConnector;
import org.springframework.test.web.servlet.client.MockMvcWebTestClient;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;

abstract class AbstractMockMvcServerSpec<B extends MockMvcWebTestClient.MockMvcServerSpec<B>>
implements MockMvcWebTestClient.MockMvcServerSpec<B> {
    AbstractMockMvcServerSpec() {
    }

    @Override
    public <T extends B> T filters(Filter ... filters) {
        this.getMockMvcBuilder().addFilters(filters);
        return this.self();
    }

    @Override
    public final <T extends B> T filter(Filter filter, String ... urlPatterns) {
        this.getMockMvcBuilder().addFilter(filter, urlPatterns);
        return this.self();
    }

    @Override
    public <T extends B> T defaultRequest(RequestBuilder requestBuilder) {
        this.getMockMvcBuilder().defaultRequest(requestBuilder);
        return this.self();
    }

    @Override
    public <T extends B> T alwaysExpect(ResultMatcher resultMatcher) {
        this.getMockMvcBuilder().alwaysExpect(resultMatcher);
        return this.self();
    }

    @Override
    public <T extends B> T dispatchOptions(boolean dispatchOptions) {
        this.getMockMvcBuilder().dispatchOptions(dispatchOptions);
        return this.self();
    }

    @Override
    public <T extends B> T dispatcherServletCustomizer(DispatcherServletCustomizer customizer) {
        this.getMockMvcBuilder().addDispatcherServletCustomizer(customizer);
        return this.self();
    }

    @Override
    public <T extends B> T apply(MockMvcConfigurer configurer) {
        this.getMockMvcBuilder().apply(configurer);
        return this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    protected abstract ConfigurableMockMvcBuilder<?> getMockMvcBuilder();

    @Override
    public WebTestClient.Builder configureClient() {
        MockMvc mockMvc = this.getMockMvcBuilder().build();
        MockMvcHttpConnector connector = new MockMvcHttpConnector(mockMvc);
        return WebTestClient.bindToServer(connector);
    }

    @Override
    public WebTestClient build() {
        return this.configureClient().build();
    }
}

