/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.elements;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.refactoring.java.ui.elements.DescriptionFilter;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class SortActionSupport
extends AbstractAction
implements Presenter.Popup {
    private JRadioButtonMenuItem menuItem;

    public final JMenuItem getPopupPresenter() {
        JRadioButtonMenuItem result = this.obtainMenuItem();
        this.updateMenuItem();
        return result;
    }

    protected final JRadioButtonMenuItem obtainMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }
        return this.menuItem;
    }

    protected abstract void updateMenuItem();

    public static final class SortBySourceAction
    extends SortActionSupport {
        private final DescriptionFilter filter;

        public SortBySourceAction(DescriptionFilter filter) {
            this.putValue("Name", NbBundle.getMessage(SortBySourceAction.class, (String)"LBL_SortBySource"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/sortPosition.png", (boolean)false));
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filter.setNaturalSort(true);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.filter.isNaturalSort());
        }
    }

    public static final class SortByNameAction
    extends SortActionSupport {
        private final DescriptionFilter filter;

        public SortByNameAction(DescriptionFilter filter) {
            this.putValue("Name", NbBundle.getMessage(SortByNameAction.class, (String)"LBL_SortByName"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/sortAlpha.png", (boolean)false));
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filter.setNaturalSort(false);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(!this.filter.isNaturalSort());
        }
    }
}

