/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.phing.options.PhingOptions;
import org.netbeans.modules.php.phing.options.PhingOptionsValidator;
import org.netbeans.modules.php.phing.ui.options.PhingOptionsPanel;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class PhingOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "Phing";
    public static final String OPTIONS_SUBPATH = "FrameworksAndTools/Phing";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Phing";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PhingOptionsPanel phingOptionsPanel;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setPhing(this.getPhingOptions().getPhing());
        }
        this.changed = false;
    }

    public void applyChanges() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhingOptionsPanelController.this.getPhingOptions().setPhing(PhingOptionsPanelController.this.getPanel().getPhing());
                PhingOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setPhing(this.getPhingOptions().getPhing());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        PhingOptionsPanel panel = this.getPanel();
        ValidationResult result = new PhingOptionsValidator().validatePhing(panel.getPhing()).getResult();
        if (result.hasErrors()) {
            panel.setError(result.getFirstErrorMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(result.getFirstWarningMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getPhingOptions().getPhing();
        String current = this.getPanel().getPhing().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.phing.ui.options.PhingOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private PhingOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.phingOptionsPanel == null) {
            this.phingOptionsPanel = new PhingOptionsPanel();
            this.phingOptionsPanel.addChangeListener(this);
        }
        return this.phingOptionsPanel;
    }

    private PhingOptions getPhingOptions() {
        return PhingOptions.getInstance();
    }
}

