/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.model.io.jdom;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;

public class NetbeansBuildActionJDOMWriter {
    private DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private String lineSeparator = "\n";

    protected Element findAndReplaceProperties(Counter counter, Element parent, String name, Map props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Iterator<Object> it = props.keySet().iterator();
            Counter innerCounter = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                String key = (String)it.next();
                this.findAndReplaceSimpleElement(innerCounter, element, key, (String)props.get(key), null);
            }
            ArrayList lst = new ArrayList(props.keySet());
            it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String key = elem.getName();
                if (lst.contains(key)) continue;
                it.remove();
            }
        }
        return element;
    }

    protected Element findAndReplaceSimpleElement(Counter counter, Element parent, String name, String text, String defaultValue) {
        Element element;
        if (defaultValue != null && text != null && defaultValue.equals(text) && ((element = parent.getChild(name, parent.getNamespace())) != null && defaultValue.equals(element.getText()) || element == null)) {
            return element;
        }
        boolean shouldExist = text != null;
        Element element2 = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element2.setText(text);
        }
        return element2;
    }

    protected Element findAndReplaceSimpleLists(Counter counter, Element parent, Collection list, String parentName, String childName) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                String value = (String)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childName, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
        return element;
    }

    protected Element findAndReplaceXpp3DOM(Counter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            this.replaceXpp3DOM(element, dom, new Counter(counter.getDepth() + 1));
        }
        return element;
    }

    protected void insertAtPreferredLocation(Element parent, Element child, Counter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter < counter.getCurrentIndex()) {
            Object next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        if (lastText != null && lastText.getTextTrim().length() == 0) {
            lastText = lastText.clone();
        } else {
            Object starter = this.lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                starter = (String)starter + "    ";
            }
            lastText = this.factory.text((String)starter);
        }
        if (parent.getContentSize() == 0) {
            Text finalText = lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - "    ".length()));
            parent.addContent(contentIndex, (Content)finalText);
        }
        parent.addContent(contentIndex, (Content)child);
        parent.addContent(contentIndex, (Content)lastText);
    }

    protected void iterate2NetbeansActionMapping(Counter counter, Element parent, Collection list, String childTag) {
        Iterator it = list.iterator();
        Iterator elIt = parent.getChildren(childTag, parent.getNamespace()).iterator();
        if (!elIt.hasNext()) {
            elIt = null;
        }
        Counter innerCount = new Counter(counter.getDepth() + 1);
        while (it.hasNext()) {
            Element el;
            NetbeansActionMapping value = (NetbeansActionMapping)it.next();
            if (elIt != null && elIt.hasNext()) {
                el = (Element)elIt.next();
                if (!elIt.hasNext()) {
                    elIt = null;
                }
            } else {
                el = this.factory.element(childTag, parent.getNamespace());
                this.insertAtPreferredLocation(parent, el, innerCount);
            }
            this.updateNetbeansActionMapping(value, childTag, innerCount, el);
            innerCount.increaseCount();
        }
        if (elIt != null) {
            while (elIt.hasNext()) {
                elIt.next();
                elIt.remove();
            }
        }
    }

    protected void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, Counter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] childs = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChilds = new ArrayList<Xpp3Dom>();
            domChilds.addAll(Arrays.asList(childs));
            boolean domIndex = false;
            ListIterator it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                Iterator it2 = domChilds.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = (Xpp3Dom)it2.next();
                    if (!dm.getName().equals(elem.getName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChilds.remove(corrDom);
                    this.replaceXpp3DOM(elem, corrDom, new Counter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                parent.removeContent((Content)elem);
            }
            for (Xpp3Dom dm : domChilds) {
                Element elem = this.factory.element(dm.getName(), parent.getNamespace());
                this.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                this.replaceXpp3DOM(elem, dm, new Counter(counter.getDepth() + 1));
            }
        } else if (parentDom.getValue() != null) {
            parent.setText(parentDom.getValue());
        }
    }

    protected void updateActionToGoalMapping(ActionToGoalMapping value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "packaging", value.getPackaging(), null);
        this.iterate2NetbeansActionMapping(innerCount, root, value.getActions(), "action");
    }

    protected Element updateElement(Counter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (element != null && shouldExist) {
            counter.increaseCount();
        }
        if (element == null && shouldExist) {
            element = this.factory.element(name, parent.getNamespace());
            this.insertAtPreferredLocation(parent, element, counter);
            counter.increaseCount();
        }
        if (!shouldExist && element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf((Content)element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().length() == 0) {
                parent.removeContent((Content)txt);
            }
            parent.removeContent((Content)element);
        }
        return element;
    }

    protected void updateNetbeansActionMapping(NetbeansActionMapping value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "actionName", value.getActionName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "displayName", value.getDisplayName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "basedir", value.getBasedir(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "reactor", value.getReactor(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "preAction", value.getPreAction(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "recursive", value.isRecursive() ? null : String.valueOf(value.isRecursive()), "true");
        this.findAndReplaceSimpleLists(innerCount, root, value.getPackagings(), "packagings", "packaging");
        this.findAndReplaceSimpleLists(innerCount, root, value.getGoals(), "goals", "goal");
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        this.findAndReplaceSimpleLists(innerCount, root, value.getActivatedProfiles(), "activatedProfiles", "activatedProfile");
    }

    public void write(ActionToGoalMapping actions, Document document, OutputStreamWriter writer) throws IOException {
        Format format = Format.getRawFormat().setEncoding(writer.getEncoding()).setLineSeparator(System.getProperty("line.separator"));
        this.write(actions, document, writer, format);
    }

    public void write(ActionToGoalMapping actions, Document document, Writer writer, Format jdomFormat) throws IOException {
        this.updateActionToGoalMapping(actions, "actions", new Counter(0), document.getRootElement());
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(jdomFormat);
        outputter.output(document, writer);
    }

    public class Counter {
        private int currentIndex = 0;
        private int level;

        public Counter(int depthLevel) {
            this.level = depthLevel;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }
    }
}

