/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.php.editor.parser.ASTPHP5Parser;
import org.netbeans.modules.php.editor.parser.ASTPHP5Scanner;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandler;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandlerImpl;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class GSFPHPParser
extends Parser
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(GSFPHPParser.class.getName());
    public static final boolean PARSE_BIG_FILES = Boolean.getBoolean("nb.php.parse.big.files");
    public static final int BIG_FILE_SIZE = Integer.getInteger("nb.php.big.file.size", 5000000);
    private static final List<String> REGISTERED_PHP_EXTENSIONS = FileUtil.getMIMETypeExtensions((String)"text/x-php5");
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean shortTags = true;
    private boolean aspTags = false;
    private ParserResult result = null;
    private boolean projectPropertiesListenerAdded = false;
    private static int unitTestCaretPosition = -1;

    static void setUnitTestCaretPosition(int unitTestCaretPosition) {
        GSFPHPParser.unitTestCaretPosition = unitTestCaretPosition;
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void cancel(Parser.CancelReason reason, SourceModificationEvent event) {
        super.cancel(reason, event);
        LOGGER.log(Level.FINE, "ParserTask cancel: {0}", reason.name());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        if (snapshot == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        FileObject fileObject = snapshot.getSource().getFileObject();
        if (!PARSE_BIG_FILES && GSFPHPParser.fileIsTooBig(fileObject)) {
            this.createEmptyResult(snapshot);
            LOGGER.log(Level.INFO, "Parsing of big file cancelled. Size: {0} Name: {1}", new Object[]{fileObject.getSize(), FileUtil.getFileDisplayName((FileObject)fileObject)});
        } else if (!GSFPHPParser.isRegisteredPhpFile(fileObject)) {
            this.createEmptyResult(snapshot);
            LOGGER.log(Level.FINE, "Skipped file extension: {0}\nRegistered extensions: {1}", new Object[]{fileObject.getExt(), REGISTERED_PHP_EXTENSIONS.toString()});
        } else {
            this.processParsing(fileObject, snapshot, event);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Parsing took: {0}ms source: {1}", new Object[]{endTime - startTime, System.identityHashCode(snapshot.getSource())});
    }

    private static boolean fileIsTooBig(FileObject fileObject) {
        return fileObject != null && fileObject.getSize() > (long)BIG_FILE_SIZE;
    }

    private static boolean isRegisteredPhpFile(FileObject fileObject) {
        return fileObject == null || fileObject.getExt().isEmpty() || REGISTERED_PHP_EXTENSIONS.contains(fileObject.getExt().toLowerCase());
    }

    private void createEmptyResult(Snapshot snapshot) {
        Program emptyProgram = new Program(0, 0, Collections.emptyList(), Collections.emptyList());
        this.result = new PHPParseResult(snapshot, emptyProgram);
    }

    private void processParsing(FileObject fileObject, Snapshot snapshot, SourceModificationEvent event) {
        PhpLanguageProperties languageProperties = PhpLanguageProperties.forFileObject((FileObject)fileObject);
        if (!this.projectPropertiesListenerAdded) {
            PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)languageProperties);
            languageProperties.addPropertyChangeListener(weakListener);
            this.projectPropertiesListenerAdded = true;
        }
        this.shortTags = languageProperties.areShortTagsEnabled();
        this.aspTags = languageProperties.areAspTagsEnabled();
        try {
            int caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)event);
            if (caretOffset < 0 && unitTestCaretPosition >= 0) {
                caretOffset = unitTestCaretPosition;
            }
            LOGGER.log(Level.FINE, "caretOffset: {0}", caretOffset);
            Context context = new Context(snapshot, caretOffset);
            this.result = this.parseBuffer(context, Sanitize.NONE, null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Exception during parsing: {0}", exception);
            int end = snapshot.getText().toString().length();
            ASTError error = new ASTError(0, end);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(error);
            Program emptyProgram = new Program(0, end, statements, Collections.emptyList());
            this.result = new PHPParseResult(snapshot, emptyProgram);
        }
    }

    protected PHPParseResult parseBuffer(Context context, Sanitize sanitizing, PHP5ErrorHandler errorHandler) throws Exception {
        PHPParseResult phpParserResult;
        boolean sanitizedSource = false;
        if (errorHandler == null) {
            errorHandler = new PHP5ErrorHandlerImpl(context);
        }
        if (!GSFPHPParser.isParsingWithoutSanitization(sanitizing)) {
            errorHandler.disableHandling();
            boolean ok = this.sanitizeSource(context, sanitizing, errorHandler);
            if (ok) {
                assert (context.getSanitizedPart() != null);
                sanitizedSource = true;
            } else {
                return this.sanitize(context, sanitizing, errorHandler);
            }
        }
        ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(context.getSanitizedSource()), this.shortTags, this.aspTags);
        ASTPHP5Parser parser = new ASTPHP5Parser(scanner);
        FileObject fileObject = context.getSnapshot().getSource().getFileObject();
        parser.setErrorHandler(errorHandler);
        if (fileObject != null) {
            parser.setFileName(fileObject.getNameExt());
        }
        Symbol rootSymbol = parser.parse();
        if (scanner.getCurlyBalance() != 0 && !sanitizedSource) {
            this.sanitizeSource(context, Sanitize.MISSING_CURLY, null);
            if (context.getSanitizedPart() != null) {
                context.setSourceHolder(new StringSourceHolder(context.getSanitizedSource()));
                scanner = new ASTPHP5Scanner(new StringReader(context.getBaseSource()), this.shortTags, this.aspTags);
                parser = new ASTPHP5Parser(scanner);
                if (fileObject != null) {
                    parser.setFileName(fileObject.getNameExt());
                }
                rootSymbol = parser.parse();
            }
        }
        scanner = null;
        parser = null;
        if (rootSymbol != null) {
            Program program = null;
            if (rootSymbol.value instanceof Program) {
                program = (Program)rootSymbol.value;
                List<Statement> statements = program.getStatements();
                boolean ok = true;
                for (Statement statement : statements) {
                    if (statement instanceof NamespaceDeclaration) {
                        Statement st;
                        NamespaceDeclaration ns = (NamespaceDeclaration)statement;
                        Iterator<Statement> iterator = ns.getBody().getStatements().iterator();
                        while (iterator.hasNext() && (ok = this.isStatementOk(st = iterator.next(), context))) {
                        }
                        if (ok) continue;
                        break;
                    }
                    ok = this.isStatementOk(statement, context);
                    if (ok) continue;
                    break;
                }
                if (ok) {
                    phpParserResult = new PHPParseResult(context.getSnapshot(), program);
                } else {
                    rootSymbol = null;
                    statements = null;
                    phpParserResult = this.sanitize(context, sanitizing, errorHandler);
                }
            } else {
                LOGGER.log(Level.FINE, "The parser value is not a Program: {0}", rootSymbol.value);
                rootSymbol = null;
                phpParserResult = this.sanitize(context, sanitizing, errorHandler);
            }
            if (GSFPHPParser.isParsingWithoutSanitization(sanitizing)) {
                phpParserResult.setErrors(errorHandler.displaySyntaxErrors(program));
                program = null;
            }
        } else {
            phpParserResult = this.sanitize(context, sanitizing, errorHandler);
            phpParserResult.setErrors(errorHandler.displayFatalError());
        }
        return phpParserResult;
    }

    private static boolean isParsingWithoutSanitization(Sanitize sanitizing) {
        return sanitizing == Sanitize.NONE || sanitizing == Sanitize.NEVER;
    }

    private boolean isStatementOk(Statement statement, Context context) throws IOException {
        boolean isStatementOk = true;
        if (statement instanceof ASTError) {
            String errorCode = "<?php " + context.getSanitizedSource().substring(statement.getStartOffset(), statement.getEndOffset()) + "?>";
            ASTPHP5Scanner fcScanner = new ASTPHP5Scanner(new StringReader(errorCode), this.shortTags, this.aspTags);
            Symbol token = fcScanner.next_token();
            while (token.sym != 0) {
                if (token.sym == 51 || token.sym == 35 || token.sym == 44 || this.isRequireFunction(token)) {
                    isStatementOk = false;
                    break;
                }
                token = fcScanner.next_token();
            }
        }
        return isStatementOk;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitizing, PHP5ErrorHandler errorHandler) {
        List<PHP5ErrorHandler.SyntaxError> syntaxErrors;
        if (sanitizing == Sanitize.SYNTAX_ERROR_CURRENT && !(syntaxErrors = errorHandler.getSyntaxErrors()).isEmpty()) {
            int end;
            int start;
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            String source = context.getBaseSource();
            String replace = source.substring(start = error.getCurrentToken().left, end = error.getCurrentToken().right);
            if ("}".equals(replace)) {
                return false;
            }
            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start, end), Utils.getSpaces(end - start)));
            return true;
        }
        if (sanitizing == Sanitize.SYNTAX_ERROR_PREVIOUS && !(syntaxErrors = errorHandler.getSyntaxErrors()).isEmpty()) {
            int end;
            int start;
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            String source = context.getBaseSource();
            String replace = source.substring(start = error.getPreviousToken().left, end = error.getPreviousToken().right);
            if ("}".equals(replace)) {
                return false;
            }
            int currentEnd = error.getCurrentToken().right;
            int currentStart = error.getCurrentToken().left;
            String currentReplace = source.substring(currentStart, currentEnd);
            boolean removeComma = true;
            if (currentReplace.equals(",")) {
                end = currentEnd;
                removeComma = false;
            } else if ("?".equals(currentReplace)) {
                removeComma = false;
            }
            if (currentReplace.equals(")") ? this.sanitizeUnionType(source, context, start, replace, currentStart) : currentReplace.equals("\\") && this.sanitizeUnionType(source, context, start, replace, currentEnd)) {
                return true;
            }
            if ("?".equals(replace)) {
                start = this.sanitizingStartPositionForNullableTypes(start, source, removeComma);
            } else {
                char c;
                for (int i = start - 1; i >= 0 && ((c = source.charAt(i)) == '?' || c == ' '); --i) {
                    if (c != '?') continue;
                    start = this.sanitizingStartPositionForNullableTypes(i, source, removeComma);
                    break;
                }
            }
            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start, end), Utils.getSpaces(end - start)));
            return true;
        }
        if (sanitizing == Sanitize.SYNTAX_ERROR_PREVIOUS_LINE && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            String source = context.getBaseSource();
            int end = Utils.getRowEnd(source, error.getPreviousToken().right);
            int start = Utils.getRowStart(source, error.getPreviousToken().left);
            StringBuilder sb = new StringBuilder(end - start);
            for (int index = start; index < end; ++index) {
                if (source.charAt(index) == ' ' || source.charAt(index) == '}' || source.charAt(index) == '\n' || source.charAt(index) == '\r') {
                    sb.append(source.charAt(index));
                    continue;
                }
                sb.append(' ');
            }
            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start, end), sb.toString()));
            return true;
        }
        if (sanitizing == Sanitize.EDITED_LINE && context.getCaretOffset() > 0) {
            String source = context.getBaseSource();
            int start = context.getCaretOffset() - 1;
            int end = context.getCaretOffset();
            char c = source.charAt(start);
            while (start > 0 && c != '\n' && c != '\r' && c != '{' && c != '}') {
                c = source.charAt(--start);
            }
            ++start;
            if (end < source.length()) {
                c = source.charAt(end);
                while (end < source.length() && c != '\n' && c != '\r' && c != '{' && c != '}') {
                    c = source.charAt(end++);
                }
            }
            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start, end), Utils.getSpaces(end - start)));
            return true;
        }
        if (sanitizing == Sanitize.MISSING_CURLY) {
            return this.sanitizeCurly(context);
        }
        if (sanitizing == Sanitize.SYNTAX_ERROR_BLOCK && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            return this.sanitizeRemoveBlock(context, error.getCurrentToken().left);
        }
        if (sanitizing == Sanitize.REQUIRE_FUNCTION_INCOMPLETE && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            int start = Utils.getRowStart(context.getBaseSource(), error.getPreviousToken().left);
            int end = Utils.getRowEnd(context.getBaseSource(), error.getCurrentToken().left);
            return this.sanitizeRequireAndInclude(context, start, end);
        }
        return false;
    }

    private boolean sanitizeUnionType(String source, Context context, int previousStart, String previousError, int end) {
        int unionTypeStart = previousStart - 1;
        int start = -1;
        if (unionTypeStart >= 0) {
            char c = source.charAt(unionTypeStart);
            if (previousError.equals("|") || previousError.equals("\\")) {
                start = this.sanitizingStartPositionForUnionType(unionTypeStart, source);
            } else {
                while ((c == ' ' || c == '\t' || c == '\n' || c == '\r') && --unionTypeStart >= 0) {
                    c = source.charAt(unionTypeStart);
                }
                if (c == '|') {
                    start = this.sanitizingStartPositionForUnionType(unionTypeStart, source);
                }
            }
        }
        if (start >= 0) {
            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start, end), Utils.getSpaces(end - start)));
            return true;
        }
        return false;
    }

    private int sanitizingStartPositionForUnionType(int start, String source) {
        int sanitizingStart = start;
        char c = source.charAt(start);
        while (c != '(' && c != ',' && c != ';' && c != '{' && --sanitizingStart >= 0) {
            c = source.charAt(sanitizingStart);
        }
        if (c == '(' || c == ',' || c == ';' || c == '{') {
            return sanitizingStart + 1;
        }
        return -1;
    }

    private int sanitizingStartPositionForNullableTypes(int start, String source, boolean removeComma) {
        int targetPosition = start;
        boolean found = false;
        boolean finished = false;
        int rowStart = Utils.getRowStart(source, start);
        for (int i = start - 1; i >= rowStart; --i) {
            char c = source.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    --targetPosition;
                    break;
                }
                case ',': {
                    if (!removeComma) break;
                }
                case ':': {
                    found = true;
                    --targetPosition;
                    break;
                }
                default: {
                    finished = true;
                }
            }
            if (finished) break;
            if (!found) continue;
            return targetPosition;
        }
        return start;
    }

    protected boolean sanitizeRequireAndInclude(Context context, int start, int end) {
        try {
            String source = context.getBaseSource();
            String shortOpenTag = "<?";
            String phpOpenDelimiter = shortOpenTag + "php ";
            String actualSource = phpOpenDelimiter + source.substring(start, end) + "?>";
            ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(actualSource), this.shortTags, this.aspTags);
            char delimiter = '0';
            Symbol token = scanner.next_token();
            while (token.sym != 0) {
                if (this.isRequireFunction(token)) {
                    boolean containsOpenParenthese = false;
                    int currentLeftOffset = token.right;
                    char c = actualSource.charAt(currentLeftOffset);
                    if (this.isStringDelimiter(c)) {
                        delimiter = c;
                    } else {
                        ++currentLeftOffset;
                        if (Character.isWhitespace(c)) {
                            while (Character.isWhitespace(actualSource.charAt(currentLeftOffset))) {
                                ++currentLeftOffset;
                            }
                            char cc = actualSource.charAt(currentLeftOffset);
                            if (this.isStringDelimiter(cc)) {
                                delimiter = cc;
                            } else if (cc == '(') {
                                containsOpenParenthese = true;
                                delimiter = actualSource.charAt(++currentLeftOffset);
                            }
                        } else if (c == '(') {
                            containsOpenParenthese = true;
                            delimiter = actualSource.charAt(currentLeftOffset);
                        }
                    }
                    if (this.isStringDelimiter(delimiter)) {
                        char expectedCloseDelimiter = actualSource.charAt(currentLeftOffset + 1);
                        boolean hasCloseDelimiter = false;
                        boolean hasCloseParenthese = false;
                        if (expectedCloseDelimiter == delimiter) {
                            char expectedCloseParenthese;
                            hasCloseDelimiter = true;
                            if ((expectedCloseParenthese = actualSource.charAt(++currentLeftOffset + 1)) == ')') {
                                hasCloseParenthese = true;
                                ++currentLeftOffset;
                            }
                        }
                        boolean canBeSanitized = true;
                        for (int i = 1; i <= this.numberOfSanitizedChars(containsOpenParenthese, hasCloseDelimiter, hasCloseParenthese); ++i) {
                            if (Character.isWhitespace(actualSource.charAt(currentLeftOffset + i))) continue;
                            canBeSanitized = false;
                            break;
                        }
                        if (canBeSanitized) {
                            int sanitizedChars = this.numberOfSanitizedChars(containsOpenParenthese, hasCloseDelimiter, hasCloseParenthese);
                            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start + currentLeftOffset - 1 - (phpOpenDelimiter.length() - shortOpenTag.length()), start + currentLeftOffset + sanitizedChars - phpOpenDelimiter.length() + 1), this.sanitizationString(delimiter, containsOpenParenthese, hasCloseDelimiter, hasCloseParenthese)));
                            return true;
                        }
                        break;
                    }
                }
                token = scanner.next_token();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Exception during 'require' sanitization.", ex);
        }
        return false;
    }

    private boolean isRequireFunction(Symbol token) {
        return token.sym == 83 || token.sym == 84 || token.sym == 80 || token.sym == 81;
    }

    private boolean isStringDelimiter(char c) {
        return c == '\"' || c == '\'';
    }

    private String sanitizationString(char delimiter, boolean containsOpenParenthese, boolean containsCloseDelimiter, boolean containsCloseParenthese) {
        if (containsCloseDelimiter) {
            if (containsOpenParenthese) {
                if (containsCloseParenthese) {
                    return ";";
                }
                return ");";
            }
            return ";";
        }
        if (containsOpenParenthese) {
            return delimiter + ");";
        }
        return delimiter + ";";
    }

    private int numberOfSanitizedChars(boolean containsOpenParenthese, boolean containsCloseDelimiter, boolean containsCloseParenthese) {
        int chars = 1;
        if (containsOpenParenthese) {
            chars += containsCloseParenthese ? 0 : 1;
        }
        return chars += containsCloseDelimiter ? 0 : 1;
    }

    protected boolean sanitizeCurly(Context context) {
        String source = context.getBaseSource();
        ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(source), this.shortTags, this.aspTags);
        Symbol lastPHPToken = null;
        Symbol token = null;
        int bracketCounter = 0;
        int bracketClassCounter = 0;
        SanitizedPart classSanitizedPart = SanitizedPart.NONE;
        try {
            token = scanner.next_token();
            boolean inClass = false;
            int lastOpenInClass = -1;
            while (token.sym != 0) {
                switch (token.sym) {
                    case 51: {
                        char c;
                        if (!inClass) {
                            inClass = true;
                            break;
                        }
                        int index = token.left;
                        int max = bracketClassCounter;
                        for (int i = 0; i < max; ++i) {
                            c = source.charAt(--index);
                            while (index > lastOpenInClass && c != '}' && c != '\n' && c != '\r' && c != '\t' && c != ' ') {
                                c = source.charAt(--index);
                            }
                            if (c == '}' || c == '{') continue;
                            source = source.substring(0, index) + '}' + source.substring(index + 1);
                            classSanitizedPart = this.createNewClassSanitizedPart(classSanitizedPart, source, index);
                            --bracketClassCounter;
                        }
                        if (bracketClassCounter > 0) {
                            c = source.charAt(--index);
                            while (index > 0 && c != '}' && c != '\n' && c != '\r') {
                                c = source.charAt(--index);
                            }
                            if (c == '}') {
                                c = source.charAt(--index);
                            }
                            while (index < source.length() && bracketClassCounter > 0 && (c == '\n' || c == '\r' || c == '\t' || c == ' ')) {
                                source = source.substring(0, index) + '}' + source.substring(index + 1);
                                classSanitizedPart = this.createNewClassSanitizedPart(classSanitizedPart, source, index);
                                --bracketClassCounter;
                                c = source.charAt(--index);
                            }
                        }
                        context.setSanitizedPart(classSanitizedPart);
                        break;
                    }
                    case 70: 
                    case 71: {
                        if (inClass) {
                            ++bracketClassCounter;
                            lastOpenInClass = token.left;
                            break;
                        }
                        ++bracketCounter;
                        break;
                    }
                    case 72: {
                        if (inClass) {
                            if (--bracketClassCounter != 0) break;
                            inClass = false;
                            break;
                        }
                        --bracketCounter;
                        break;
                    }
                }
                if (token.sym != 10) {
                    lastPHPToken = token;
                }
                token = scanner.next_token();
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.INFO, "Exception during calculating missing }", exception);
        }
        int count = bracketCounter + bracketClassCounter;
        if (count > 0 && lastPHPToken != null) {
            String lastTokenText = source.substring(lastPHPToken.left, lastPHPToken.right).trim();
            if ("?>".equals(lastTokenText)) {
                context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(lastPHPToken.left, lastPHPToken.left), Utils.getRepeatingChars('}', count)));
                return true;
            }
            if (token != null && token.sym == 0) {
                context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(token.left, token.left), Utils.getRepeatingChars('}', count)));
                return true;
            }
        }
        return false;
    }

    private SanitizedPart createNewClassSanitizedPart(SanitizedPart classSanitizedPart, String source, int index) {
        OffsetRange offsetRange = classSanitizedPart.getOffsetRange();
        int start = offsetRange.getStart();
        int end = offsetRange.getEnd();
        if (index <= start) {
            start = index;
        }
        if (index + 1 >= end) {
            end = index + 1;
        }
        return new SanitizedPartImpl(new OffsetRange(start, end), source.substring(start, end));
    }

    private boolean sanitizeRemoveBlock(Context context, int index) {
        String source = context.getBaseSource();
        ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(source), this.shortTags, this.aspTags);
        int start = -1;
        int end = -1;
        try {
            Symbol token = scanner.next_token();
            while (token.sym != 0 && end == -1) {
                if (token.sym == 71 && token.left <= index) {
                    start = token.right;
                }
                if (token.sym == 72 && token.left >= index) {
                    end = token.right - 1;
                }
                token = scanner.next_token();
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.INFO, "Exception during removing block", exception);
        }
        if (start > -1 && start < end) {
            context.setSanitizedPart(new SanitizedPartImpl(new OffsetRange(start, end), Utils.getSpaces(end - start)));
            return true;
        }
        return false;
    }

    private PHPParseResult sanitize(Context context, Sanitize sanitizing, PHP5ErrorHandler errorHandler) throws Exception {
        switch (sanitizing) {
            case NONE: 
            case MISSING_CURLY: {
                return this.parseBuffer(context, Sanitize.REQUIRE_FUNCTION_INCOMPLETE, errorHandler);
            }
            case REQUIRE_FUNCTION_INCOMPLETE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_CURRENT, errorHandler);
            }
            case SYNTAX_ERROR_CURRENT: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS, errorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS_LINE, errorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS_LINE: {
                return this.parseBuffer(context, Sanitize.EDITED_LINE, errorHandler);
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_BLOCK, errorHandler);
            }
        }
        int end = context.getBaseSource().length();
        ASTError error = new ASTError(0, end);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(error);
        Program emptyProgram = new Program(0, end, statements, Collections.emptyList());
        return new PHPParseResult(context.getSnapshot(), emptyProgram);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PhpLanguageProperties.PROP_PHP_VERSION.equals(evt.getPropertyName())) {
            this.forceReparsing();
        }
    }

    private void forceReparsing() {
        this.changeSupport.fireChange();
    }

    static {
        LOGGER.log(Level.INFO, "Parsing of big PHP files enabled: {0} (max size: {1})", new Object[]{PARSE_BIG_FILES, BIG_FILE_SIZE});
    }

    public static class Context {
        private final Snapshot snapshot;
        private final int caretOffset;
        private SourceHolder sourceHolder;
        private SanitizedPart sanitizedPart;

        public Context(Snapshot snapshot, int caretOffset) {
            this.snapshot = snapshot;
            this.caretOffset = caretOffset;
            this.sourceHolder = new SnapshotSourceHolder(snapshot);
        }

        public String toString() {
            return "PHPParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        private void setSourceHolder(SourceHolder sourceHolder) {
            this.sourceHolder = sourceHolder;
        }

        public String getBaseSource() {
            return this.sourceHolder.getText();
        }

        public int getCaretOffset() {
            return this.caretOffset;
        }

        public void setSanitizedPart(SanitizedPart sanitizedPart) {
            this.sanitizedPart = sanitizedPart;
        }

        public SanitizedPart getSanitizedPart() {
            return this.sanitizedPart;
        }

        public String getSanitizedSource() {
            StringBuilder sb = new StringBuilder();
            if (this.sanitizedPart == null) {
                sb.append(this.getBaseSource());
            } else {
                OffsetRange offsetRange = this.sanitizedPart.getOffsetRange();
                sb.append(this.getBaseSource().substring(0, offsetRange.getStart())).append(this.sanitizedPart.getText()).append(this.getBaseSource().substring(offsetRange.getEnd()));
            }
            return sb.toString();
        }
    }

    public static enum Sanitize {
        NEVER,
        NONE,
        SYNTAX_ERROR_CURRENT,
        SYNTAX_ERROR_PREVIOUS,
        SYNTAX_ERROR_PREVIOUS_LINE,
        SYNTAX_ERROR_BLOCK,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_CURLY,
        REQUIRE_FUNCTION_INCOMPLETE;

    }

    public static interface SanitizedPart {
        public static final SanitizedPart NONE = new SanitizedPart(){

            @Override
            public OffsetRange getOffsetRange() {
                return OffsetRange.NONE;
            }

            @Override
            public String getText() {
                return "";
            }
        };

        public OffsetRange getOffsetRange();

        public String getText();
    }

    private static class StringSourceHolder
    implements SourceHolder {
        private final String text;

        public StringSourceHolder(String text) {
            assert (text != null);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static interface SourceHolder {
        public String getText();
    }

    public static class SanitizedPartImpl
    implements SanitizedPart {
        private final OffsetRange offsetRange;
        private final String text;

        public SanitizedPartImpl(OffsetRange offsetRange, String text) {
            assert (offsetRange != null);
            assert (text != null);
            this.offsetRange = offsetRange;
            this.text = text;
        }

        @Override
        public OffsetRange getOffsetRange() {
            return this.offsetRange;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static class SnapshotSourceHolder
    implements SourceHolder {
        private final Snapshot snapshot;

        public SnapshotSourceHolder(Snapshot snapshot) {
            assert (snapshot != null);
            this.snapshot = snapshot;
        }

        @Override
        public String getText() {
            return this.snapshot.getText().toString();
        }
    }
}

