/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementClient;
import com.oracle.bmc.adm.model.ApplicationDependency;
import com.oracle.bmc.adm.model.ApplicationDependencyVulnerabilitySummary;
import com.oracle.bmc.adm.model.CreateVulnerabilityAuditDetails;
import com.oracle.bmc.adm.model.SortOrder;
import com.oracle.bmc.adm.model.Vulnerability;
import com.oracle.bmc.adm.model.VulnerabilityAudit;
import com.oracle.bmc.adm.model.VulnerabilityAuditConfiguration;
import com.oracle.bmc.adm.model.VulnerabilityAuditSummary;
import com.oracle.bmc.adm.requests.CreateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyVulnerabilitiesRequest;
import com.oracle.bmc.adm.requests.ListVulnerabilityAuditsRequest;
import com.oracle.bmc.adm.responses.CreateVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.responses.BmcResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.adm.AuditCache;
import org.netbeans.modules.cloud.oracle.adm.AuditException;
import org.netbeans.modules.cloud.oracle.adm.AuditOptions;
import org.netbeans.modules.cloud.oracle.adm.AuditResult;
import org.netbeans.modules.cloud.oracle.adm.Bundle;
import org.netbeans.modules.cloud.oracle.adm.ErrorUtils;
import org.netbeans.modules.cloud.oracle.adm.KnowledgeBaseItem;
import org.netbeans.modules.cloud.oracle.adm.ProjectVulnerability;
import org.netbeans.modules.cloud.oracle.adm.VulnerabilityReport;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.SourceLocation;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class VulnerabilityWorker
implements ErrorProvider {
    private static final RequestProcessor SOURCE_REFRESH_PROCESSOR = new RequestProcessor(VulnerabilityWorker.class.getName());
    private static final Logger LOG = Logger.getLogger(VulnerabilityWorker.class.getName());
    private static final String GOV_DETAIL_URL = "https://nvd.nist.gov/vuln/detail/";
    private static final HashMap<Project, CacheItem> cache = new HashMap();
    private static VulnerabilityWorker instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean replaceCacheItem(CacheItem old, CacheItem novy) {
        HashMap<Project, CacheItem> hashMap = cache;
        synchronized (hashMap) {
            CacheItem registered = cache.get(old.project);
            if (registered != old) {
                return false;
            }
            cache.put(novy.project, novy);
        }
        return true;
    }

    private VulnerabilityWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VulnerabilityWorker getInstance() {
        Class<VulnerabilityWorker> clazz = VulnerabilityWorker.class;
        synchronized (VulnerabilityWorker.class) {
            if (instance == null) {
                instance = new VulnerabilityWorker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String findVulnerability(Project project, AuditOptions auditOptions) throws AuditException {
        AuditResult r = this.vulnerabilityAudit(project, auditOptions);
        return r.getAuditId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditResult vulnerabilityAudit(Project project, AuditOptions auditOptions) throws AuditException {
        if (auditOptions == null) {
            auditOptions = new AuditOptions();
        }
        LOG.log(Level.FINER, "Trying to obtain audit for project {0}, force:{1}", new Object[]{project, auditOptions.isForceAuditExecution()});
        String projectDisplayName = ProjectUtils.getInformation((Project)project).getDisplayName();
        KnowledgeBaseItem kbItem = VulnerabilityWorker.getKnowledgeBaseForProject(project);
        if (kbItem == null) {
            return null;
        }
        ProgressHandle progressHandle = ProgressHandle.createHandle((String)Bundle.MSG_AuditIsRunning(projectDisplayName));
        AtomicBoolean remoteCall = new AtomicBoolean(false);
        if (auditOptions.getAuditName() == null) {
            auditOptions.setAuditName(projectDisplayName);
        }
        try {
            AuditResult auditResult = this.doFindVulnerability(project, kbItem.compartmentId, kbItem.getKey().getValue(), projectDisplayName, auditOptions, progressHandle, remoteCall);
            return auditResult;
        }
        finally {
            if (remoteCall.get()) {
                progressHandle.close();
            }
            kbItem.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuditResult doFindVulnerability(Project project, String compartmentId, String knowledgeBaseId, String projectDisplayName, AuditOptions auditOptions, ProgressHandle progressHandle, AtomicBoolean remoteCall) throws AuditException {
        DependencyResult dr;
        boolean auditDone;
        CacheItem cacheItem;
        block37: {
            ApplicationDependencyManagementClient admClient;
            ArrayList<ApplicationDependency> result = new ArrayList<ApplicationDependency>();
            cacheItem = null;
            VulnerabilityReport savedAudit = null;
            auditDone = false;
            dr = null;
            if (!auditOptions.isForceAuditExecution()) {
                try {
                    savedAudit = AuditCache.getInstance().loadAudit(knowledgeBaseId);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Could not load cached audit data", ex);
                }
                if (savedAudit == null) {
                    remoteCall.set(true);
                    progressHandle.start();
                    progressHandle.progress(Bundle.MSG_SearchingAuditReport());
                    try {
                        admClient = new ApplicationDependencyManagementClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());
                        try {
                            ListVulnerabilityAuditsRequest request = ListVulnerabilityAuditsRequest.builder().compartmentId(compartmentId).knowledgeBaseId(knowledgeBaseId).lifecycleState(VulnerabilityAudit.LifecycleState.Active).sortBy(ListVulnerabilityAuditsRequest.SortBy.TimeCreated).sortOrder(SortOrder.Desc).build();
                            ListVulnerabilityAuditsResponse response = admClient.listVulnerabilityAudits(request);
                            if (!response.getVulnerabilityAuditCollection().getItems().isEmpty()) {
                                VulnerabilityAuditSummary summary = (VulnerabilityAuditSummary)response.getVulnerabilityAuditCollection().getItems().get(0);
                                progressHandle.progress(Bundle.MSG_AuditCollectDependencies());
                                dr = ProjectDependencies.findDependencies((Project)project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.RUNTIME}));
                                this.convert(dr.getRoot(), new HashMap<String, Integer>(), result);
                                cacheItem = this.fetchVulnerabilityItems(project, admClient, dr, summary, projectDisplayName);
                                savedAudit = new VulnerabilityReport(cacheItem.getAudit(), cacheItem.getVulnerabilities());
                            }
                        }
                        finally {
                            admClient.close();
                        }
                    }
                    catch (BmcException ex) {
                        LOG.log(Level.FINE, "Unable to list newest audit for knowledgebase {0}, compartment {1}", new Object[]{knowledgeBaseId, compartmentId});
                    }
                }
            }
            if (savedAudit == null && (auditOptions.isRunIfNotExists() || auditOptions.isForceAuditExecution())) {
                if (remoteCall.compareAndSet(false, true)) {
                    progressHandle.start();
                }
                if (dr == null) {
                    progressHandle.progress(Bundle.MSG_AuditCollectDependencies());
                    dr = ProjectDependencies.findDependencies((Project)project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.RUNTIME}));
                    this.convert(dr.getRoot(), new HashMap<String, Integer>(), result);
                }
                try {
                    admClient = new ApplicationDependencyManagementClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());
                    try {
                        VulnerabilityAuditConfiguration auditConfiguration = VulnerabilityAuditConfiguration.builder().maxPermissibleCvssV2Score(Float.valueOf(1.0f)).maxPermissibleCvssV3Score(Float.valueOf(1.0f)).exclusions(Collections.unmodifiableList(Collections.EMPTY_LIST)).build();
                        CreateVulnerabilityAuditDetails auditDetails = CreateVulnerabilityAuditDetails.builder().compartmentId(compartmentId).knowledgeBaseId(knowledgeBaseId).displayName(auditOptions.getAuditName().replaceAll("[^A-Za-z0-9-_]", "_")).buildType(VulnerabilityAudit.BuildType.Maven).configuration(auditConfiguration).applicationDependencies(result).build();
                        progressHandle.progress(Bundle.MSG_ExecuteAudit());
                        CreateVulnerabilityAuditResponse response = admClient.createVulnerabilityAudit(CreateVulnerabilityAuditRequest.builder().createVulnerabilityAuditDetails(auditDetails).build());
                        if (response.get__httpStatusCode__() != 201 && response.get__httpStatusCode__() != 200) {
                            throw new BmcException(response.get__httpStatusCode__(), null, null, response.getOpcRequestId());
                        }
                        cacheItem = this.waitToAuditFinish(project, admClient, dr, response.getVulnerabilityAudit(), projectDisplayName);
                        auditDone = true;
                        break block37;
                    }
                    finally {
                        admClient.close();
                    }
                }
                catch (BmcException exc) {
                    throw new AuditException(exc.getStatusCode(), exc.getOpcRequestId(), exc.getMessage(), exc);
                }
                finally {
                    progressHandle.finish();
                }
            }
            if (savedAudit != null && cacheItem == null) {
                if (dr == null) {
                    progressHandle.progress(Bundle.MSG_AuditCollectDependencies());
                    dr = ProjectDependencies.findDependencies((Project)project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.RUNTIME}));
                    this.convert(dr.getRoot(), new HashMap<String, Integer>(), result);
                }
                cacheItem = new CacheItem(project, dr, savedAudit);
            }
        }
        if (cacheItem != null) {
            String message;
            HashMap<Project, CacheItem> exc = cache;
            synchronized (exc) {
                cache.put(project, cacheItem);
            }
            HashSet<FileObject> problematicFiles = new HashSet<FileObject>();
            problematicFiles.addAll(cacheItem.getProblematicFiles());
            if (cacheItem.getAudit().getIsSuccess().booleanValue()) {
                message = Bundle.MSG_Audit_Pass(projectDisplayName);
                problematicFiles.addAll(dr.getDependencyFiles());
            } else {
                message = cacheItem.getAudit().getVulnerableArtifactsCount() == 1 ? Bundle.MSG_Audit_Failed_One(projectDisplayName) : Bundle.MSG_Audit_Failed_More(projectDisplayName, cacheItem.getAudit().getVulnerableArtifactsCount());
            }
            if (auditDone && auditOptions.isDisplaySummary()) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, cacheItem.getAudit().getIsSuccess() != false ? 1 : 2));
            }
            Diagnostic.ReporterControl reporter = Diagnostic.findReporterControl((Lookup)Lookup.getDefault(), (FileObject)project.getProjectDirectory());
            reporter.diagnosticChanged(problematicFiles, null);
            ArrayList<ArtifactSpec> arts = new ArrayList<ArtifactSpec>();
            for (ApplicationDependencyVulnerabilitySummary s : cacheItem.getVulnerabilities()) {
                ArtifactSpec spec;
                Dependency d = cacheItem.getDependencyMap().get(s.getGav());
                if (d == null || (spec = d.getArtifact()) == null) continue;
                arts.add(spec);
            }
            AuditResult res = new AuditResult(project, projectDisplayName, ((CacheItem)cacheItem).report.summary.getId(), cacheItem.getDependencyMap().size(), cacheItem.getAudit().getVulnerableArtifactsCount(), arts);
            return res;
        }
        return new AuditResult(project, projectDisplayName, "", 0, 0, Collections.emptyList());
    }

    public static KnowledgeBaseItem getKnowledgeBaseForProject(Project project) {
        ProjectVulnerability vs = (ProjectVulnerability)project.getLookup().lookup(ProjectVulnerability.class);
        return vs != null ? vs.getProjectKnowledgeBase() : null;
    }

    private int convert(Dependency dependency, Map<String, Integer> gavIndex, List<ApplicationDependency> result) {
        String gav = VulnerabilityWorker.createGAV(dependency.getArtifact());
        if (gav == null) {
            return -1;
        }
        Integer n = gavIndex.get(gav);
        if (n != null) {
            return n;
        }
        n = gavIndex.size() + 1;
        gavIndex.put(gav, n);
        ApplicationDependency.Builder builder = ApplicationDependency.builder();
        builder.gav(gav);
        builder.nodeId(Integer.toString(n));
        ArrayList<String> childrenNodeIds = new ArrayList<String>(dependency.getChildren().size());
        for (Dependency childDependency : dependency.getChildren()) {
            int cid = this.convert(childDependency, gavIndex, result);
            if (cid == -1) continue;
            childrenNodeIds.add(Integer.toString(cid));
        }
        builder.applicationDependencyNodeIds(childrenNodeIds);
        result.add(builder.build());
        return n;
    }

    private static String createGAV(ArtifactSpec artifact) {
        if (artifact == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(120);
        sb.append(artifact.getGroupId()).append(':');
        sb.append(artifact.getArtifactId()).append(':');
        sb.append(artifact.getVersionSpec());
        return sb.toString();
    }

    private CacheItem waitToAuditFinish(Project project, ApplicationDependencyManagementClient client, DependencyResult dr, VulnerabilityAudit audit, String projectName) throws AuditException {
        ListVulnerabilityAuditsResponse response;
        List items;
        VulnerabilityAuditSummary auditSummary;
        ListVulnerabilityAuditsRequest request = ListVulnerabilityAuditsRequest.builder().knowledgeBaseId(audit.getKnowledgeBaseId()).id(audit.getId()).build();
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            response = client.listVulnerabilityAudits(request);
            if (response.get__httpStatusCode__() == 200) continue;
            throw new AuditException(response.get__httpStatusCode__(), response.getOpcRequestId(), Bundle.MSG_ListingAuditFailed(projectName), null);
        } while ((auditSummary = (VulnerabilityAuditSummary)(items = response.getVulnerabilityAuditCollection().getItems()).get(0)).getLifecycleState() == VulnerabilityAudit.LifecycleState.Creating);
        return this.fetchVulnerabilityItems(project, client, dr, auditSummary, projectName);
    }

    private CacheItem fetchVulnerabilityItems(Project project, ApplicationDependencyManagementClient client, DependencyResult dr, VulnerabilityAuditSummary auditSummary, String projectName) {
        ArrayList<ApplicationDependencyVulnerabilitySummary> items = new ArrayList<ApplicationDependencyVulnerabilitySummary>();
        if (auditSummary.getVulnerableArtifactsCount() > 0) {
            Object vulners;
            String nextPage = null;
            do {
                ListApplicationDependencyVulnerabilitiesRequest advRequest;
                ListApplicationDependencyVulnerabilitiesRequest.Builder b = ListApplicationDependencyVulnerabilitiesRequest.builder().vulnerabilityAuditId(auditSummary.getId());
                if (nextPage != null) {
                    b.page(nextPage);
                }
                if ((vulners = client.listApplicationDependencyVulnerabilities(advRequest = b.build())).get__httpStatusCode__() != 200) {
                    ErrorUtils.processError((BmcResponse)vulners, Bundle.MSG_ListingVulnerabilitiesFailed());
                    return null;
                }
                vulners.getApplicationDependencyVulnerabilityCollection().getItems().stream().filter(v -> !v.getVulnerabilities().isEmpty()).forEach(v -> items.add((ApplicationDependencyVulnerabilitySummary)v));
            } while ((nextPage = vulners.getOpcNextPage()) != null);
        }
        HashSet<String> mapped = new HashSet<String>();
        VulnerabilityReport report = new VulnerabilityReport(auditSummary, items);
        CacheItem cache = new CacheItem(project, dr, report);
        for (ApplicationDependencyVulnerabilitySummary v2 : items) {
            Dependency dependency;
            List vulnerabilities = v2.getVulnerabilities();
            if (vulnerabilities.isEmpty() || (dependency = cache.getDependencyMap().get(v2.getGav())) == null) continue;
            mapped.add(v2.getGav());
        }
        report.setMappedVulnerabilities(mapped);
        try {
            AuditCache.getInstance().cacheAuditResults(report);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not cache audit results for knowledgebase {0}, compartment {1}, project {2}", new Object[]{auditSummary.getKnowledgeBaseId(), auditSummary.getCompartmentId(), projectName});
            LOG.log(Level.WARNING, "The exception was: ", ex);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends Diagnostic> computeErrors(ErrorProvider.Context context) {
        ArrayList<CacheItem> items;
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        HashMap<Project, CacheItem> hashMap = cache;
        synchronized (hashMap) {
            items = new ArrayList<CacheItem>(cache.values());
        }
        for (CacheItem cacheItem : items) {
            List<Diagnostic> diagnostics = cacheItem.getDiagnosticsForFile(context.file());
            if (diagnostics == null) continue;
            result.addAll(cacheItem.getDiagnosticsForFile(context.file()));
        }
        return result;
    }

    static class CacheItem {
        private final Project project;
        private final DependencyResult dependencyResult;
        private final VulnerabilityReport report;
        private Map<String, Dependency> dependencyMap;
        private ChangeListener depChange;
        private RequestProcessor.Task pendingRefresh;

        public CacheItem(Project project, DependencyResult dependency, VulnerabilityReport report) {
            this.project = project;
            this.dependencyResult = dependency;
            this.report = report;
        }

        public DependencyResult getDependency() {
            return this.dependencyResult;
        }

        public VulnerabilityAuditSummary getAudit() {
            return this.report.summary;
        }

        public List<ApplicationDependencyVulnerabilitySummary> getVulnerabilities() {
            return this.report.items;
        }

        public Map<String, Dependency> getDependencyMap() {
            if (this.dependencyMap == null) {
                this.dependencyMap = new HashMap<String, Dependency>();
                this.buildDependecyMap(this.dependencyResult.getRoot(), this.dependencyMap);
            }
            return this.dependencyMap;
        }

        private void buildDependecyMap(Dependency dependency, Map<String, Dependency> result) {
            String gav = VulnerabilityWorker.createGAV(dependency.getArtifact());
            if (gav != null && result.putIfAbsent(gav, dependency) == null) {
                dependency.getChildren().forEach(childDependency -> this.buildDependecyMap((Dependency)childDependency, result));
            }
        }

        public Set<FileObject> getProblematicFiles() {
            if (this.getAudit().getIsSuccess().booleanValue()) {
                return Collections.EMPTY_SET;
            }
            HashSet<FileObject> result = new HashSet<FileObject>();
            for (ApplicationDependencyVulnerabilitySummary v : this.getVulnerabilities()) {
                Dependency dep;
                List vulnerabilities = v.getVulnerabilities();
                if (vulnerabilities.isEmpty() || (dep = this.getDependencyMap().get(v.getGav())) == null) continue;
                try {
                    SourceLocation declarationRange = this.dependencyResult.getDeclarationRange(dep, null);
                    if (declarationRange == null) {
                        declarationRange = this.dependencyResult.getDeclarationRange(dep, "container");
                    }
                    if (declarationRange == null || declarationRange.getFile() == null) continue;
                    result.add(declarationRange.getFile());
                }
                catch (IOException iOException) {}
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshDependencies(RequestProcessor.Task t) {
            DependencyResult dr = ProjectDependencies.findDependencies((Project)this.project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.RUNTIME}));
            LOG.log(Level.FINER, "{0} - dependencies refreshed", this);
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.pendingRefresh != t) {
                    return;
                }
            }
            cacheItem = this;
            synchronized (cacheItem) {
                if (this.depChange != null) {
                    this.dependencyResult.removeChangeListener(this.depChange);
                }
            }
            CacheItem novy = new CacheItem(this.project, dr, this.report);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{0} - trying to replace for {1}", new Object[]{this, novy});
            }
            if (VulnerabilityWorker.replaceCacheItem(this, novy)) {
                novy.startListening();
                Diagnostic.ReporterControl reporter = Diagnostic.findReporterControl((Lookup)Lookup.getDefault(), (FileObject)this.project.getProjectDirectory());
                HashSet<FileObject> allFiles = new HashSet<FileObject>();
                allFiles.addAll(this.getProblematicFiles());
                allFiles.addAll(novy.getProblematicFiles());
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "{0} - refreshing files: {1}", new Object[]{this, allFiles});
                }
                reporter.diagnosticChanged(novy.getProblematicFiles(), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scheduleDependencyRefresh(ChangeEvent e) {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.pendingRefresh != null) {
                    this.pendingRefresh.cancel();
                }
                RequestProcessor.Task[] task = new RequestProcessor.Task[1];
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "{0} - scheduling refresh for {1}", new Object[]{this, this.project});
                }
                this.pendingRefresh = task[0] = SOURCE_REFRESH_PROCESSOR.post(() -> {
                    CacheItem cacheItem = this;
                    synchronized (cacheItem) {
                        this.refreshDependencies(task[0]);
                    }
                });
            }
        }

        SourceLocation getDependencyRange(Dependency d) throws IOException {
            return this.getDependencyRange(d, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startListening() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.depChange == null) {
                    this.depChange = this::scheduleDependencyRefresh;
                    this.dependencyResult.addChangeListener(this.depChange);
                    LOG.log(Level.FINER, "{0} - start listen for dependencies", this);
                }
            }
        }

        SourceLocation getDependencyRange(Dependency d, String part) throws IOException {
            this.startListening();
            return this.dependencyResult.getDeclarationRange(d, part);
        }

        public List<Diagnostic> getDiagnosticsForFile(FileObject file) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{0} getDiagnostics called for {1}", new Object[]{this, file});
            }
            if (this.getVulnerabilities() == null || this.getVulnerabilities().isEmpty()) {
                return null;
            }
            ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
            for (ApplicationDependencyVulnerabilitySummary v : this.getVulnerabilities()) {
                List vulnerabilities = v.getVulnerabilities();
                if (vulnerabilities.isEmpty()) continue;
                this.startListening();
                Dependency dependency = this.getDependencyMap().get(v.getGav());
                SourceLocation declarationRange = null;
                if (dependency != null) {
                    try {
                        declarationRange = this.getDependencyRange(dependency);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (!(declarationRange != null || dependency == null && this.report.mappedVulnerabilities.contains(v.getGav()))) {
                    try {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "{0} getDiagnostics called for {1}", new Object[]{this, file});
                        }
                        if ((declarationRange = this.getDependencyRange(dependency, "container")) != null) {
                            declarationRange = new SourceLocation(declarationRange.getFile(), declarationRange.getStartOffset(), declarationRange.getStartOffset(), null);
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (declarationRange == null || !declarationRange.hasPosition() || !declarationRange.getFile().equals(file)) continue;
                SourceLocation fDeclarationRange = declarationRange;
                for (Vulnerability vulnerability : vulnerabilities) {
                    String message = String.format(Bundle.MSG_Diagnostic(), this.formatCvssScore(vulnerability.getCvssV2Score()), this.formatCvssScore(vulnerability.getCvssV3Score()), VulnerabilityWorker.createGAV(dependency.getArtifact()));
                    Diagnostic.Builder builder = Diagnostic.Builder.create(() -> fDeclarationRange.getStartOffset(), () -> fDeclarationRange.getEndOffset(), (String)message);
                    builder.setSeverity(Diagnostic.Severity.Warning).setCode(vulnerability.getId());
                    try {
                        builder.setCodeDescription(new URL(VulnerabilityWorker.GOV_DETAIL_URL + vulnerability.getId()));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.INFO, "Could not link to vulnerability: {0}", vulnerability.getId());
                    }
                    result.add(builder.build());
                }
            }
            return result;
        }

        private String formatCvssScore(Float value) {
            if (value != null) {
                return String.format("%.2f", value);
            }
            return Bundle.MSG_NotAvailable();
        }
    }
}

