/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.google.common.base.Preconditions;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.time.Duration;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedResourcePrincipalFederationClient
implements FederationClient,
ProvidesConfigurableRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedResourcePrincipalFederationClient.class);
    private final SessionKeySupplier sessionKeySupplier;
    private volatile SecurityTokenAdapter securityTokenAdapter;
    private final String resourcePrincipalSessionTokenPath;

    public FileBasedResourcePrincipalFederationClient(SessionKeySupplier sessionKeySupplier, String resourcePrincipalSessionTokenPath) {
        this.sessionKeySupplier = (SessionKeySupplier)Preconditions.checkNotNull((Object)sessionKeySupplier);
        this.securityTokenAdapter = new SecurityTokenAdapter(null, sessionKeySupplier);
        this.resourcePrincipalSessionTokenPath = resourcePrincipalSessionTokenPath;
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(true, Optional.empty());
    }

    @Override
    public String getStringClaim(String key) {
        this.refreshAndGetSecurityToken();
        return this.securityTokenAdapter.getStringClaim(key);
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.refreshAndGetSecurityTokenInner(false, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck, Optional<Duration> time) {
        FileBasedResourcePrincipalFederationClient fileBasedResourcePrincipalFederationClient = this;
        synchronized (fileBasedResourcePrincipalFederationClient) {
            if (!doFinalTokenValidityCheck || (time.isPresent() ? !this.securityTokenAdapter.isValid(time) : !this.securityTokenAdapter.isValid())) {
                LOG.info("Refreshing session keys.");
                this.sessionKeySupplier.refreshKeys();
                LOG.info("Getting security token from file.");
                this.securityTokenAdapter = this.getSecurityTokenFromFile();
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }

    protected SecurityTokenAdapter getSecurityTokenFromFile() {
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalArgumentException("Keypair for session was not provided");
        }
        String securityToken = "";
        try {
            securityToken = FileUtils.readFileToString((File)new File(this.resourcePrincipalSessionTokenPath), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("cannot read token from file", e);
        }
        return new SecurityTokenAdapter(securityToken, this.sessionKeySupplier);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        return this.refreshAndGetSecurityTokenInner(false, Optional.of(time));
    }
}

