/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;

public class TreeScanner
extends JCTree.Visitor {
    public void scan(JCTree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    public void scan(List<? extends JCTree> trees) {
        if (trees != null) {
            List<JCTree> l = trees;
            while (l.nonEmpty()) {
                this.scan((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        this.scan(tree.defs);
    }

    @Override
    public void visitPackageDef(JCTree.JCPackageDecl tree) {
        this.scan(tree.annotations);
        this.scan(tree.pid);
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl tree) {
        this.scan(tree.mods);
        this.scan(tree.qualId);
        this.scan(tree.directives);
    }

    @Override
    public void visitExports(JCTree.JCExports tree) {
        this.scan(tree.qualid);
        this.scan(tree.moduleNames);
    }

    @Override
    public void visitOpens(JCTree.JCOpens tree) {
        this.scan(tree.qualid);
        this.scan(tree.moduleNames);
    }

    @Override
    public void visitProvides(JCTree.JCProvides tree) {
        this.scan(tree.serviceName);
        this.scan(tree.implNames);
    }

    @Override
    public void visitRequires(JCTree.JCRequires tree) {
        this.scan(tree.moduleName);
    }

    @Override
    public void visitUses(JCTree.JCUses tree) {
        this.scan(tree.qualid);
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        this.scan(tree.qualid);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.scan(tree.mods);
        this.scan(tree.typarams);
        this.scan(tree.extending);
        this.scan(tree.implementing);
        this.scan(tree.permitting);
        this.scan(tree.defs);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        this.scan(tree.mods);
        this.scan(tree.restype);
        this.scan(tree.typarams);
        this.scan(tree.recvparam);
        this.scan(tree.params);
        this.scan(tree.thrown);
        this.scan(tree.defaultValue);
        this.scan(tree.body);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        this.scan(tree.mods);
        this.scan(tree.vartype);
        this.scan(tree.nameexpr);
        this.scan(tree.init);
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.scan(tree.stats);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        this.scan(tree.body);
        this.scan(tree.cond);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.scan(tree.cond);
        this.scan(tree.body);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        this.scan(tree.init);
        this.scan(tree.cond);
        this.scan(tree.step);
        this.scan(tree.body);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.scan(tree.varOrRecordPattern);
        this.scan(tree.expr);
        this.scan(tree.body);
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        this.scan(tree.body);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.scan(tree.selector);
        this.scan(tree.cases);
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        this.scan(tree.labels);
        this.scan(tree.stats);
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        this.scan(tree.selector);
        this.scan(tree.cases);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.scan(tree.lock);
        this.scan(tree.body);
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        this.scan(tree.resources);
        this.scan(tree.body);
        this.scan(tree.catchers);
        this.scan(tree.finalizer);
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        this.scan(tree.param);
        this.scan(tree.body);
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        this.scan(tree.cond);
        this.scan(tree.truepart);
        this.scan(tree.falsepart);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        this.scan(tree.cond);
        this.scan(tree.thenpart);
        this.scan(tree.elsepart);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        this.scan(tree.value);
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        this.scan(tree.cond);
        this.scan(tree.detail);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        this.scan(tree.typeargs);
        this.scan(tree.meth);
        this.scan(tree.args);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.scan(tree.encl);
        this.scan(tree.typeargs);
        this.scan(tree.clazz);
        this.scan(tree.args);
        this.scan(tree.def);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        this.scan(tree.annotations);
        this.scan(tree.elemtype);
        this.scan(tree.dims);
        for (List<JCTree.JCAnnotation> annos : tree.dimAnnotations) {
            this.scan(annos);
        }
        this.scan(tree.elems);
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        this.scan(tree.body);
        this.scan(tree.params);
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        this.scan(tree.arg);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        this.scan(tree.lhs);
        this.scan(tree.rhs);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.scan(tree.clazz);
        this.scan(tree.expr);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.scan(tree.expr);
        this.scan(tree.pattern);
    }

    @Override
    public void visitBindingPattern(JCTree.JCBindingPattern tree) {
        this.scan(tree.var);
    }

    @Override
    public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel tree) {
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
        this.scan(tree.pat);
        this.scan(tree.guard);
    }

    @Override
    public void visitParenthesizedPattern(JCTree.JCParenthesizedPattern tree) {
        this.scan(tree.pattern);
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern that) {
        this.scan(that.deconstructor);
        this.scan(that.nested);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.scan(tree.indexed);
        this.scan(tree.index);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.scan(tree.selected);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        this.scan(tree.expr);
        this.scan(tree.typeargs);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        this.scan(tree.elemtype);
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        this.scan(tree.clazz);
        this.scan(tree.arguments);
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion tree) {
        this.scan(tree.alternatives);
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
        this.scan(tree.bounds);
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        this.scan(tree.annotations);
        this.scan(tree.bounds);
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        this.scan(tree.kind);
        if (tree.inner != null) {
            this.scan(tree.inner);
        }
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind that) {
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
        this.scan(tree.annotations);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        this.scan(tree.annotationType);
        this.scan(tree.args);
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        this.scan(tree.annotations);
        this.scan(tree.underlyingType);
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.scan(tree.defs);
        this.scan(tree.expr);
    }

    @Override
    public void visitTree(JCTree tree) {
        Assert.error();
    }
}

