/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ModuleNameReader;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import nbjavac.JmodFileWrapper;

public class Locations {
    private Log log;
    private FSInfo fsInfo;
    private boolean warn;
    private ModuleNameReader moduleNameReader;
    private StandardJavaFileManager.PathFactory pathFactory = Paths::get;
    static final Path javaHome = FileSystems.getDefault().getPath(System.getProperty("java.home"), new String[0]);
    static final Path thisSystemModules = javaHome.resolve("lib").resolve("modules");
    Map<Path, FileSystem> fileSystems = new LinkedHashMap<Path, FileSystem>();
    List<Closeable> closeables = new ArrayList<Closeable>();
    private Map<String, String> fsEnv = Collections.emptyMap();
    Map<JavaFileManager.Location, LocationHandler> handlersForLocation;
    Map<Option, LocationHandler> handlersForOption;

    Locations() {
        this.initHandlers();
    }

    Path getPath(String first, String ... more) {
        try {
            return this.pathFactory.getPath(first, more);
        }
        catch (InvalidPathException ipe) {
            throw new IllegalArgumentException(ipe);
        }
    }

    public void close() throws IOException {
        ListBuffer list = new ListBuffer();
        this.closeables.forEach(closeable -> {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                list.add(ex);
            }
        });
        if (list.nonEmpty()) {
            IOException ex = new IOException();
            for (IOException e : list) {
                ex.addSuppressed(e);
            }
            throw ex;
        }
    }

    void update(Log log, boolean warn, FSInfo fsInfo) {
        this.log = log;
        this.warn = warn;
        this.fsInfo = fsInfo;
    }

    void setPathFactory(StandardJavaFileManager.PathFactory f) {
        this.pathFactory = f;
    }

    boolean isDefaultBootClassPath() {
        BootClassPathLocationHandler h = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return h.isDefault();
    }

    boolean isDefaultSystemModulesPath() {
        SystemModulesLocationHandler h = (SystemModulesLocationHandler)this.getHandler(StandardLocation.SYSTEM_MODULES);
        return !h.isExplicit();
    }

    private Iterable<Path> getPathEntries(String searchPath) {
        return this.getPathEntries(searchPath, null);
    }

    private Iterable<Path> getPathEntries(String searchPath, Path emptyPathDefault) {
        ListBuffer<Path> entries = new ListBuffer<Path>();
        for (String s : searchPath.split(Pattern.quote(File.pathSeparator), -1)) {
            if (s.isEmpty()) {
                if (emptyPathDefault == null) continue;
                entries.add(emptyPathDefault);
                continue;
            }
            try {
                entries.add(this.getPath(s, new String[0]));
            }
            catch (IllegalArgumentException e) {
                if (!this.warn) continue;
                this.log.warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.InvalidPath(s));
            }
        }
        return entries;
    }

    public void setMultiReleaseValue(String multiReleaseValue) {
        this.fsEnv = Collections.singletonMap("releaseVersion", multiReleaseValue);
    }

    private boolean contains(Collection<Path> searchPath, Path file) throws IOException {
        URI uri;
        if (searchPath == null) {
            return false;
        }
        Path enclosingJar = null;
        if (file.getFileSystem().provider() == this.fsInfo.getJarFSProvider() && (uri = file.toUri()).getScheme().equals("jar")) {
            String ssp = uri.getSchemeSpecificPart();
            int sep = ssp.lastIndexOf("!");
            if (ssp.startsWith("file:") && sep > 0) {
                enclosingJar = Paths.get(URI.create(ssp.substring(0, sep)));
            }
        }
        Path nf = Locations.normalize(file);
        for (Path p : searchPath) {
            Path np = Locations.normalize(p);
            if (np.getFileSystem() == nf.getFileSystem() && Files.isDirectory(np, new LinkOption[0]) && nf.startsWith(np)) {
                return true;
            }
            if (enclosingJar == null || !Files.isSameFile(enclosingJar, np)) continue;
            return true;
        }
        return false;
    }

    void initHandlers() {
        BasicLocationHandler[] handlers;
        this.handlersForLocation = new HashMap<JavaFileManager.Location, LocationHandler>();
        this.handlersForOption = new EnumMap<Option, LocationHandler>(Option.class);
        for (BasicLocationHandler h : handlers = new BasicLocationHandler[]{new BootClassPathLocationHandler(), new ClassPathLocationHandler(), new SimpleLocationHandler(StandardLocation.SOURCE_PATH, Option.SOURCE_PATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_PATH, Option.PROCESSOR_PATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, Option.PROCESSOR_MODULE_PATH), new OutputLocationHandler(StandardLocation.CLASS_OUTPUT, Option.D), new OutputLocationHandler(StandardLocation.SOURCE_OUTPUT, Option.S), new OutputLocationHandler(StandardLocation.NATIVE_HEADER_OUTPUT, Option.H), new ModuleSourcePathLocationHandler(), new PatchModulesLocationHandler(), new ModulePathLocationHandler(StandardLocation.UPGRADE_MODULE_PATH, Option.UPGRADE_MODULE_PATH), new ModulePathLocationHandler(StandardLocation.MODULE_PATH, Option.MODULE_PATH), new SystemModulesLocationHandler()}) {
            this.handlersForLocation.put(h.location, h);
            for (Option o : h.options) {
                this.handlersForOption.put(o, h);
            }
        }
    }

    boolean handleOption(Option option, String value) {
        LocationHandler h = this.handlersForOption.get((Object)option);
        return h == null ? false : h.handleOption(option, value);
    }

    boolean hasLocation(JavaFileManager.Location location) {
        LocationHandler h = this.getHandler(location);
        return h == null ? false : h.isSet();
    }

    boolean hasExplicitLocation(JavaFileManager.Location location) {
        LocationHandler h = this.getHandler(location);
        return h == null ? false : h.isExplicit();
    }

    Collection<Path> getLocation(JavaFileManager.Location location) {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.getPaths();
    }

    Path getOutputLocation(JavaFileManager.Location location) {
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException();
        }
        LocationHandler h = this.getHandler(location);
        return ((OutputLocationHandler)h).outputDir;
    }

    void setLocation(JavaFileManager.Location location, Iterable<? extends Path> files) throws IOException {
        LocationHandler h = this.getHandler(location);
        if (h == null) {
            h = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new SimpleLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, h);
        }
        h.setPaths(files);
    }

    JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String name) throws IOException {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.getLocationForModule(name);
    }

    JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, Path file) throws IOException {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.getLocationForModule(file);
    }

    void setLocationForModule(JavaFileManager.Location location, String moduleName, Iterable<? extends Path> files) throws IOException {
        LocationHandler h = this.getHandler(location);
        if (h == null) {
            h = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new ModulePathLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, h);
        }
        h.setPathsForModule(moduleName, files);
    }

    String inferModuleName(JavaFileManager.Location location) {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.inferModuleName();
    }

    Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.listLocationsForModules();
    }

    boolean contains(JavaFileManager.Location location, Path file) throws IOException {
        LocationHandler h = this.getHandler(location);
        if (h == null) {
            throw new IllegalArgumentException("unknown location");
        }
        return h.contains(file);
    }

    protected LocationHandler getHandler(JavaFileManager.Location location) {
        LocationHandler locationHandler;
        Objects.requireNonNull(location);
        return location instanceof LocationHandler ? (locationHandler = (LocationHandler)((Object)location)) : this.handlersForLocation.get(location);
    }

    private boolean isArchive(Path file) {
        String n = StringUtils.toLowerCase(file.getFileName().toString());
        return this.fsInfo.isFile(file) && (n.endsWith(".jar") || n.endsWith(".zip"));
    }

    static Path normalize(Path p) {
        try {
            return p.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return p.toAbsolutePath().normalize();
        }
    }

    protected static abstract class LocationHandler {
        protected LocationHandler() {
        }

        abstract boolean handleOption(Option var1, String var2);

        boolean isSet() {
            return this.getPaths() != null;
        }

        abstract boolean isExplicit();

        abstract Collection<Path> getPaths();

        abstract void setPaths(Iterable<? extends Path> var1) throws IOException;

        abstract void setPathsForModule(String var1, Iterable<? extends Path> var2) throws IOException;

        JavaFileManager.Location getLocationForModule(String moduleName) throws IOException {
            return null;
        }

        JavaFileManager.Location getLocationForModule(Path file) throws IOException {
            return null;
        }

        String inferModuleName() {
            return null;
        }

        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            return null;
        }

        abstract boolean contains(Path var1) throws IOException;
    }

    private class BootClassPathLocationHandler
    extends BasicLocationHandler {
        private Collection<Path> searchPath;
        final Map<Option, String> optionValues;
        private boolean isDefault;

        BootClassPathLocationHandler() {
            super(StandardLocation.PLATFORM_CLASS_PATH, Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS);
            this.optionValues = new EnumMap<Option, String>(Option.class);
        }

        boolean isDefault() {
            this.lazy();
            return this.isDefault;
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            option = this.canonicalize(option);
            this.optionValues.put(option, value);
            if (option == Option.BOOT_CLASS_PATH) {
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_PREPEND);
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_APPEND);
            }
            this.searchPath = null;
            return true;
        }

        private Option canonicalize(Option option) {
            switch (option) {
                case XBOOTCLASSPATH: {
                    return Option.BOOT_CLASS_PATH;
                }
                case DJAVA_ENDORSED_DIRS: {
                    return Option.ENDORSEDDIRS;
                }
                case DJAVA_EXT_DIRS: {
                    return Option.EXTDIRS;
                }
            }
            return option;
        }

        @Override
        Collection<Path> getPaths() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        void setPaths(Iterable<? extends Path> files) {
            if (files == null) {
                this.searchPath = null;
            } else {
                this.isDefault = false;
                this.explicit = true;
                SearchPath p = new SearchPath().addFiles(files, false);
                this.searchPath = Collections.unmodifiableCollection(p);
                this.optionValues.clear();
            }
        }

        SearchPath computePath() throws IOException {
            SearchPath path = new SearchPath();
            String bootclasspathOpt = this.optionValues.get((Object)Option.BOOT_CLASS_PATH);
            String endorseddirsOpt = this.optionValues.get((Object)Option.ENDORSEDDIRS);
            String extdirsOpt = this.optionValues.get((Object)Option.EXTDIRS);
            String xbootclasspathPrependOpt = this.optionValues.get((Object)Option.XBOOTCLASSPATH_PREPEND);
            String xbootclasspathAppendOpt = this.optionValues.get((Object)Option.XBOOTCLASSPATH_APPEND);
            path.addFiles(xbootclasspathPrependOpt);
            if (endorseddirsOpt != null) {
                path.addDirectories(endorseddirsOpt);
            } else {
                path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
            }
            if (bootclasspathOpt != null) {
                path.addFiles(bootclasspathOpt);
            } else {
                Collection<Path> systemClasses = this.systemClasses();
                if (systemClasses != null) {
                    path.addFiles(systemClasses, false);
                } else {
                    String files = System.getProperty("sun.boot.class.path");
                    path.addFiles(files, false);
                }
            }
            path.addFiles(xbootclasspathAppendOpt);
            if (extdirsOpt != null) {
                path.addDirectories(extdirsOpt);
            } else {
                Path jfxrt = javaHome.resolve("lib/jfxrt.jar");
                if (Files.exists(jfxrt, new LinkOption[0])) {
                    path.addFile(jfxrt, false);
                }
                path.addDirectories(System.getProperty("java.ext.dirs"), false);
            }
            this.isDefault = xbootclasspathPrependOpt == null && bootclasspathOpt == null && xbootclasspathAppendOpt == null;
            return path;
        }

        private Collection<Path> systemClasses() throws IOException {
            if (Files.isRegularFile(thisSystemModules, new LinkOption[0])) {
                return Collections.singleton(thisSystemModules);
            }
            Path modules = javaHome.resolve("modules");
            if (Files.isDirectory(modules.resolve("java.base"), new LinkOption[0])) {
                try (Stream<Path> listedModules = Files.list(modules);){
                    Collection collection = listedModules.collect(Collectors.toList());
                    return collection;
                }
            }
            return null;
        }

        private void lazy() {
            if (this.searchPath == null) {
                try {
                    this.searchPath = Collections.unmodifiableCollection(this.computePath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        @Override
        boolean contains(Path file) throws IOException {
            return Locations.this.contains(this.searchPath, file);
        }
    }

    private class SystemModulesLocationHandler
    extends BasicLocationHandler {
        private Path systemJavaHome;
        private Path modules;
        private ModuleTable moduleTable;

        SystemModulesLocationHandler() {
            super(StandardLocation.SYSTEM_MODULES, Option.SYSTEM);
            this.systemJavaHome = javaHome;
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            if (value == null) {
                this.systemJavaHome = javaHome;
            } else if (value.equals("none")) {
                this.systemJavaHome = null;
            } else {
                this.update(Locations.this.getPath(value, new String[0]));
            }
            this.modules = null;
            return true;
        }

        @Override
        Collection<Path> getPaths() {
            return this.systemJavaHome == null ? null : Collections.singleton(this.systemJavaHome);
        }

        @Override
        void setPaths(Iterable<? extends Path> files) throws IOException {
            if (files == null) {
                this.systemJavaHome = null;
            } else {
                this.explicit = true;
                Path dir = this.checkSingletonDirectory(files);
                this.update(dir);
            }
        }

        @Override
        void setPathsForModule(String name, Iterable<? extends Path> paths) throws IOException {
            List<Path> checkedPaths = this.checkPaths(paths);
            this.initSystemModules();
            ModuleLocationHandler l = this.moduleTable.get(name);
            if (l == null) {
                l = new ModuleLocationHandler(this, this.location.getName() + "[" + name + "]", name, checkedPaths, true);
                this.moduleTable.add(l);
            } else {
                l.searchPath = checkedPaths;
                this.moduleTable.updatePaths(l);
            }
            this.explicit = true;
        }

        private List<Path> checkPaths(Iterable<? extends Path> paths) throws IOException {
            Objects.requireNonNull(paths);
            ArrayList<Path> validPaths = new ArrayList<Path>();
            for (Path path : paths) {
                validPaths.add(this.checkDirectory(path));
            }
            return validPaths;
        }

        private void update(Path p) {
            if (!(this.isCurrentPlatform(p) || Files.exists(p.resolve("lib").resolve("jrt-fs.jar"), new LinkOption[0]) || Files.exists(this.systemJavaHome.resolve("modules"), new LinkOption[0]))) {
                throw new IllegalArgumentException(p.toString());
            }
            this.systemJavaHome = p;
            this.modules = null;
        }

        private boolean isCurrentPlatform(Path p) {
            try {
                return Files.isSameFile(p, javaHome);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(p.toString(), ex);
            }
        }

        @Override
        JavaFileManager.Location getLocationForModule(String name) throws IOException {
            this.initSystemModules();
            return this.moduleTable.get(name);
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path file) throws IOException {
            this.initSystemModules();
            return this.moduleTable.get(file);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            this.initSystemModules();
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path file) throws IOException {
            this.initSystemModules();
            return this.moduleTable.contains(file);
        }

        private void initSystemModules() throws IOException {
            block16: {
                if (this.moduleTable != null) {
                    return;
                }
                if (this.systemJavaHome == null) {
                    this.moduleTable = new ModuleTable();
                    return;
                }
                if (this.modules == null) {
                    try {
                        FileSystem jrtfs;
                        URI jrtURI = URI.create("jrt:/");
                        if (this.isCurrentPlatform(this.systemJavaHome)) {
                            jrtfs = FileSystems.getFileSystem(jrtURI);
                        } else {
                            try {
                                Map<String, String> attrMap = Collections.singletonMap("java.home", this.systemJavaHome.toString());
                                jrtfs = FileSystems.newFileSystem(jrtURI, attrMap);
                            }
                            catch (ProviderNotFoundException ex) {
                                URL javaHomeURL = this.systemJavaHome.resolve("lib").resolve("jrt-fs.jar").toUri().toURL();
                                ClassLoader currentLoader = Locations.class.getClassLoader();
                                URLClassLoader fsLoader = new URLClassLoader(new URL[]{javaHomeURL}, currentLoader);
                                jrtfs = FileSystems.newFileSystem(jrtURI, Collections.emptyMap(), (ClassLoader)fsLoader);
                                Locations.this.closeables.add(fsLoader);
                            }
                            Locations.this.closeables.add(jrtfs);
                        }
                        this.modules = jrtfs.getPath("/modules", new String[0]);
                    }
                    catch (FileSystemNotFoundException | ProviderNotFoundException e) {
                        this.modules = this.systemJavaHome.resolve("modules");
                        if (Files.exists(this.modules, new LinkOption[0])) break block16;
                        throw new IOException("can't find system classes", e);
                    }
                }
            }
            this.moduleTable = new ModuleTable();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.modules, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path entry : stream) {
                    String moduleName = entry.getFileName().toString();
                    String name = this.location.getName() + "[" + moduleName + "]";
                    ModuleLocationHandler h = new ModuleLocationHandler(this, name, moduleName, Collections.singletonList(entry), false);
                    this.moduleTable.add(h);
                }
            }
        }
    }

    private static abstract class BasicLocationHandler
    extends LocationHandler {
        final JavaFileManager.Location location;
        final Set<Option> options;
        boolean explicit;

        protected BasicLocationHandler(JavaFileManager.Location location, Option ... options) {
            this.location = location;
            this.options = options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options));
        }

        @Override
        void setPathsForModule(String moduleName, Iterable<? extends Path> files) throws IOException {
            throw new UnsupportedOperationException("not supported for " + this.location);
        }

        protected Path checkSingletonDirectory(Iterable<? extends Path> paths) throws IOException {
            Iterator<? extends Path> pathIter = paths.iterator();
            if (!pathIter.hasNext()) {
                throw new IllegalArgumentException("empty path for directory");
            }
            Path path = pathIter.next();
            if (pathIter.hasNext()) {
                throw new IllegalArgumentException("path too long for directory");
            }
            this.checkDirectory(path);
            return path;
        }

        protected Path checkDirectory(Path path) throws IOException {
            Objects.requireNonNull(path);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path + ": does not exist");
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IOException(path + ": not a directory");
            }
            return path;
        }

        @Override
        boolean isExplicit() {
            return this.explicit;
        }
    }

    private class ClassPathLocationHandler
    extends SimpleLocationHandler {
        ClassPathLocationHandler() {
            super(StandardLocation.CLASS_PATH, Option.CLASS_PATH);
        }

        @Override
        Collection<Path> getPaths() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        protected SearchPath computePath(String value) {
            String cp = value;
            if (cp == null) {
                cp = System.getProperty("env.class.path");
            }
            if (cp == null && System.getProperty("application.home") == null) {
                cp = System.getProperty("java.class.path");
            }
            if (cp == null) {
                cp = ".";
            }
            return this.createPath().addFiles(cp);
        }

        @Override
        protected SearchPath createPath() {
            return new SearchPath().expandJarClassPaths(true).emptyPathDefault(Locations.this.getPath(".", new String[0]));
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.setPaths(null);
            }
        }
    }

    private class SimpleLocationHandler
    extends BasicLocationHandler {
        protected Collection<Path> searchPath;

        SimpleLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            this.searchPath = value == null ? null : Collections.unmodifiableCollection(this.createPath().addFiles(value));
            return true;
        }

        @Override
        Collection<Path> getPaths() {
            return this.searchPath;
        }

        @Override
        void setPaths(Iterable<? extends Path> files) {
            SearchPath p;
            if (files == null) {
                p = this.computePath(null);
            } else {
                this.explicit = true;
                p = this.createPath().addFiles(files);
            }
            this.searchPath = Collections.unmodifiableCollection(p);
        }

        protected SearchPath computePath(String value) {
            return this.createPath().addFiles(value);
        }

        protected SearchPath createPath() {
            return new SearchPath();
        }

        @Override
        boolean contains(Path file) throws IOException {
            return Locations.this.contains(this.searchPath, file);
        }
    }

    private class OutputLocationHandler
    extends BasicLocationHandler {
        private Path outputDir;
        private ModuleTable moduleTable;
        private boolean listed;

        OutputLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            this.outputDir = value == null ? null : Locations.this.getPath(value, new String[0]);
            return true;
        }

        @Override
        Collection<Path> getPaths() {
            return this.outputDir == null ? null : Collections.singleton(this.outputDir);
        }

        @Override
        void setPaths(Iterable<? extends Path> paths) throws IOException {
            if (paths == null) {
                this.outputDir = null;
            } else {
                this.explicit = true;
                this.outputDir = this.checkSingletonDirectory(paths);
            }
            this.moduleTable = null;
            this.listed = false;
        }

        @Override
        JavaFileManager.Location getLocationForModule(String name) {
            ModuleLocationHandler l;
            if (this.moduleTable == null) {
                this.moduleTable = new ModuleTable();
            }
            if ((l = this.moduleTable.get(name)) == null) {
                Path out = this.outputDir.resolve(name);
                l = new ModuleLocationHandler(this, this.location.getName() + "[" + name + "]", name, Collections.singletonList(out), true);
                this.moduleTable.add(l);
            }
            return l;
        }

        @Override
        void setPathsForModule(String name, Iterable<? extends Path> paths) throws IOException {
            ModuleLocationHandler l;
            Path out = this.checkSingletonDirectory(paths);
            if (this.moduleTable == null) {
                this.moduleTable = new ModuleTable();
            }
            if ((l = this.moduleTable.get(name)) == null) {
                l = new ModuleLocationHandler(this, this.location.getName() + "[" + name + "]", name, Collections.singletonList(out), true);
                this.moduleTable.add(l);
            } else {
                l.searchPath = Collections.singletonList(out);
                this.moduleTable.updatePaths(l);
            }
            this.explicit = true;
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path file) {
            return this.moduleTable == null ? null : this.moduleTable.get(file);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            if (!this.listed && this.outputDir != null) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.outputDir);){
                    for (Path p : stream) {
                        this.getLocationForModule(p.getFileName().toString());
                    }
                }
                this.listed = true;
            }
            if (this.moduleTable == null || this.moduleTable.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path file) throws IOException {
            if (this.moduleTable != null) {
                return this.moduleTable.contains(file);
            }
            return this.outputDir != null && Locations.normalize(file).startsWith(Locations.normalize(this.outputDir));
        }
    }

    private class ModuleSourcePathLocationHandler
    extends BasicLocationHandler {
        private ModuleTable moduleTable;
        private List<Path> paths;
        private final Predicate<Path> checkModuleInfo;

        ModuleSourcePathLocationHandler() {
            super(StandardLocation.MODULE_SOURCE_PATH, Option.MODULE_SOURCE_PATH);
            this.checkModuleInfo = p -> Files.exists(p.resolve("module-info.java"), new LinkOption[0]);
        }

        @Override
        boolean handleOption(Option option, String value) {
            this.explicit = true;
            this.init(value);
            return true;
        }

        void init(String value) {
            Pattern moduleSpecificForm = Pattern.compile("([\\p{Alnum}$_.]+)=(.*)");
            ArrayList<String> pathsForModules = new ArrayList<String>();
            String modulePattern = null;
            for (String v : value.split("\u0000")) {
                if (moduleSpecificForm.matcher(v).matches()) {
                    pathsForModules.add(v);
                    continue;
                }
                modulePattern = v;
            }
            if (modulePattern != null) {
                this.initFromPattern(modulePattern);
            }
            pathsForModules.forEach(this::initForModule);
        }

        void initForModule(String value) {
            int eq = value.indexOf(61);
            String name = value.substring(0, eq);
            ArrayList<Path> paths = new ArrayList<Path>();
            for (String v : value.substring(eq + 1).split(File.pathSeparator)) {
                try {
                    paths.add(Paths.get(v, new String[0]));
                }
                catch (InvalidPathException e) {
                    throw new IllegalArgumentException("invalid path: " + v, e);
                }
            }
            try {
                this.setPathsForModule(name, paths);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("cannot set path for module " + name, e);
            }
        }

        void initFromPattern(String value) {
            ArrayList<String> segments = new ArrayList<String>();
            for (String s : value.split(File.pathSeparator)) {
                this.expandBraces(s, segments);
            }
            LinkedHashMap<String, List<Path>> map = new LinkedHashMap<String, List<Path>>();
            ArrayList<Path> noSuffixPaths = new ArrayList<Path>();
            boolean anySuffix = false;
            String MARKER = "*";
            for (String seg : segments) {
                Path suffix;
                int markStart = seg.indexOf("*");
                if (markStart == -1) {
                    Path p = Locations.this.getPath(seg, new String[0]);
                    this.add(map, p, null);
                    noSuffixPaths.add(p);
                    continue;
                }
                if (markStart == 0 || !this.isSeparator(seg.charAt(markStart - 1))) {
                    throw new IllegalArgumentException("illegal use of * in " + seg);
                }
                Path prefix = Locations.this.getPath(seg.substring(0, markStart - 1), new String[0]);
                int markEnd = markStart + "*".length();
                if (markEnd == seg.length()) {
                    suffix = null;
                } else {
                    if (!this.isSeparator(seg.charAt(markEnd)) || seg.indexOf("*", markEnd) != -1) {
                        throw new IllegalArgumentException("illegal use of * in " + seg);
                    }
                    suffix = Locations.this.getPath(seg.substring(markEnd + 1), new String[0]);
                    anySuffix = true;
                }
                this.add(map, prefix, suffix);
                if (suffix != null) continue;
                noSuffixPaths.add(prefix);
            }
            this.initModuleTable(map);
            this.paths = anySuffix ? null : noSuffixPaths;
        }

        private void initModuleTable(Map<String, List<Path>> map) {
            this.moduleTable = new ModuleTable();
            map.forEach((modName, modPath) -> {
                boolean hasModuleInfo = modPath.stream().anyMatch(this.checkModuleInfo);
                if (hasModuleInfo) {
                    String locnName = this.location.getName() + "[" + modName + "]";
                    ModuleLocationHandler l = new ModuleLocationHandler(this, locnName, (String)modName, (Collection<Path>)modPath, false);
                    this.moduleTable.add(l);
                }
            });
        }

        private boolean isSeparator(char ch) {
            return ch == File.separatorChar || ch == '/';
        }

        void add(Map<String, List<Path>> map, Path prefix, Path suffix) {
            if (!Files.isDirectory(prefix, new LinkOption[0])) {
                if (Locations.this.warn) {
                    JCDiagnostic.Warning key = Files.exists(prefix, new LinkOption[0]) ? CompilerProperties.Warnings.DirPathElementNotDirectory(prefix) : CompilerProperties.Warnings.DirPathElementNotFound(prefix);
                    Locations.this.log.warning(Lint.LintCategory.PATH, key);
                }
                return;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(prefix, path -> Files.isDirectory(path, new LinkOption[0]));){
                for (Path entry : stream) {
                    Path path2 = suffix == null ? entry : entry.resolve(suffix);
                    if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                    String name = entry.getFileName().toString();
                    List<Path> paths = map.get(name);
                    if (paths == null) {
                        paths = new ArrayList<Path>();
                        map.put(name, paths);
                    }
                    paths.add(path2);
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }

        private void expandBraces(String value, Collection<String> results) {
            int depth = 0;
            int start = -1;
            String prefix = null;
            String suffix = null;
            block9: for (int i = 0; i < value.length(); ++i) {
                switch (value.charAt(i)) {
                    case '{': {
                        if (++depth != 1) continue block9;
                        prefix = value.substring(0, i);
                        suffix = value.substring(this.getMatchingBrace(value, i) + 1);
                        start = i + 1;
                        continue block9;
                    }
                    case ',': {
                        if (depth != 1) continue block9;
                        String elem = value.substring(start, i);
                        this.expandBraces(prefix + elem + suffix, results);
                        start = i + 1;
                        continue block9;
                    }
                    case '}': {
                        String elem;
                        switch (depth) {
                            case 0: {
                                throw new IllegalArgumentException("mismatched braces");
                            }
                            case 1: {
                                elem = value.substring(start, i);
                                this.expandBraces(prefix + elem + suffix, results);
                                return;
                            }
                        }
                        --depth;
                    }
                }
            }
            if (depth > 0) {
                throw new IllegalArgumentException("mismatched braces");
            }
            results.add(value);
        }

        int getMatchingBrace(String value, int offset) {
            int depth = 1;
            block4: for (int i = offset + 1; i < value.length(); ++i) {
                switch (value.charAt(i)) {
                    case '{': {
                        ++depth;
                        continue block4;
                    }
                    case '}': {
                        if (--depth != 0) continue block4;
                        return i;
                    }
                }
            }
            throw new IllegalArgumentException("mismatched braces");
        }

        @Override
        boolean isSet() {
            return this.moduleTable != null;
        }

        @Override
        Collection<Path> getPaths() {
            if (this.paths == null) {
                throw new IllegalStateException("paths not available");
            }
            return this.paths;
        }

        @Override
        void setPaths(Iterable<? extends Path> files) throws IOException {
            LinkedHashMap<String, List<Path>> map = new LinkedHashMap<String, List<Path>>();
            ArrayList<Path> newPaths = new ArrayList<Path>();
            for (Path path : files) {
                this.add(map, path, null);
                newPaths.add(path);
            }
            this.initModuleTable(map);
            this.explicit = true;
            this.paths = Collections.unmodifiableList(newPaths);
        }

        @Override
        void setPathsForModule(String name, Iterable<? extends Path> paths) throws IOException {
            ModuleLocationHandler l;
            List<Path> validPaths = this.checkPaths(paths);
            if (this.moduleTable == null) {
                this.moduleTable = new ModuleTable();
            }
            if ((l = this.moduleTable.get(name)) == null) {
                l = new ModuleLocationHandler(this, this.location.getName() + "[" + name + "]", name, validPaths, true);
                this.moduleTable.add(l);
            } else {
                l.searchPath = validPaths;
                this.moduleTable.updatePaths(l);
            }
            this.explicit = true;
        }

        private List<Path> checkPaths(Iterable<? extends Path> paths) throws IOException {
            Objects.requireNonNull(paths);
            ArrayList<Path> validPaths = new ArrayList<Path>();
            for (Path path : paths) {
                validPaths.add(this.checkDirectory(path));
            }
            return validPaths;
        }

        @Override
        JavaFileManager.Location getLocationForModule(String name) {
            return this.moduleTable == null ? null : this.moduleTable.get(name);
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path file) {
            return this.moduleTable == null ? null : this.moduleTable.get(file);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() {
            if (this.moduleTable == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path file) throws IOException {
            return this.moduleTable == null ? false : this.moduleTable.contains(file);
        }
    }

    private class PatchModulesLocationHandler
    extends BasicLocationHandler {
        private final ModuleTable moduleTable;

        PatchModulesLocationHandler() {
            super(StandardLocation.PATCH_MODULE_PATH, Option.PATCH_MODULE);
            this.moduleTable = new ModuleTable();
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            this.moduleTable.clear();
            for (String v : value.split("\u0000")) {
                int eq = v.indexOf(61);
                if (eq > 0) {
                    String moduleName = v.substring(0, eq);
                    SearchPath mPatchPath = new SearchPath().addFiles(v.substring(eq + 1));
                    String name = this.location.getName() + "[" + moduleName + "]";
                    ModuleLocationHandler h = new ModuleLocationHandler(this, name, moduleName, mPatchPath, false);
                    this.moduleTable.add(h);
                    continue;
                }
                Locations.this.log.error(CompilerProperties.Errors.LocnInvalidArgForXpatch(value));
            }
            return true;
        }

        @Override
        boolean isSet() {
            return !this.moduleTable.isEmpty();
        }

        @Override
        Collection<Path> getPaths() {
            throw new UnsupportedOperationException();
        }

        @Override
        void setPaths(Iterable<? extends Path> files) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void setPathsForModule(String moduleName, Iterable<? extends Path> files) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        JavaFileManager.Location getLocationForModule(String name) throws IOException {
            return this.moduleTable.get(name);
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path file) throws IOException {
            return this.moduleTable.get(file);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path file) throws IOException {
            return this.moduleTable.contains(file);
        }
    }

    private class ModulePathLocationHandler
    extends SimpleLocationHandler {
        private ModuleTable moduleTable;

        ModulePathLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        public boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.setPaths(value == null ? null : Locations.this.getPathEntries(value));
            return true;
        }

        @Override
        public JavaFileManager.Location getLocationForModule(String moduleName) {
            this.initModuleLocations();
            return this.moduleTable.get(moduleName);
        }

        @Override
        public JavaFileManager.Location getLocationForModule(Path file) {
            this.initModuleLocations();
            return this.moduleTable.get(file);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() {
            List<Set<JavaFileManager.Location>> explicitLocationsList;
            Set explicitLocations = this.moduleTable != null ? this.moduleTable.explicitLocations() : Collections.emptySet();
            List<Object> list = explicitLocationsList = !explicitLocations.isEmpty() ? Collections.singletonList(explicitLocations) : Collections.emptyList();
            if (this.searchPath == null) {
                return explicitLocationsList;
            }
            Iterable searchPathLocations = () -> new ModulePathIterator();
            return () -> Iterators.createCompoundIterator(Arrays.asList(explicitLocationsList, searchPathLocations), Iterable::iterator);
        }

        @Override
        boolean contains(Path file) throws IOException {
            if (this.moduleTable == null) {
                this.initModuleLocations();
            }
            return this.moduleTable.contains(file);
        }

        @Override
        void setPaths(Iterable<? extends Path> paths) {
            if (paths != null) {
                for (Path path : paths) {
                    this.checkValidModulePathEntry(path);
                }
            }
            super.setPaths(paths);
            this.moduleTable = null;
        }

        @Override
        void setPathsForModule(String name, Iterable<? extends Path> paths) throws IOException {
            List<Path> checkedPaths = this.checkPaths(paths);
            this.initModuleLocations();
            ModuleLocationHandler l = this.moduleTable.get(name);
            if (l == null) {
                l = new ModuleLocationHandler(this, this.location.getName() + "[" + name + "]", name, checkedPaths, true);
                this.moduleTable.add(l);
            } else {
                l.searchPath = checkedPaths;
                this.moduleTable.updatePaths(l);
            }
            l.explicit = true;
            this.explicit = true;
        }

        private List<Path> checkPaths(Iterable<? extends Path> paths) throws IOException {
            Objects.requireNonNull(paths);
            ArrayList<Path> validPaths = new ArrayList<Path>();
            for (Path path : paths) {
                validPaths.add(this.checkDirectory(path));
            }
            return validPaths;
        }

        private void initModuleLocations() {
            if (this.moduleTable != null) {
                return;
            }
            this.moduleTable = new ModuleTable();
            for (Set<JavaFileManager.Location> set : this.listLocationsForModules()) {
                for (JavaFileManager.Location locn : set) {
                    if (!(locn instanceof ModuleLocationHandler)) continue;
                    ModuleLocationHandler moduleLocationHandler = (ModuleLocationHandler)locn;
                    if (this.moduleTable.nameMap.containsKey(moduleLocationHandler.moduleName)) continue;
                    this.moduleTable.add(moduleLocationHandler);
                }
            }
        }

        private void checkValidModulePathEntry(Path p) {
            if (!Files.exists(p, new LinkOption[0])) {
                return;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                return;
            }
            String name = p.getFileName().toString();
            int lastDot = name.lastIndexOf(".");
            if (lastDot > 0) {
                switch (name.substring(lastDot)) {
                    case ".jar": 
                    case ".jmod": {
                        return;
                    }
                }
            }
            throw new IllegalArgumentException(p.toString());
        }

        private boolean isModuleName(String name) {
            int next;
            int off = 0;
            while ((next = name.indexOf(46, off)) != -1) {
                String id = name.substring(off, next);
                if (!SourceVersion.isName(id)) {
                    return false;
                }
                off = next + 1;
            }
            String last = name.substring(off);
            return SourceVersion.isName(last);
        }

        class ModulePathIterator
        implements Iterator<Set<JavaFileManager.Location>> {
            Iterator<Path> pathIter;
            int pathIndex;
            Set<JavaFileManager.Location> next;

            ModulePathIterator() {
                this.pathIter = ModulePathLocationHandler.this.searchPath.iterator();
                this.pathIndex = 0;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.next == null) {
                    if (this.pathIter.hasNext()) {
                        Path path = this.pathIter.next();
                        this.next = Files.isDirectory(path, new LinkOption[0]) ? this.scanDirectory(path) : this.scanFile(path);
                        ++this.pathIndex;
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Set<JavaFileManager.Location> next() {
                this.hasNext();
                if (this.next != null) {
                    Set<JavaFileManager.Location> result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            private Set<JavaFileManager.Location> scanDirectory(Path path) {
                LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
                Path moduleInfoClass = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                    for (Path entry : stream) {
                        if (entry.endsWith("module-info.class")) {
                            moduleInfoClass = entry;
                            break;
                        }
                        paths.add(entry);
                    }
                }
                catch (IOException | DirectoryIteratorException ignore) {
                    Locations.this.log.error(CompilerProperties.Errors.LocnCantReadDirectory(path));
                    return Collections.emptySet();
                }
                if (moduleInfoClass != null) {
                    try {
                        String moduleName = this.readModuleName(moduleInfoClass);
                        String name = ModulePathLocationHandler.this.location.getName() + "[" + this.pathIndex + ":" + moduleName + "]";
                        ModuleLocationHandler l = new ModuleLocationHandler(ModulePathLocationHandler.this, name, moduleName, Collections.singletonList(path), false);
                        return Collections.singleton(l);
                    }
                    catch (ModuleNameReader.BadClassFile e) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnBadModuleInfo(path));
                        return Collections.emptySet();
                    }
                    catch (IOException e) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(path));
                        return Collections.emptySet();
                    }
                }
                LinkedHashSet<JavaFileManager.Location> result = new LinkedHashSet<JavaFileManager.Location>();
                int index = 0;
                for (Path entry : paths) {
                    Pair<String, Path> module = this.inferModuleName(entry);
                    if (module == null) continue;
                    String moduleName = (String)module.fst;
                    Path modulePath = (Path)module.snd;
                    String name = ModulePathLocationHandler.this.location.getName() + "[" + this.pathIndex + "." + index++ + ":" + moduleName + "]";
                    ModuleLocationHandler l = new ModuleLocationHandler(ModulePathLocationHandler.this, name, moduleName, Collections.singletonList(modulePath), false);
                    result.add(l);
                }
                return result;
            }

            private Set<JavaFileManager.Location> scanFile(Path path) {
                Pair<String, Path> module = this.inferModuleName(path);
                if (module == null) {
                    return Collections.emptySet();
                }
                String moduleName = (String)module.fst;
                Path modulePath = (Path)module.snd;
                String name = ModulePathLocationHandler.this.location.getName() + "[" + this.pathIndex + ":" + moduleName + "]";
                ModuleLocationHandler l = new ModuleLocationHandler(ModulePathLocationHandler.this, name, moduleName, Collections.singletonList(modulePath), false);
                return Collections.singleton(l);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Pair<String, Path> inferModuleName(Path p) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    String name;
                    if (!Files.exists(p.resolve("module-info.class"), new LinkOption[0])) {
                        if (!Files.exists(p.resolve("module-info.sig"), new LinkOption[0])) return null;
                    }
                    if (!SourceVersion.isName(name = p.getFileName().toString())) return null;
                    return new Pair<String, Path>(name, p);
                }
                if (p.getFileName().toString().endsWith(".jar") && Locations.this.fsInfo.exists(p)) {
                    block38: {
                        FileSystemProvider jarFSProvider = Locations.this.fsInfo.getJarFSProvider();
                        if (jarFSProvider == null) {
                            Locations.this.log.error(CompilerProperties.Errors.NoZipfsForArchive(p));
                            return null;
                        }
                        try (FileSystem fs = jarFSProvider.newFileSystem(p, Locations.this.fsEnv);){
                            Path moduleInfoClass = fs.getPath("module-info.class", new String[0]);
                            if (Files.exists(moduleInfoClass, new LinkOption[0])) {
                                String moduleName = this.readModuleName(moduleInfoClass);
                                Pair<String, Path> pair = new Pair<String, Path>(moduleName, p);
                                return pair;
                            }
                            Path mf = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
                            if (!Files.exists(mf, new LinkOption[0])) break block38;
                            try (InputStream in = Files.newInputStream(mf, new OpenOption[0]);){
                                String moduleName;
                                Manifest man = new Manifest(in);
                                Attributes attrs = man.getMainAttributes();
                                if (attrs != null && (moduleName = attrs.getValue(new Attributes.Name("Automatic-Module-Name"))) != null) {
                                    if (ModulePathLocationHandler.this.isModuleName(moduleName)) {
                                        Pair<String, Path> pair = new Pair<String, Path>(moduleName, p);
                                        return pair;
                                    }
                                    Locations.this.log.error(CompilerProperties.Errors.LocnCantGetModuleNameForJar(p));
                                    Pair<String, Path> pair = null;
                                    return pair;
                                }
                            }
                        }
                        catch (ModuleNameReader.BadClassFile e) {
                            Locations.this.log.error(CompilerProperties.Errors.LocnBadModuleInfo(p));
                            return null;
                        }
                        catch (IOException e) {
                            Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(p));
                            return null;
                        }
                    }
                    String fn = p.getFileName().toString();
                    String mn = fn.substring(0, fn.length() - 4);
                    Matcher matcher = Pattern.compile("-(\\d+(\\.|$))").matcher(mn);
                    if (matcher.find()) {
                        int start = matcher.start();
                        mn = mn.substring(0, start);
                    }
                    if (!(mn = mn.replaceAll("[^A-Za-z0-9]", ".").replaceAll("(\\.)(\\1)+", ".").replaceAll("^\\.", "").replaceAll("\\.$", "")).isEmpty()) {
                        return new Pair<String, Path>(mn, p);
                    }
                    Locations.this.log.error(CompilerProperties.Errors.LocnCantGetModuleNameForJar(p));
                    return null;
                }
                if (p.getFileName().toString().endsWith(".jmod")) {
                    try {
                        JmodFileWrapper.checkMagic(p);
                        FileSystem fs = Locations.this.fileSystems.get(p);
                        if (fs == null) {
                            FileSystemProvider jarFSProvider = Locations.this.fsInfo.getJarFSProvider();
                            if (jarFSProvider == null) {
                                Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(p));
                                return null;
                            }
                            fs = jarFSProvider.newFileSystem(p, Collections.emptyMap());
                            try {
                                Path moduleInfoClass = fs.getPath("classes/module-info.class", new String[0]);
                                String moduleName = this.readModuleName(moduleInfoClass);
                                Path modulePath = fs.getPath("classes", new String[0]);
                                Locations.this.fileSystems.put(p, fs);
                                Locations.this.closeables.add(fs);
                                fs = null;
                                Pair<String, Path> pair = new Pair<String, Path>(moduleName, modulePath);
                                return pair;
                            }
                            finally {
                                if (fs != null) {
                                    fs.close();
                                }
                            }
                        }
                    }
                    catch (ModuleNameReader.BadClassFile e) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnBadModuleInfo(p));
                    }
                    catch (IOException e) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(p));
                        return null;
                    }
                }
                if (!Locations.this.warn) return null;
                return null;
            }

            private String readModuleName(Path path) throws IOException, ModuleNameReader.BadClassFile {
                if (Locations.this.moduleNameReader == null) {
                    Locations.this.moduleNameReader = new ModuleNameReader();
                }
                return Locations.this.moduleNameReader.readModuleName(path);
            }
        }
    }

    private class ModuleTable {
        private final Map<String, ModuleLocationHandler> nameMap = new LinkedHashMap<String, ModuleLocationHandler>();
        private final Map<Path, ModuleLocationHandler> pathMap = new LinkedHashMap<Path, ModuleLocationHandler>();

        private ModuleTable() {
        }

        void add(ModuleLocationHandler h) {
            this.nameMap.put(h.moduleName, h);
            for (Path p : h.searchPath) {
                this.pathMap.put(Locations.normalize(p), h);
            }
        }

        void updatePaths(ModuleLocationHandler h) {
            Iterator<Map.Entry<Path, ModuleLocationHandler>> iter = this.pathMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Path, ModuleLocationHandler> e = iter.next();
                if (e.getValue() != h) continue;
                iter.remove();
            }
            for (Path p : h.searchPath) {
                this.pathMap.put(Locations.normalize(p), h);
            }
        }

        ModuleLocationHandler get(String name) {
            return this.nameMap.get(name);
        }

        ModuleLocationHandler get(Path path) {
            while (path != null) {
                ModuleLocationHandler l = this.pathMap.get(path);
                if (l != null) {
                    return l;
                }
                path = path.getParent();
            }
            return null;
        }

        void clear() {
            this.nameMap.clear();
            this.pathMap.clear();
        }

        boolean isEmpty() {
            return this.nameMap.isEmpty();
        }

        boolean contains(Path file) throws IOException {
            return Locations.this.contains(this.pathMap.keySet(), file);
        }

        Set<JavaFileManager.Location> locations() {
            return Collections.unmodifiableSet(this.nameMap.values().stream().collect(Collectors.toSet()));
        }

        Set<JavaFileManager.Location> explicitLocations() {
            return Collections.unmodifiableSet(this.nameMap.entrySet().stream().filter(e -> ((ModuleLocationHandler)e.getValue()).explicit).map(e -> (ModuleLocationHandler)e.getValue()).collect(Collectors.toSet()));
        }
    }

    private class ModuleLocationHandler
    extends LocationHandler
    implements JavaFileManager.Location {
        private final LocationHandler parent;
        private final String name;
        private final String moduleName;
        private final boolean output;
        boolean explicit;
        Collection<Path> searchPath;

        ModuleLocationHandler(LocationHandler parent, String name, String moduleName, Collection<Path> searchPath, boolean output) {
            this.parent = parent;
            this.name = name;
            this.moduleName = moduleName;
            this.searchPath = searchPath;
            this.output = output;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isOutputLocation() {
            return this.output;
        }

        @Override
        boolean handleOption(Option option, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        Collection<Path> getPaths() {
            return Collections.unmodifiableCollection(this.searchPath);
        }

        @Override
        boolean isExplicit() {
            return true;
        }

        @Override
        void setPaths(Iterable<? extends Path> paths) throws IOException {
            this.parent.setPathsForModule(this.moduleName, paths);
        }

        @Override
        void setPathsForModule(String moduleName, Iterable<? extends Path> paths) {
            throw new UnsupportedOperationException("not supported for " + this.name);
        }

        @Override
        String inferModuleName() {
            return this.moduleName;
        }

        @Override
        boolean contains(Path file) throws IOException {
            return Locations.this.contains(this.searchPath, file);
        }

        public String toString() {
            return this.name;
        }
    }

    private class SearchPath
    extends LinkedHashSet<Path> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private final transient Set<Path> canonicalValues = new HashSet<Path>();
        private transient Path emptyPathDefault = null;

        private SearchPath() {
        }

        public SearchPath expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public SearchPath emptyPathDefault(Path x) {
            this.emptyPathDefault = x;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SearchPath addDirectories(String dirs, boolean warn) {
            boolean prev = this.expandJarClassPaths;
            this.expandJarClassPaths = true;
            try {
                if (dirs != null) {
                    for (Path dir : Locations.this.getPathEntries(dirs)) {
                        this.addDirectory(dir, warn);
                    }
                }
                SearchPath searchPath = this;
                return searchPath;
            }
            finally {
                this.expandJarClassPaths = prev;
            }
        }

        public SearchPath addDirectories(String dirs) {
            return this.addDirectories(dirs, Locations.this.warn);
        }

        private void addDirectory(Path dir, boolean warn) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                if (warn) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.DirPathElementNotFound(dir));
                }
                return;
            }
            try (Stream<Path> s = Files.list(dir);){
                s.filter(x$0 -> Locations.this.isArchive(x$0)).forEach(dirEntry -> this.addFile((Path)dirEntry, warn));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SearchPath addFiles(String files, boolean warn) {
            if (files != null) {
                this.addFiles(Locations.this.getPathEntries(files, this.emptyPathDefault), warn);
            }
            return this;
        }

        public SearchPath addFiles(String files) {
            return this.addFiles(files, Locations.this.warn);
        }

        public SearchPath addFiles(Iterable<? extends Path> files, boolean warn) {
            if (files != null) {
                for (Path path : files) {
                    this.addFile(path, warn);
                }
            }
            return this;
        }

        public SearchPath addFiles(Iterable<? extends Path> files) {
            return this.addFiles(files, Locations.this.warn);
        }

        /*
         * Unable to fully structure code
         */
        public void addFile(Path file, boolean warn) {
            if (this.contains(file)) {
                return;
            }
            if (!Locations.access$400(Locations.this).exists(file)) {
                if (warn) {
                    Locations.access$200(Locations.this).warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.PathElementNotFound(file));
                }
                super.add(file);
                return;
            }
            canonFile = Locations.access$400(Locations.this).getCanonicalFile(file);
            if (this.canonicalValues.contains(canonFile)) {
                return;
            }
            if (Locations.access$400(Locations.this).isFile(file) && !file.getFileName().toString().endsWith(".jmod") && !file.endsWith("modules")) {
                if (!Locations.access$500(Locations.this, file)) {
                    try {
                        FileSystems.newFileSystem(file, (ClassLoader)null).close();
                        if (!warn) ** GOTO lbl26
                        Locations.access$200(Locations.this).warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.UnexpectedArchiveFile(file));
                    }
                    catch (IOException | ProviderNotFoundException e) {
                        if (warn) {
                            Locations.access$200(Locations.this).warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.InvalidArchiveFile(file));
                        }
                        return;
                    }
                } else if (Locations.access$400(Locations.this).getJarFSProvider() == null) {
                    Locations.access$200(Locations.this).error(CompilerProperties.Errors.NoZipfsForArchive(file));
                    return;
                }
            }
lbl26:
            // 6 sources

            super.add(file);
            this.canonicalValues.add(canonFile);
            if (this.expandJarClassPaths && Locations.access$400(Locations.this).isFile(file) && !file.endsWith("modules")) {
                this.addJarClassPath(file, warn);
            }
        }

        private void addJarClassPath(Path jarFile, boolean warn) {
            try {
                for (Path f : Locations.this.fsInfo.getJarClassPath(jarFile)) {
                    this.addFile(f, warn);
                }
            }
            catch (IOException e) {
                Locations.this.log.error(CompilerProperties.Errors.ErrorReadingFile(jarFile, JavacFileManager.getMessage(e)));
            }
        }
    }
}

