/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.Collection;
import java.util.Comparator;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxInclude;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstanceCopy;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxReference;
import org.netbeans.modules.javafx2.editor.completion.model.FxScriptFragment;
import org.netbeans.modules.javafx2.editor.completion.model.ImportDecl;
import org.netbeans.modules.javafx2.editor.completion.model.LanguageDecl;
import org.netbeans.modules.javafx2.editor.completion.model.MapProperty;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.modules.javafx2.editor.completion.model.StaticProperty;
import org.netbeans.modules.javafx2.editor.completion.model.XmlNode;
import org.netbeans.modules.javafx2.editor.parser.NodeInfo;

public abstract class FxNodeVisitor {
    private static final Comparator<FxNode> POSITION_COMPARATOR = new Comparator<FxNode>(){

        @Override
        public int compare(FxNode o1, FxNode o2) {
            NodeInfo n1 = o1.i();
            NodeInfo n2 = o2.i();
            int diff = n1.getStart() - n2.getStart();
            if (diff != 0) {
                return diff;
            }
            return 0;
        }
    };

    public void visitNode(FxNode node) {
    }

    public void visitSource(FxModel source) {
        this.visitNode(source);
    }

    public void visitLanguage(LanguageDecl decl) {
        this.visitNode(decl);
    }

    public void visitImport(ImportDecl decl) {
        this.visitNode(decl);
    }

    public void visitInclude(FxInclude decl) {
        this.visitNode(decl);
    }

    public void visitInstance(FxNewInstance decl) {
        this.visitNode(decl);
    }

    public void visitPropertyValue(PropertyValue val) {
        this.visitNode(val);
    }

    public void visitMapProperty(MapProperty p) {
        this.visitNode(p);
    }

    public void visitStaticProperty(StaticProperty p) {
        this.visitNode(p);
    }

    public void visitPropertySetter(PropertySetter p) {
        this.visitNode(p);
    }

    public void visitReference(FxReference ref) {
        this.visitNode(ref);
    }

    public void visitCopy(FxInstanceCopy copy) {
        this.visitNode(copy);
    }

    public void visitEvent(EventHandler eh) {
        this.visitNode(eh);
    }

    public void visitScript(FxScriptFragment script) {
    }

    public void visitElement(XmlNode n) {
        this.visitNode(n);
    }

    public static class ModelTraversal
    extends FxNodeVisitor {
        protected void scan(FxNode node) {
            if (node != null) {
                node.accept(this);
            }
        }

        protected void scan(Collection<? extends FxNode> nodes) {
            if (nodes != null) {
                for (FxNode fxNode : nodes) {
                    this.scan(fxNode);
                }
            }
        }

        protected void scanImports(FxModel model) {
            this.scan(model.getImports());
        }

        @Override
        public void visitSource(FxModel model) {
            super.visitSource(model);
            this.scan(model.getLanguage());
            this.scanImports(model);
            this.scan(model.getDefinitions());
            this.scan(model.getRootComponent());
        }

        @Override
        public void visitCopy(FxInstanceCopy decl) {
            super.visitCopy(decl);
            this.visitBaseInstance(decl);
        }

        public void visitBaseInstance(FxInstance decl) {
            this.scan(decl.getProperties());
            this.scan(decl.getStaticProperties());
            this.scan(decl.getEvents());
            this.scan(decl.getScripts());
        }

        @Override
        public void visitInstance(FxNewInstance decl) {
            super.visitInstance(decl);
            this.visitBaseInstance(decl);
        }

        @Override
        public void visitStaticProperty(StaticProperty p) {
            super.visitStaticProperty(p);
            this.scan(p.getValues());
        }

        @Override
        public void visitPropertySetter(PropertySetter p) {
            super.visitPropertySetter(p);
            this.scan(p.getValues());
        }
    }

    public static class ModelTreeTraversal
    extends FxNodeVisitor {
        protected void scan(FxNode node) {
            if (node != null) {
                node.accept(this);
            }
        }

        protected void scan(Collection<? extends FxNode> nodes) {
            if (nodes != null) {
                for (FxNode fxNode : nodes) {
                    this.scan(fxNode);
                }
            }
        }

        @Override
        public void visitNode(FxNode node) {
            if (node == null) {
                return;
            }
            this.scan(node.i().getChildren());
        }

        @Override
        public void visitCopy(FxInstanceCopy copy) {
            this.visitBaseInstance(copy);
        }

        @Override
        public void visitInclude(FxInclude incl) {
            this.visitBaseInstance(incl);
        }

        @Override
        public void visitInstance(FxNewInstance decl) {
            this.visitBaseInstance(decl);
        }

        protected void visitBaseInstance(FxInstance inst) {
            this.visitNode(inst);
        }
    }
}

