/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.codegen;

import com.sun.source.tree.Scope;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.javafx2.editor.codegen.AddFxPropertyConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddPropertyPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(AddPropertyPanel.class.getName());
    private static ComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final String[] WRITABLE_PROPS = new String[]{"BooleanProperty", "DoubleProperty", "FloatProperty", "IntegerProperty", "ListProperty<?>", "LongProperty", "MapProperty<?,?>", "ObjectProperty<?>", "SetProperty<?>", "StringProperty"};
    private static final String[] READONLY_PROPS = new String[]{"ReadOnlyBooleanProperty", "ReadOnlyDoubleProperty", "ReadOnlyFloatProperty", "ReadOnlyIntegerProperty", "ReadOnlyListProperty<?>", "ReadOnlyLongProperty", "ReadOnlyMapProperty<?,?>", "ReadOnlyObjectProperty<?>", "ReadOnlySetProperty<?>", "ReadOnlyStringProperty"};
    private CompilationController javac;
    private final Scope scope;
    private List<String> existingFields;
    private JButton okButton;
    private final TypeElement readOnlyProperty;
    private final TypeElement property;
    private long time;
    private String oldText;
    private static final RequestProcessor RP = new RequestProcessor("AddFxProperty-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private ButtonGroup accessGroup;
    private JButton browseTypeButton;
    private JLabel equalsLabel;
    private JLabel errorLabel;
    private JCheckBox generateJavadocCheckBox;
    private ButtonGroup getterSetterGroup;
    private JComboBox implemenationCombobox;
    private JTextField initializerTextField;
    private JLabel jLabel1;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JRadioButton packageRadioButton;
    private JRadioButton privateRadioButton;
    private JRadioButton protectedRadioButton;
    private JRadioButton publicRadioButton;
    private JRadioButton readonlyRadioButton;
    private JLabel semicolonLabel;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JRadioButton writableRadioButton;
    private static Icon CLASS_IMAGE_ICON;
    private static EmptyImageIcon EMPTY_IMAGE_ICON;

    public AddPropertyPanel(CompilationController javac, Scope scope, List<String> existingFields, JButton okButton) {
        this.javac = javac;
        this.scope = scope;
        this.existingFields = existingFields;
        this.okButton = okButton;
        this.readOnlyProperty = javac.getElements().getTypeElement("javafx.beans.property.ReadOnlyProperty");
        this.property = javac.getElements().getTypeElement("javafx.beans.property.Property");
        this.initComponents();
        this.typeComboBox.setSelectedIndex(WRITABLE_PROPS.length - 1);
        class DL
        implements DocumentListener,
        Runnable {
            DL() {
            }

            @Override
            public void run() {
                AddPropertyPanel.this.updateType();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        }
        DL documentListener = new DL();
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        ((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(documentListener);
        this.initializerTextField.getDocument().addDocumentListener(documentListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateType();
    }

    private void updateType() {
        int index;
        String text;
        this.time = System.currentTimeMillis();
        Object selectedItem = this.typeComboBox.getSelectedItem();
        String string = text = selectedItem == null ? "" : selectedItem.toString();
        if (this.oldText == null || !this.oldText.contentEquals(text)) {
            this.oldText = text;
            assert (SwingUtilities.isEventDispatchThread());
            if (this.running != null) {
                this.running.cancel();
                this.task.cancel();
                this.running = null;
            }
            if ((text = text.trim()).isEmpty()) {
                this.implemenationCombobox.setModel(EMPTY_MODEL);
                return;
            }
            this.running = new Worker(text);
            this.task = RP.post((Runnable)this.running, 220);
        }
        if ((index = this.findMatchingComboItem()) == -1 && !text.isEmpty()) {
            int last = text.indexOf("<");
            String qType = (last == -1 ? text : text.substring(0, last)).indexOf(46) == -1 ? "javafx.beans.property." + text : text;
            TypeMirror parseType = this.javac.getTreeUtilities().parseType(text, this.scope.getEnclosingClass());
            if (parseType == null || parseType.getKind() == TypeKind.ERROR || parseType.getKind() == TypeKind.OTHER) {
                parseType = this.javac.getTreeUtilities().parseType(qType, this.scope.getEnclosingClass());
            }
            if (parseType == null || parseType.getKind() == TypeKind.ERROR || parseType.getKind() == TypeKind.OTHER) {
                this.writableRadioButton.setEnabled(true);
                this.readonlyRadioButton.setEnabled(true);
            } else {
                TypeMirror erasure = this.javac.getTypes().erasure(parseType);
                TypeMirror propertyErasure = this.javac.getTypes().erasure(this.property.asType());
                if (this.javac.getTypes().isSubtype(erasure, propertyErasure)) {
                    this.writableRadioButton.setSelected(true);
                    this.writableRadioButton.setEnabled(false);
                    this.readonlyRadioButton.setEnabled(false);
                } else {
                    this.readonlyRadioButton.setSelected(true);
                    this.writableRadioButton.setEnabled(false);
                    this.readonlyRadioButton.setEnabled(false);
                }
            }
        } else {
            this.writableRadioButton.setEnabled(true);
            this.readonlyRadioButton.setEnabled(true);
        }
        String error = this.resolveError();
        if (error != null) {
            this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/editor/resources/error-glyph.gif")));
            this.errorLabel.setText(error);
        }
        this.okButton.setEnabled(error == null);
        String warning = null;
        if (warning != null) {
            this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/editor/resources/warning.gif")));
            this.errorLabel.setText(warning);
        }
        this.errorLabel.setVisible(error != null || warning != null);
    }

    private String resolveError() {
        if (this.nameTextField.getText().length() == 0) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_FieldIsEmpty");
        }
        if (((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getText().length() == 0) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_TypeIsEmpty");
        }
        if (this.existingFields.contains(this.nameTextField.getText())) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_FieldAlreadyExists", (Object[])new Object[]{String.valueOf(this.nameTextField.getText())});
        }
        return null;
    }

    public AddFxPropertyConfig getAddPropertyConfig() {
        String propertyType = this.typeComboBox.getSelectedItem().toString().trim();
        String implementationType = this.implemenationCombobox.getSelectedItem().toString().trim();
        String name = this.nameTextField.getText().trim();
        String initializer = this.initializerTextField.getText().trim();
        AddFxPropertyConfig.ACCESS access = AddFxPropertyConfig.ACCESS.PACKAGE;
        if (this.privateRadioButton.isSelected()) {
            access = AddFxPropertyConfig.ACCESS.PRIVATE;
        } else if (this.protectedRadioButton.isSelected()) {
            access = AddFxPropertyConfig.ACCESS.PROTECTED;
        } else if (this.publicRadioButton.isSelected()) {
            access = AddFxPropertyConfig.ACCESS.PUBLIC;
        }
        AddFxPropertyConfig.GENERATE generate = AddFxPropertyConfig.GENERATE.WRITABLE;
        if (!this.writableRadioButton.isSelected()) {
            generate = AddFxPropertyConfig.GENERATE.READ_ONLY;
        }
        if (implementationType.indexOf(60) != -1) {
            if (this.javac.getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0) {
                implementationType = implementationType.substring(0, implementationType.indexOf(60)) + "<>";
            } else {
                int propTemplate = propertyType.indexOf("<");
                if (propTemplate != -1) {
                    implementationType = implementationType.substring(0, implementationType.indexOf(60)) + propertyType.substring(propTemplate);
                }
            }
        }
        AddFxPropertyConfig addPropertyConfig = new AddFxPropertyConfig(name, initializer, propertyType, implementationType, access, generate, this.generateJavadocCheckBox.isSelected());
        return addPropertyConfig;
    }

    private void initComponents() {
        this.accessGroup = new ButtonGroup();
        this.getterSetterGroup = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.equalsLabel = new JLabel();
        this.initializerTextField = new JTextField();
        this.semicolonLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.browseTypeButton = new JButton();
        this.privateRadioButton = new JRadioButton();
        this.packageRadioButton = new JRadioButton();
        this.protectedRadioButton = new JRadioButton();
        this.publicRadioButton = new JRadioButton();
        this.writableRadioButton = new JRadioButton();
        this.readonlyRadioButton = new JRadioButton();
        this.generateJavadocCheckBox = new JCheckBox();
        this.errorLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.implemenationCombobox = new JComboBox();
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.nameTextField.text"));
        this.equalsLabel.setLabelFor(this.initializerTextField);
        Mnemonics.setLocalizedText((JLabel)this.equalsLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.equalsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.semicolonLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.semicolonLabel.text"));
        this.typeLabel.setLabelFor(this.typeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.typeLabel.text"));
        this.typeComboBox.setEditable(true);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(WRITABLE_PROPS));
        this.typeComboBox.setRenderer(new ComboBoxRenderer());
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.typeComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browseTypeButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.browseTypeButton.text"));
        this.browseTypeButton.setToolTipText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.browseTypeButton.toolTipText"));
        this.browseTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.browseTypeButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.privateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.privateRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.privateRadioButton.text"));
        this.privateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.privateRadioButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.packageRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.packageRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.packageRadioButton.text"));
        this.packageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.packageRadioButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.protectedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.protectedRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.protectedRadioButton.text"));
        this.protectedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.protectedRadioButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.publicRadioButton);
        this.publicRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.publicRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.publicRadioButton.text"));
        this.publicRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.publicRadioButtonActionPerformed(evt);
            }
        });
        this.getterSetterGroup.add(this.writableRadioButton);
        this.writableRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.writableRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.writableRadioButton.text"));
        this.writableRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.writableRadioButtonActionPerformed(evt);
            }
        });
        this.getterSetterGroup.add(this.readonlyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.readonlyRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.readonlyRadioButton.text"));
        this.readonlyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.readonlyRadioButtonActionPerformed(evt);
            }
        });
        this.generateJavadocCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateJavadocCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generateJavadocCheckBox.text"));
        this.generateJavadocCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generateJavadocCheckBoxActionPerformed(evt);
            }
        });
        this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/editor/resources/error-glyph.gif")));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getBundle(AddPropertyPanel.class).getString("AddPropertyPanel.errorLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.jLabel1.text"));
        this.implemenationCombobox.setEditable(true);
        this.implemenationCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"SimpleStringProperty"}));
        this.implemenationCombobox.setRenderer(new ComboBoxRenderer());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.typeComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseTypeButton, -2, 86, -2)).addGroup(layout.createSequentialGroup().addComponent(this.nameTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.equalsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.implemenationCombobox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initializerTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.semicolonLabel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.privateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.packageRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protectedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publicRadioButton)).addGroup(layout.createSequentialGroup().addComponent(this.writableRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.readonlyRadioButton)).addComponent(this.generateJavadocCheckBox).addComponent(this.errorLabel)).addGap(0, 238, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.packageRadioButton, this.privateRadioButton, this.protectedRadioButton, this.publicRadioButton, this.readonlyRadioButton, this.writableRadioButton);
        layout.linkSize(0, this.nameLabel, this.typeLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.semicolonLabel).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.equalsLabel).addComponent(this.initializerTextField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.implemenationCombobox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.browseTypeButton).addComponent(this.typeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageRadioButton).addComponent(this.protectedRadioButton).addComponent(this.publicRadioButton).addComponent(this.privateRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.writableRadioButton).addComponent(this.readonlyRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateJavadocCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.AccessibleContext.accessibleDescription"));
    }

    private void privateRadioButtonActionPerformed(ActionEvent evt) {
        this.updateType();
    }

    private void packageRadioButtonActionPerformed(ActionEvent evt) {
        this.updateType();
    }

    private void protectedRadioButtonActionPerformed(ActionEvent evt) {
        this.updateType();
    }

    private void publicRadioButtonActionPerformed(ActionEvent evt) {
        this.updateType();
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        this.updateType();
    }

    private void generateJavadocCheckBoxActionPerformed(ActionEvent evt) {
        this.updateType();
    }

    private void writableRadioButtonActionPerformed(ActionEvent evt) {
        this.switchType(true);
    }

    private void readonlyRadioButtonActionPerformed(ActionEvent evt) {
        this.switchType(false);
    }

    private void browseTypeButtonActionPerformed(ActionEvent evt) {
        final Types types = this.javac.getTypes();
        ElementHandle type = TypeElementFinder.find((ClasspathInfo)this.javac.getClasspathInfo(), (TypeElementFinder.Customizer)(this.readOnlyProperty != null ? new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                TypeElement resolved = (TypeElement)typeHandle.resolve((CompilationInfo)AddPropertyPanel.this.javac);
                if (resolved != null) {
                    return types.isSubtype(types.erasure(resolved.asType()), types.erasure(AddPropertyPanel.this.readOnlyProperty.asType()));
                }
                return false;
            }
        } : null));
        if (type != null) {
            String fqn = type.getQualifiedName().toString();
            this.typeComboBox.setSelectedItem(fqn);
        }
    }

    private int findMatchingComboItem() {
        int index = this.typeComboBox.getSelectedIndex();
        if (index >= 0) {
            return index;
        }
        String orig = this.typeComboBox.getSelectedItem().toString();
        String s = orig;
        int last = s.indexOf("<");
        if (last > -1) {
            s = s.substring(0, last);
        }
        ComboBoxModel mdl = this.typeComboBox.getModel();
        for (int i = 0; i < mdl.getSize(); ++i) {
            String t = mdl.getElementAt(i).toString();
            if (!t.equals(s) && (!t.startsWith(s) || t.length() <= last || t.charAt(last) != orig.charAt(last))) continue;
            return i;
        }
        return -1;
    }

    private void switchType(boolean writable) {
        String suffix;
        int index = this.findMatchingComboItem();
        if (index == -1) {
            return;
        }
        String s = this.typeComboBox.getSelectedItem().toString();
        int last = s.indexOf("<");
        String string = suffix = last == -1 ? "" : s.substring(last);
        if (writable) {
            this.typeComboBox.setModel(new DefaultComboBoxModel<String>(WRITABLE_PROPS));
            this.typeComboBox.setSelectedIndex(index);
        } else {
            this.typeComboBox.setModel(new DefaultComboBoxModel<String>(READONLY_PROPS));
            this.typeComboBox.setSelectedIndex(index);
        }
        if (last != -1) {
            String newType = this.typeComboBox.getSelectedItem().toString();
            int idx = newType.indexOf("<?>");
            if (idx != -1) {
                newType = newType.substring(0, idx) + suffix;
            }
            this.typeComboBox.setSelectedItem(newType);
        }
    }

    private static Icon getClassIcon() {
        if (CLASS_IMAGE_ICON == null) {
            CLASS_IMAGE_ICON = ElementIcons.getElementIcon((ElementKind)ElementKind.CLASS, EnumSet.noneOf(Modifier.class));
        }
        return CLASS_IMAGE_ICON;
    }

    private static Icon getEmptyIcon() {
        if (EMPTY_IMAGE_ICON == null) {
            EMPTY_IMAGE_ICON = new EmptyImageIcon();
        }
        return EMPTY_IMAGE_ICON;
    }

    private class Worker
    implements Runnable {
        public static final String JAVAFXBEANSPROPERTY = "javafx.beans.property.";
        private volatile boolean canceled = false;
        private final String text;
        private final long createTime;

        public Worker(String text) {
            this.text = text;
            this.createTime = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "Worker for {0} - created after {1} ms.", new Object[]{text, System.currentTimeMillis() - AddPropertyPanel.this.time});
        }

        @Override
        public void run() {
            while (true) {
                int[] retry = new int[1];
                LOGGER.log(Level.FINE, "Worker for {0} - started {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                final List<? extends String> types = this.getTypeNames(this.text, retry);
                if (this.canceled) {
                    LOGGER.log(Level.FINE, "Worker for {0} exited after cancel {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                    return;
                }
                final DefaultComboBoxModel<String> fmodel = new DefaultComboBoxModel<String>(types.toArray(new String[types.size()]));
                if (this.canceled) {
                    LOGGER.log(Level.FINE, "Worker for {0} exited after cancel {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                    return;
                }
                if (!this.canceled && fmodel != null) {
                    LOGGER.log(Level.FINE, "Worker for text {0} finished after {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int prevIndex = AddPropertyPanel.this.implemenationCombobox.getSelectedIndex();
                            Object prevItem = AddPropertyPanel.this.implemenationCombobox.getSelectedItem();
                            AddPropertyPanel.this.implemenationCombobox.setModel(fmodel);
                            int typeIndex = AddPropertyPanel.this.findMatchingComboItem();
                            if (prevIndex == -1) {
                                AddPropertyPanel.this.implemenationCombobox.setSelectedItem(prevItem);
                            } else if (typeIndex >= 0) {
                                int index = -1;
                                if (AddPropertyPanel.this.writableRadioButton.isSelected()) {
                                    for (int i = 0; i < types.size(); ++i) {
                                        String value = (String)types.get(i);
                                        if (!value.startsWith("Simple", value.lastIndexOf(46) + 1)) continue;
                                        index = i;
                                        break;
                                    }
                                } else {
                                    for (int i = 0; i < types.size(); ++i) {
                                        String value = (String)types.get(i);
                                        if (!value.endsWith("Wrapper")) continue;
                                        index = i;
                                        break;
                                    }
                                }
                                if (index >= 0) {
                                    AddPropertyPanel.this.implemenationCombobox.setSelectedIndex(index);
                                }
                            }
                        }
                    });
                }
                if (retry[0] <= 0) break;
                try {
                    Thread.sleep(retry[0]);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (AddPropertyPanel.this.time != -1L) {
                LOGGER.log(Level.FINE, "Worker for text {0} canceled after {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
            }
            Worker worker = this;
            synchronized (worker) {
                this.canceled = true;
            }
        }

        private List<? extends String> getTypeNames(String text, int[] retry) {
            ArrayList<String> items = new ArrayList<String>();
            String[] message = new String[1];
            assert (RP.isRequestProcessorThread());
            DeclaredType typeElement = (DeclaredType)AddPropertyPanel.this.javac.getTreeUtilities().parseType(text, AddPropertyPanel.this.scope.getEnclosingClass());
            if (!(typeElement != null && typeElement.getKind() != TypeKind.ERROR || (typeElement = (DeclaredType)AddPropertyPanel.this.javac.getTreeUtilities().parseType(JAVAFXBEANSPROPERTY + text, AddPropertyPanel.this.scope.getEnclosingClass())) != null && typeElement.getKind() != TypeKind.ERROR)) {
                return items;
            }
            if (this.canceled) {
                return null;
            }
            ClassIndex classIndex = AddPropertyPanel.this.javac.getClasspathInfo().getClassIndex();
            Set<ElementHandle<TypeElement>> elements = this.getImplementorsAsHandles(classIndex, (TypeElement)typeElement.asElement());
            for (ElementHandle<TypeElement> elementHandle : elements) {
                TypeElement resolved;
                StringBuilder qualifiedName = new StringBuilder(elementHandle.getQualifiedName());
                if (qualifiedName.indexOf("javafx.") == 0 && qualifiedName.indexOf(JAVAFXBEANSPROPERTY) != 0 || qualifiedName.indexOf("javafx.beans.property.adapter.") == 0 || qualifiedName.indexOf("com.sun.") == 0 || (resolved = (TypeElement)elementHandle.resolve((CompilationInfo)AddPropertyPanel.this.javac)) == null || resolved.getModifiers().contains((Object)Modifier.ABSTRACT) || !AddPropertyPanel.this.javac.getTrees().isAccessible(AddPropertyPanel.this.scope, resolved)) continue;
                if (qualifiedName.indexOf(JAVAFXBEANSPROPERTY) == 0) {
                    qualifiedName = qualifiedName.delete(0, JAVAFXBEANSPROPERTY.length());
                }
                if (!resolved.getTypeParameters().isEmpty()) {
                    qualifiedName.append("<");
                    boolean afterFirst = false;
                    for (int i = 0; i < resolved.getTypeParameters().size(); ++i) {
                        if (afterFirst) {
                            qualifiedName.append(",");
                        }
                        qualifiedName.append("?");
                        afterFirst = true;
                    }
                    qualifiedName.append(">");
                }
                items.add(qualifiedName.toString());
            }
            if (this.canceled) {
                return null;
            }
            return items;
        }

        private Set<ElementHandle<TypeElement>> getImplementorsAsHandles(ClassIndex idx, TypeElement el) {
            LinkedList<ElementHandle<TypeElement>> elements = new LinkedList<ElementHandle<TypeElement>>(this.implementorsQuery(idx, (ElementHandle<TypeElement>)ElementHandle.create((Element)el)));
            HashSet<ElementHandle<TypeElement>> result = new HashSet<ElementHandle<TypeElement>>();
            while (!elements.isEmpty()) {
                if (this.canceled) {
                    return Collections.emptySet();
                }
                ElementHandle<TypeElement> next = elements.removeFirst();
                if (!result.add(next)) continue;
                Set<ElementHandle<TypeElement>> foundElements = this.implementorsQuery(idx, next);
                elements.addAll(foundElements);
            }
            return result;
        }

        private Set<ElementHandle<TypeElement>> implementorsQuery(ClassIndex idx, ElementHandle<TypeElement> next) {
            return idx.getElements(next, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        }
    }

    private static class EmptyImageIcon
    implements Icon {
        private static final int WIDTH = 16;
        private static final int HEIGHT = 16;

        private EmptyImageIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                String text = (String)value;
                text = text.substring(text.lastIndexOf(46) + 1);
                this.setText(text);
                this.setIcon(AddPropertyPanel.getClassIcon());
            } else {
                this.setText(null);
                this.setIcon(AddPropertyPanel.getEmptyIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

