/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.text.Format;
import java.util.Locale;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.builtin.stringvalidation.DisallowCharactersValidator;
import org.netbeans.validation.api.builtin.stringvalidation.EmailAddressValidator;
import org.netbeans.validation.api.builtin.stringvalidation.EmptyStringIllegalValidator;
import org.netbeans.validation.api.builtin.stringvalidation.EncodableInCharsetValidator;
import org.netbeans.validation.api.builtin.stringvalidation.FileValidator;
import org.netbeans.validation.api.builtin.stringvalidation.FormatValidator;
import org.netbeans.validation.api.builtin.stringvalidation.HostNameValidator;
import org.netbeans.validation.api.builtin.stringvalidation.IllegalCharactersInFileNameValidator;
import org.netbeans.validation.api.builtin.stringvalidation.IpAddressValidator;
import org.netbeans.validation.api.builtin.stringvalidation.IsANumberValidator;
import org.netbeans.validation.api.builtin.stringvalidation.IsAnIntegerValidator;
import org.netbeans.validation.api.builtin.stringvalidation.MaximumLength;
import org.netbeans.validation.api.builtin.stringvalidation.MayNotContainSpacesValidator;
import org.netbeans.validation.api.builtin.stringvalidation.MayNotEndWithValidator;
import org.netbeans.validation.api.builtin.stringvalidation.MayNotStartWithDigit;
import org.netbeans.validation.api.builtin.stringvalidation.MinimumLength;
import org.netbeans.validation.api.builtin.stringvalidation.NonNegativeNumberValidator;
import org.netbeans.validation.api.builtin.stringvalidation.NotJavaIdentifierValidator;
import org.netbeans.validation.api.builtin.stringvalidation.NumberRange;
import org.netbeans.validation.api.builtin.stringvalidation.RegexpValidator;
import org.netbeans.validation.api.builtin.stringvalidation.SplitStringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.TrimStringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.UrlValidator;
import org.netbeans.validation.api.builtin.stringvalidation.ValidHexadecimalNumberValidator;
import org.netbeans.validation.api.builtin.stringvalidation.ValidHostNameOrIPValidator;

public enum StringValidators implements Validator<String>
{
    REQUIRE_NON_EMPTY_STRING,
    REQUIRE_VALID_FILENAME,
    REQUIRE_VALID_INTEGER,
    REQUIRE_NON_NEGATIVE_NUMBER,
    REQUIRE_VALID_NUMBER,
    REQUIRE_JAVA_IDENTIFIER,
    VALID_HEXADECIMAL_NUMBER,
    NO_WHITESPACE,
    FILE_MUST_EXIST,
    FILE_MUST_BE_FILE,
    FILE_MUST_BE_DIRECTORY,
    URL_MUST_BE_VALID,
    IP_ADDRESS,
    HOST_NAME,
    HOST_NAME_OR_IP_ADDRESS,
    MAY_NOT_START_WITH_DIGIT,
    EMAIL_ADDRESS,
    CHARACTER_SET_NAME,
    JAVA_PACKAGE_NAME,
    FILE_MUST_NOT_EXIST,
    MAY_NOT_END_WITH_PERIOD;


    private Validator<String> instantiate(boolean trim) {
        StringValidator result2;
        switch (this) {
            case REQUIRE_JAVA_IDENTIFIER: {
                result2 = new NotJavaIdentifierValidator();
                break;
            }
            case REQUIRE_NON_EMPTY_STRING: {
                result2 = new EmptyStringIllegalValidator();
                break;
            }
            case REQUIRE_NON_NEGATIVE_NUMBER: {
                result2 = new NonNegativeNumberValidator();
                break;
            }
            case REQUIRE_VALID_FILENAME: {
                result2 = new IllegalCharactersInFileNameValidator();
                break;
            }
            case REQUIRE_VALID_INTEGER: {
                result2 = new IsAnIntegerValidator();
                break;
            }
            case REQUIRE_VALID_NUMBER: {
                result2 = new IsANumberValidator();
                break;
            }
            case VALID_HEXADECIMAL_NUMBER: {
                result2 = new ValidHexadecimalNumberValidator();
                break;
            }
            case NO_WHITESPACE: {
                result2 = new MayNotContainSpacesValidator();
                break;
            }
            case FILE_MUST_BE_DIRECTORY: {
                result2 = new FileValidator(FileValidator.Type.MUST_BE_DIRECTORY);
                break;
            }
            case FILE_MUST_BE_FILE: {
                result2 = new FileValidator(FileValidator.Type.MUST_BE_FILE);
                break;
            }
            case FILE_MUST_EXIST: {
                result2 = new FileValidator(FileValidator.Type.MUST_EXIST);
                break;
            }
            case FILE_MUST_NOT_EXIST: {
                result2 = new FileValidator(FileValidator.Type.MUST_NOT_EXIST);
                break;
            }
            case URL_MUST_BE_VALID: {
                result2 = new UrlValidator();
                break;
            }
            case IP_ADDRESS: {
                result2 = new IpAddressValidator();
                break;
            }
            case HOST_NAME: {
                result2 = new HostNameValidator(true);
                break;
            }
            case HOST_NAME_OR_IP_ADDRESS: {
                result2 = new ValidHostNameOrIPValidator();
                break;
            }
            case MAY_NOT_START_WITH_DIGIT: {
                result2 = new MayNotStartWithDigit();
                break;
            }
            case EMAIL_ADDRESS: {
                EmailAddressValidator result2 = new EmailAddressValidator();
                return result2;
            }
            case JAVA_PACKAGE_NAME: {
                Validator<String> result2 = StringValidators.splitString("\\.", (Validator<String>)REQUIRE_JAVA_IDENTIFIER);
                return result2;
            }
            case MAY_NOT_END_WITH_PERIOD: {
                MayNotEndWithValidator result2 = new MayNotEndWithValidator('.');
                return result2;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (trim) {
            return new TrimStringValidator(result2);
        }
        return result2;
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        this.instantiate(false).validate(problems, compName, model);
    }

    public Validator<String> trim() {
        return this.instantiate(true);
    }

    public static Validator<String> trimString(Validator<String> ... validators) {
        return new TrimStringValidator(ValidatorUtils.merge(validators));
    }

    public static Validator<String> trimString(Validator<String> validator) {
        return new TrimStringValidator(validator);
    }

    public static Validator<String> splitString(String regexp, Validator<String> ... validators) {
        return new SplitStringValidator(regexp, ValidatorUtils.merge(validators));
    }

    public static Validator<String> splitString(String regexp, Validator<String> validator) {
        return new SplitStringValidator(regexp, validator);
    }

    public static Validator<String> mayNotEndWith(char ch) {
        return new MayNotEndWithValidator(ch);
    }

    public static Validator<String> disallowChars(char[] chars) {
        return new DisallowCharactersValidator(chars);
    }

    public static Validator<String> regexp(String regexp, String message, boolean acceptPartialMatches) {
        return new RegexpValidator(regexp, message, acceptPartialMatches);
    }

    public static Validator<String> validNumber(Locale l) {
        return new IsANumberValidator(l);
    }

    public static Validator<String> forFormat(Format fmt) {
        return new FormatValidator(fmt);
    }

    public static Validator<String> encodableInCharset(String charsetName) {
        return new EncodableInCharsetValidator(charsetName);
    }

    public static Validator<String> numberRange(Number min, Number max) {
        return new NumberRange(min, max);
    }

    public static Validator<String> minLength(int length) {
        return new MinimumLength(length);
    }

    public static Validator<String> maxLength(int length) {
        return new MaximumLength(length);
    }

    @Override
    public Class<String> modelType() {
        return String.class;
    }
}

