/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.extjs;

import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.extjs.Bundle;
import org.netbeans.modules.javascript2.extjs.ExtJsDataItem;
import org.netbeans.modules.javascript2.extjs.ExtJsElement;

public class ExtJsCompletionItem
implements CompletionProposal {
    private final int anchorOffset;
    private final ElementHandle element;
    private final ExtJsDataItem dataItem;

    static CompletionProposal createExtJsItem(ExtJsDataItem item, int anchorOffset) {
        ExtJsElement element = new ExtJsElement(item.getName(), item.getDocumentation(), ElementKind.PROPERTY);
        return new ExtJsCompletionItem(item, anchorOffset, element);
    }

    public ExtJsCompletionItem(ExtJsDataItem item, int anchorOffset, ElementHandle element) {
        this.anchorOffset = anchorOffset;
        this.element = element;
        this.dataItem = item;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.reset();
        formatter.appendText(this.getName());
        if (this.dataItem.getType() != null) {
            formatter.appendText(": ");
            formatter.type(true);
            formatter.appendText(this.dataItem.getType());
            formatter.type(false);
        }
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return Bundle.ExtJsCompletionItem_lbl_extjs_framework();
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return 22;
    }

    public String getCustomInsertTemplate() {
        if (this.dataItem.getTemplate() != null) {
            return this.getName() + ": " + this.dataItem.getTemplate().trim();
        }
        return null;
    }
}

