/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.tabmenu.TabMenu;
import org.primefaces.mobile.renderkit.BaseMenuRenderer;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.WidgetBuilder;

public class TabMenuRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TabMenu tabMenu = (TabMenu)component;
        List elements = tabMenu.getElements();
        String style = tabMenu.getStyle();
        String styleClass = tabMenu.getStyleClass();
        styleClass = styleClass == null ? "ui-tabmenu ui-navbar" : "ui-tabmenu ui-navbar " + styleClass;
        writer.startElement("div", (UIComponent)tabMenu);
        writer.writeAttribute("id", (Object)tabMenu.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"navigation", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("ul", (UIComponent)tabMenu);
        if (tabMenu.getElementsCount() > 0) {
            for (MenuElement element : elements) {
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                writer.startElement("li", null);
                this.encodeMenuItem(context, tabMenu, (MenuItem)element);
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        TabMenu menu = (TabMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TabMenu", menu.resolveWidgetVar(), clientId).attr("activeIndex", menu.getActiveIndex());
        wb.finish();
    }

    protected String getLinkStyleClass(MenuItem menuitem) {
        String icon = menuitem.getIcon();
        String iconPos = menuitem.getIconPos();
        iconPos = iconPos == null ? "ui-btn-icon-top" : "ui-btn-icon-" + iconPos;
        String styleClass = icon == null ? "ui-link ui-btn" : "ui-link ui-btn " + icon + " " + iconPos;
        String userStyleClass = menuitem.getStyleClass();
        if (userStyleClass != null) {
            styleClass = styleClass + " " + userStyleClass;
        }
        return styleClass;
    }
}

