/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.MaintenanceRunSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListMaintenanceRunsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String targetResourceId;
    private MaintenanceRunSummary.TargetResourceType targetResourceType;
    private MaintenanceRunSummary.MaintenanceType maintenanceType;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private MaintenanceRunSummary.LifecycleState lifecycleState;
    private String availabilityDomain;

    @ConstructorProperties(value={"compartmentId", "targetResourceId", "targetResourceType", "maintenanceType", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "availabilityDomain"})
    ListMaintenanceRunsRequest(String compartmentId, String targetResourceId, MaintenanceRunSummary.TargetResourceType targetResourceType, MaintenanceRunSummary.MaintenanceType maintenanceType, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, MaintenanceRunSummary.LifecycleState lifecycleState, String availabilityDomain) {
        this.compartmentId = compartmentId;
        this.targetResourceId = targetResourceId;
        this.targetResourceType = targetResourceType;
        this.maintenanceType = maintenanceType;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.availabilityDomain = availabilityDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).targetResourceId(this.targetResourceId).targetResourceType(this.targetResourceType).maintenanceType(this.maintenanceType).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).availabilityDomain(this.availabilityDomain);
    }

    public String toString() {
        return "ListMaintenanceRunsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", targetResourceId=" + this.getTargetResourceId() + ", targetResourceType=" + (Object)((Object)this.getTargetResourceType()) + ", maintenanceType=" + (Object)((Object)this.getMaintenanceType()) + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", availabilityDomain=" + this.getAvailabilityDomain() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListMaintenanceRunsRequest)) {
            return false;
        }
        ListMaintenanceRunsRequest other = (ListMaintenanceRunsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$targetResourceId = this.getTargetResourceId();
        String other$targetResourceId = other.getTargetResourceId();
        if (this$targetResourceId == null ? other$targetResourceId != null : !this$targetResourceId.equals(other$targetResourceId)) {
            return false;
        }
        MaintenanceRunSummary.TargetResourceType this$targetResourceType = this.getTargetResourceType();
        MaintenanceRunSummary.TargetResourceType other$targetResourceType = other.getTargetResourceType();
        if (this$targetResourceType == null ? other$targetResourceType != null : !((Object)((Object)this$targetResourceType)).equals((Object)other$targetResourceType)) {
            return false;
        }
        MaintenanceRunSummary.MaintenanceType this$maintenanceType = this.getMaintenanceType();
        MaintenanceRunSummary.MaintenanceType other$maintenanceType = other.getMaintenanceType();
        if (this$maintenanceType == null ? other$maintenanceType != null : !((Object)((Object)this$maintenanceType)).equals((Object)other$maintenanceType)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        MaintenanceRunSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        MaintenanceRunSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        return !(this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListMaintenanceRunsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $targetResourceId = this.getTargetResourceId();
        result = result * 59 + ($targetResourceId == null ? 43 : $targetResourceId.hashCode());
        MaintenanceRunSummary.TargetResourceType $targetResourceType = this.getTargetResourceType();
        result = result * 59 + ($targetResourceType == null ? 43 : ((Object)((Object)$targetResourceType)).hashCode());
        MaintenanceRunSummary.MaintenanceType $maintenanceType = this.getMaintenanceType();
        result = result * 59 + ($maintenanceType == null ? 43 : ((Object)((Object)$maintenanceType)).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        MaintenanceRunSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public MaintenanceRunSummary.TargetResourceType getTargetResourceType() {
        return this.targetResourceType;
    }

    public MaintenanceRunSummary.MaintenanceType getMaintenanceType() {
        return this.maintenanceType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public MaintenanceRunSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMaintenanceRunsRequest, Void> {
        private String compartmentId;
        private String targetResourceId;
        private MaintenanceRunSummary.TargetResourceType targetResourceType;
        private MaintenanceRunSummary.MaintenanceType maintenanceType;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private MaintenanceRunSummary.LifecycleState lifecycleState;
        private String availabilityDomain;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMaintenanceRunsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.targetResourceId(o.getTargetResourceId());
            this.targetResourceType(o.getTargetResourceType());
            this.maintenanceType(o.getMaintenanceType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMaintenanceRunsRequest build() {
            ListMaintenanceRunsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public Builder targetResourceType(MaintenanceRunSummary.TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        public Builder maintenanceType(MaintenanceRunSummary.MaintenanceType maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(MaintenanceRunSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public ListMaintenanceRunsRequest buildWithoutInvocationCallback() {
            return new ListMaintenanceRunsRequest(this.compartmentId, this.targetResourceId, this.targetResourceType, this.maintenanceType, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.availabilityDomain);
        }

        public String toString() {
            return "ListMaintenanceRunsRequest.Builder(compartmentId=" + this.compartmentId + ", targetResourceId=" + this.targetResourceId + ", targetResourceType=" + (Object)((Object)this.targetResourceType) + ", maintenanceType=" + (Object)((Object)this.maintenanceType) + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", availabilityDomain=" + this.availabilityDomain + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeScheduled("TIME_SCHEDULED"),
        TimeEnded("TIME_ENDED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

