/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;

public class ClassFieldVariable
extends ObjectFieldVariable
implements ClassVariable {
    public ClassFieldVariable(JPDADebuggerImpl debugger, Field field, String parentID, String genericSignature, ObjectReference objectReference) {
        super(debugger, field, parentID, genericSignature, objectReference);
    }

    private ClassFieldVariable(JPDADebuggerImpl debugger, ClassObjectReference value, Field field, String parentID, String genericSignature, ObjectReference objectReference) {
        super(debugger, value, field, parentID, genericSignature, objectReference);
    }

    public JPDAClassType getReflectedType() {
        Value innerValue = this.getInnerValue();
        if (!(innerValue instanceof ClassObjectReference)) {
            throw new IllegalStateException("Field " + this.field + " value " + innerValue + " is not a class.");
        }
        ClassObjectReference cor = (ClassObjectReference)innerValue;
        try {
            return this.getDebugger().getClassType(ClassObjectReferenceWrapper.reflectedType(cor));
        }
        catch (InternalExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            throw ex.getCause();
        }
    }

    @Override
    public ClassFieldVariable clone() {
        String name;
        try {
            name = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            name = ex.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            name = "0";
        }
        ClassFieldVariable clon = new ClassFieldVariable(this.getDebugger(), (ClassObjectReference)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + name + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.genericSignature, this.objectReference);
        clon.classType = this.classType;
        return clon;
    }

    @Override
    public String toString() {
        try {
            return "ClassFieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "Disconnected";
        }
    }
}

