/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr.formatters;

import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.expr.formatters.Bundle;

public final class VariablesFormatter
implements Cloneable {
    private String name;
    private boolean enabled = true;
    private String[] classTypes = new String[0];
    private boolean includeSubTypes = true;
    private String valueFormatCode = "";
    private String childrenFormatCode = "";
    private Map<String, String> childrenVariables = new LinkedHashMap<String, String>();
    private boolean useChildrenVariables = false;
    private String childrenExpandTestCode = "";
    private boolean isDefault = false;

    public VariablesFormatter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String[] getClassTypes() {
        return this.classTypes;
    }

    public String getClassTypesCommaSeparated() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.classTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.classTypes[i]);
        }
        return sb.toString();
    }

    public void setClassTypes(String[] classTypes) {
        this.classTypes = classTypes;
    }

    public void setClassTypes(String classTypesCommaSeparated) {
        this.classTypes = classTypesCommaSeparated.split("[, ]+");
    }

    public boolean isIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(boolean includeSubTypes) {
        this.includeSubTypes = includeSubTypes;
    }

    public String getValueFormatCode() {
        return this.valueFormatCode;
    }

    public void setValueFormatCode(String valueFormatCode) {
        this.valueFormatCode = valueFormatCode;
    }

    public String getChildrenFormatCode() {
        return this.childrenFormatCode;
    }

    public void setChildrenFormatCode(String childrenFormatCode) {
        this.childrenFormatCode = childrenFormatCode;
    }

    public Map<String, String> getChildrenVariables() {
        return this.childrenVariables;
    }

    public void setChildrenVariables(Map<String, String> childrenVariables) {
        this.childrenVariables = childrenVariables;
    }

    public void addChildrenVariable(String name, String value) {
        this.childrenVariables.put(name, value);
    }

    public boolean isUseChildrenVariables() {
        return this.useChildrenVariables;
    }

    public void setUseChildrenVariables(boolean useChildrenVariables) {
        this.useChildrenVariables = useChildrenVariables;
    }

    public String getChildrenExpandTestCode() {
        return this.childrenExpandTestCode;
    }

    public void setChildrenExpandTestCode(String childrenExpandTestCode) {
        this.childrenExpandTestCode = childrenExpandTestCode;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public VariablesFormatter clone() {
        VariablesFormatter f = new VariablesFormatter(this.name);
        f.childrenExpandTestCode = this.childrenExpandTestCode;
        f.childrenFormatCode = this.childrenFormatCode;
        f.childrenVariables = new LinkedHashMap<String, String>(this.childrenVariables);
        f.classTypes = (String[])this.classTypes.clone();
        f.enabled = this.enabled;
        f.includeSubTypes = this.includeSubTypes;
        f.useChildrenVariables = this.useChildrenVariables;
        f.valueFormatCode = this.valueFormatCode;
        return f;
    }

    public static VariablesFormatter[] loadFormatters() {
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        VariablesFormatter[] formatters = (VariablesFormatter[])p.getArray("VariableFormatters", null);
        VariablesFormatter[] defaultFormatters = VariablesFormatter.createDefaultFormatters();
        if (formatters == null) {
            formatters = defaultFormatters;
        } else {
            LinkedHashMap<String, VariablesFormatter> fm = new LinkedHashMap<String, VariablesFormatter>(defaultFormatters.length);
            for (VariablesFormatter vf : defaultFormatters) {
                fm.put(vf.getName(), vf);
            }
            for (int i = 0; i < formatters.length; ++i) {
                if (!formatters[i].isDefault || !fm.containsKey(formatters[i].getName())) continue;
                VariablesFormatter ovf = formatters[i];
                formatters[i] = (VariablesFormatter)fm.remove(formatters[i].getName());
                formatters[i].setEnabled(ovf.isEnabled());
            }
            if (!fm.isEmpty()) {
                VariablesFormatter[] newFormatters = new VariablesFormatter[formatters.length + fm.size()];
                System.arraycopy(formatters, 0, newFormatters, 0, formatters.length);
                System.arraycopy(fm.values().toArray(), 0, newFormatters, formatters.length, fm.size());
                formatters = newFormatters;
            }
        }
        return formatters;
    }

    private static VariablesFormatter[] createDefaultFormatters() {
        VariablesFormatter charSequence = new VariablesFormatter(Bundle.MSG_CharSequenceFormatter());
        charSequence.setClassTypes("java.lang.CharSequence");
        charSequence.setIncludeSubTypes(true);
        charSequence.setChildrenFormatCode("");
        charSequence.setChildrenExpandTestCode("false");
        charSequence.setValueFormatCode("toString()");
        charSequence.isDefault = true;
        VariablesFormatter collection = new VariablesFormatter(Bundle.MSG_CollectionFormatter());
        collection.setClassTypes("java.util.Collection");
        collection.setIncludeSubTypes(true);
        collection.setChildrenFormatCode("toArray()");
        collection.setValueFormatCode("\"size = \"+size()");
        collection.isDefault = true;
        VariablesFormatter map = new VariablesFormatter(Bundle.MSG_MapFormatter());
        map.setClassTypes("java.util.Map");
        map.setIncludeSubTypes(true);
        map.setChildrenFormatCode("entrySet()");
        map.setValueFormatCode("\"size = \"+size()");
        map.isDefault = true;
        VariablesFormatter mapEntry = new VariablesFormatter(Bundle.MSG_MapEntryFormatter());
        mapEntry.setClassTypes("java.util.Map$Entry");
        mapEntry.setIncludeSubTypes(true);
        mapEntry.setUseChildrenVariables(true);
        LinkedHashMap<String, String> childrenMap = new LinkedHashMap<String, String>();
        childrenMap.put("key", "getKey()");
        childrenMap.put("value", "getValue()");
        mapEntry.setChildrenVariables(childrenMap);
        mapEntry.setValueFormatCode("getKey()+\" => \"+getValue()");
        mapEntry.isDefault = true;
        VariablesFormatter enumFormatter = new VariablesFormatter(Bundle.MSG_EnumFormatter());
        enumFormatter.setClassTypes("java.lang.Enum");
        enumFormatter.setIncludeSubTypes(true);
        enumFormatter.setValueFormatCode("toString()");
        enumFormatter.isDefault = true;
        return new VariablesFormatter[]{charSequence, collection, map, mapEntry, enumFormatter};
    }

    public static class ReaderWriter
    implements Properties.Reader {
        private static final String OLD_VariablesFormatter_CLASS_NAME = "org.netbeans.modules.debugger.jpda.ui.VariablesFormatter";

        public String[] getSupportedClassNames() {
            return new String[]{OLD_VariablesFormatter_CLASS_NAME, VariablesFormatter.class.getName()};
        }

        public Object read(String className, Properties properties) {
            String name = properties.getString("name", "<EMPTY>");
            VariablesFormatter f = new VariablesFormatter(name);
            f.setEnabled(properties.getBoolean("enabled", f.isEnabled()));
            f.setClassTypes(properties.getString("classTypes", f.getClassTypesCommaSeparated()));
            f.setIncludeSubTypes(properties.getBoolean("includeSubTypes", f.isIncludeSubTypes()));
            f.setValueFormatCode(properties.getString("valueFormatCode", f.getValueFormatCode()));
            f.setChildrenFormatCode(properties.getString("childrenFormatCode", f.getChildrenFormatCode()));
            f.setChildrenVariables(properties.getMap("childrenVariables", f.getChildrenVariables()));
            f.setUseChildrenVariables(properties.getBoolean("useChildrenVariables", f.isUseChildrenVariables()));
            f.setChildrenExpandTestCode(properties.getString("childrenExpandTestCode", f.getChildrenExpandTestCode()));
            f.isDefault = properties.getBoolean("isDefault", f.isDefault);
            return f;
        }

        public void write(Object object, Properties properties) {
            VariablesFormatter f = (VariablesFormatter)object;
            properties.setString("name", f.getName());
            properties.setBoolean("enabled", f.isEnabled());
            properties.setString("classTypes", f.getClassTypesCommaSeparated());
            properties.setBoolean("includeSubTypes", f.isIncludeSubTypes());
            properties.setString("valueFormatCode", f.getValueFormatCode());
            properties.setString("childrenFormatCode", f.getChildrenFormatCode());
            properties.setMap("childrenVariables", f.getChildrenVariables());
            properties.setBoolean("useChildrenVariables", f.isUseChildrenVariables());
            properties.setString("childrenExpandTestCode", f.getChildrenExpandTestCode());
            properties.setBoolean("isDefault", f.isDefault);
        }
    }
}

