/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.utils;

import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpType;
import org.openide.filesystems.FileObject;

public final class EditorUtils {
    private static final String FILE_PRESENTER_RELATIVE_CLASSIC = "../../presenters/%sPresenter.php";
    private static final String FILE_PRESENTER_RELATIVE_DOTTED = "../presenters/%sPresenter.php";
    private static final String FILE_VIEW_RELATIVE_CLASSIC = "../templates/%s/%s.latte";
    private static final String FILE_VIEW_RELATIVE_DOTTED = "../templates/%s.%s.latte";
    private static final String MODULE_PREFIX_PATTERN = "^(.*)_";

    private EditorUtils() {
    }

    public static String firstLetterSmall(String text) {
        assert (text != null);
        String result = text;
        if (text.length() > 0) {
            result = text.substring(0, 1).toLowerCase() + text.substring(1);
        }
        return result;
    }

    public static String firstLetterCapital(String text) {
        assert (text != null);
        String result = text;
        if (text.length() > 0) {
            result = text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return result;
    }

    public static boolean isViewWithAction(FileObject fileObject) {
        assert (fileObject != null);
        return EditorUtils.isView(fileObject) && EditorUtils.getAction(fileObject) != null;
    }

    public static boolean isView(FileObject fileObject) {
        assert (fileObject != null);
        return "text/x-latte".equals(fileObject.getMIMEType());
    }

    public static FileObject getAction(FileObject fileObject) {
        assert (fileObject != null);
        FileObject result = null;
        FileObject parent = fileObject.getParent();
        if (parent != null) {
            String presenterName = parent.getName();
            String relativePresenterPath = String.format(EditorUtils.resolveActionRelativePath(fileObject), presenterName);
            result = fileObject.getFileObject(relativePresenterPath);
        }
        return result;
    }

    private static String resolveActionRelativePath(FileObject fo) {
        String result = FILE_PRESENTER_RELATIVE_CLASSIC;
        if (EditorUtils.isDottedView(fo)) {
            result = FILE_PRESENTER_RELATIVE_DOTTED;
        }
        return result;
    }

    private static boolean isDottedView(FileObject fo) {
        return EditorUtils.firstLetterCapital(fo.getName()).equals(fo.getName());
    }

    public static boolean isAction(FileObject fileObject) {
        assert (fileObject != null);
        return fileObject.isData() && fileObject.getName().endsWith("Presenter");
    }

    public static FileObject getView(FileObject fileObject, PhpBaseElement phpElement) {
        assert (fileObject != null);
        assert (phpElement != null);
        FileObject result = null;
        if (phpElement instanceof PhpType.Method) {
            result = EditorUtils.getView(fileObject, EditorUtils.getViewName(phpElement.getName()));
        }
        return result;
    }

    private static String getViewName(String actionName) {
        assert (actionName != null);
        String result = null;
        if (actionName.startsWith("action") || actionName.startsWith("render")) {
            result = EditorUtils.extractActionSimpleName(actionName);
        }
        return result;
    }

    private static String extractActionSimpleName(String actionName) {
        assert (actionName != null);
        String simple = actionName.startsWith("action") ? actionName.replace("action", "") : actionName.replace("render", "");
        return EditorUtils.firstLetterSmall(simple);
    }

    private static FileObject getView(FileObject fileObject, String viewName) {
        assert (fileObject != null);
        assert (viewName != null);
        FileObject result = null;
        FileObject parent = fileObject.getParent();
        if (parent != null) {
            String presenterName = EditorUtils.extractPresenterName(fileObject.getName());
            String relativeClassicViewPath = String.format(FILE_VIEW_RELATIVE_CLASSIC, presenterName, viewName);
            FileObject classicView = parent.getFileObject(relativeClassicViewPath);
            if (classicView != null && !classicView.isFolder()) {
                result = classicView;
            } else {
                String relativeDottedViewPath = String.format(FILE_VIEW_RELATIVE_DOTTED, presenterName, viewName);
                FileObject dottedView = parent.getFileObject(relativeDottedViewPath);
                if (dottedView != null && !dottedView.isFolder()) {
                    result = dottedView;
                }
            }
        }
        return result;
    }

    private static String extractPresenterName(String presenterFileName) {
        assert (presenterFileName != null);
        String presenterSimpleName = presenterFileName.replaceAll(".php", "").replaceAll("Presenter", "").replaceFirst(MODULE_PREFIX_PATTERN, "");
        return EditorUtils.firstLetterCapital(presenterSimpleName);
    }

    public static String getActionName(FileObject view) {
        assert (view != null);
        return EditorUtils.getActionRenderName(view, "action");
    }

    public static String getRenderName(FileObject view) {
        assert (view != null);
        return EditorUtils.getActionRenderName(view, "render");
    }

    private static String getActionRenderName(FileObject view, String methodPrefix) {
        String actionSimpleName;
        assert (view != null);
        assert (methodPrefix != null);
        if (EditorUtils.isDottedView(view)) {
            String[] parts = view.getNameExt().split("\\.", 3);
            actionSimpleName = parts[1];
        } else {
            String[] parts = view.getNameExt().split("\\.");
            actionSimpleName = parts[0];
        }
        return methodPrefix + EditorUtils.firstLetterCapital(actionSimpleName);
    }
}

