/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import java.util.Collections;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.SourceRef;
import org.netbeans.modules.languages.hcl.grammar.HCLParser;
import org.netbeans.modules.languages.hcl.grammar.HCLParserBaseListener;

public class ASTBuilderListener
extends HCLParserBaseListener {
    final HCLDocument document = new HCLDocument();
    int blockDepth = 0;

    public HCLDocument getDocument() {
        return this.document;
    }

    @Override
    public void exitBlock(HCLParser.BlockContext ctx) {
        if (this.blockDepth == 1) {
            HCLIdentifier id;
            SourceRef src;
            ArrayList<HCLIdentifier> decl = new ArrayList<HCLIdentifier>(4);
            for (TerminalNode terminalNode : ctx.IDENTIFIER()) {
                Token token = terminalNode.getSymbol();
                src = new SourceRef(null, token.getStartIndex(), token.getStopIndex());
                id = new HCLIdentifier.SimpleId(src, token.getText());
                decl.add(id);
            }
            for (HCLParser.StringLitContext stringLitContext : ctx.stringLit()) {
                String sid = stringLitContext.getText();
                sid = sid.substring(1, sid.length() - (sid.endsWith("\"") ? 1 : 0));
                src = new SourceRef(null, stringLitContext.getStart().getStartIndex(), stringLitContext.getStop().getStopIndex());
                id = new HCLIdentifier.StringId(src, sid);
                decl.add(id);
            }
            Collections.sort(decl, HCLElement.SOURCE_ORDER);
            this.document.add(new HCLBlock(decl));
        }
        --this.blockDepth;
    }

    @Override
    public void enterBlock(HCLParser.BlockContext ctx) {
        ++this.blockDepth;
    }
}

