/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.ValidityType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TrieDictionary
implements Dictionary {
    private static final Logger LOG = Logger.getLogger(TrieDictionary.class.getName());
    private final byte[] array;
    private final ByteBuffer buffer;
    private static final int CURRENT_TRIE_DICTIONARY_VERSION = 2;
    private static final RequestProcessor WORKER = new RequestProcessor(TrieDictionary.class.getName(), 1, false, false);
    private static final NullProposalAcceptor NULL_ACCEPTOR = new NullProposalAcceptor();

    TrieDictionary(byte[] array) {
        this.array = array;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrieDictionary(File data) throws IOException {
        this.array = null;
        FileInputStream ins = new FileInputStream(data);
        FileChannel channel = ins.getChannel();
        try {
            this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        finally {
            channel.close();
            ins.close();
        }
    }

    public ValidityType validateWord(CharSequence word) {
        String wordString = word.toString();
        ValidityType type = this.validateWordImpl(wordString.toLowerCase());
        if (type != ValidityType.VALID) {
            ValidityType curr = this.validateWordImpl(wordString);
            if (type == ValidityType.PREFIX_OF_VALID) {
                if (curr == ValidityType.VALID) {
                    type = curr;
                }
            } else {
                type = curr;
            }
        }
        return type;
    }

    private ValidityType validateWordImpl(CharSequence word) {
        int node = this.findNode(word, 0, 4);
        if (node == -1) {
            return ValidityType.INVALID;
        }
        if (this.readByte(node) == 1) {
            return ValidityType.VALID;
        }
        return ValidityType.PREFIX_OF_VALID;
    }

    public List<String> findValidWordsForPrefix(CharSequence word) {
        ArrayList<String> result = new ArrayList<String>();
        int node = this.findNode(word, 0, 4);
        if (node == -1) {
            return Collections.emptyList();
        }
        return this.findValidWordsForPrefix(new StringBuffer(word), node, result);
    }

    public List<String> findProposals(CharSequence pattern) {
        ListProposalAcceptor result = new ListProposalAcceptor();
        this.findProposals(pattern, 2, 4, new StringBuffer(), result);
        return result;
    }

    private void findProposals(CharSequence pattern, int maxDistance, int node, StringBuffer word, ProposalAcceptor result) {
        int entries = this.readInt(node + 1);
        for (int currentEntry = 0; currentEntry < entries; ++currentEntry) {
            char ac = this.readChar(node + 5 + currentEntry * 6);
            word.append(ac);
            int distance = TrieDictionary.distance(pattern, word);
            int targetNode = node + this.readInt(node + 5 + currentEntry * 6 + 2);
            if (distance < maxDistance && this.readByte(targetNode) == 1) {
                result.add(word.toString());
            }
            if (distance - (pattern.length() - word.length()) < maxDistance) {
                this.findProposals(pattern, maxDistance, targetNode, word, result);
            }
            word.deleteCharAt(word.length() - 1);
        }
    }

    private void verifyDictionary() {
        this.findProposals("", Integer.MAX_VALUE, 4, new StringBuffer(), NULL_ACCEPTOR);
    }

    private List<String> findValidWordsForPrefix(StringBuffer foundSoFar, int node, List<String> result) {
        int entries = this.readInt(node + 1);
        for (int currentEntry = 0; currentEntry < entries; ++currentEntry) {
            char ac = this.readChar(node + 5 + currentEntry * 6);
            foundSoFar.append(ac);
            int targetNode = node + this.readInt(node + 5 + currentEntry * 6 + 2);
            if (this.readByte(targetNode) == 1) {
                result.add(foundSoFar.toString());
            }
            this.findValidWordsForPrefix(foundSoFar, targetNode, result);
            foundSoFar.deleteCharAt(foundSoFar.length() - 1);
        }
        return result;
    }

    private int findNode(CharSequence word, int currentCharOffset, int currentNode) {
        if (word.length() <= currentCharOffset) {
            return currentNode;
        }
        char c = word.charAt(currentCharOffset);
        int entries = this.readInt(currentNode + 1);
        for (int currentEntry = 0; currentEntry < entries; ++currentEntry) {
            char ac = this.readChar(currentNode + 5 + currentEntry * 6);
            if (ac != c) continue;
            int newNodeOffset = this.readInt(currentNode + 5 + currentEntry * 6 + 2);
            int newNode = currentNode + newNodeOffset;
            return this.findNode(word, currentCharOffset + 1, newNode);
        }
        return -1;
    }

    public static Dictionary getDictionary(String suffix, List<URL> sources) throws IOException {
        File trie = Places.getCacheSubfile((String)("dict/dictionary" + suffix + ".trie" + 2));
        return TrieDictionary.getDictionary(trie, sources);
    }

    static Dictionary getDictionary(File trie, List<URL> sources) throws IOException {
        return new FutureDictionary(trie, sources);
    }

    private static int toUnsigned(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    private int readInt(int pos) {
        return (TrieDictionary.toUnsigned(this.readByte(pos + 0)) << 24) + (TrieDictionary.toUnsigned(this.readByte(pos + 1)) << 16) + (TrieDictionary.toUnsigned(this.readByte(pos + 2)) << 8) + TrieDictionary.toUnsigned(this.readByte(pos + 3));
    }

    private char readChar(int pos) {
        return (char)((TrieDictionary.toUnsigned(this.readByte(pos + 0)) << 8) + TrieDictionary.toUnsigned(this.readByte(pos + 1)));
    }

    private byte readByte(int pos) {
        if (this.buffer != null) {
            return this.buffer.get(pos);
        }
        return this.array[pos];
    }

    private static boolean compareChars(char c1, char c2) {
        return c1 == c2 || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static int distance(CharSequence pattern, CharSequence word) {
        int[] old = new int[pattern.length() + 1];
        int[] current = new int[pattern.length() + 1];
        int[] oldLength = new int[pattern.length() + 1];
        int[] length = new int[pattern.length() + 1];
        for (int cntr = 0; cntr < old.length; ++cntr) {
            old[cntr] = pattern.length() + 1;
            oldLength[cntr] = -1;
        }
        length[0] = 0;
        oldLength[0] = 0;
        old[0] = 0;
        current[0] = 0;
        for (int currentIndex = 0; currentIndex < word.length(); ++currentIndex) {
            for (int cntr = 0; cntr < pattern.length(); ++cntr) {
                int insert = old[cntr + 1] + 1;
                int delete = current[cntr] + 1;
                int replace = old[cntr] + (TrieDictionary.compareChars(pattern.charAt(cntr), word.charAt(currentIndex)) ? 0 : 1);
                if (insert < delete) {
                    if (insert < replace) {
                        current[cntr + 1] = insert;
                        length[cntr + 1] = oldLength[cntr + 1] + 1;
                        continue;
                    }
                    current[cntr + 1] = replace;
                    length[cntr + 1] = oldLength[cntr] + 1;
                    continue;
                }
                if (delete < replace) {
                    current[cntr + 1] = delete;
                    length[cntr + 1] = length[cntr];
                    continue;
                }
                current[cntr + 1] = replace;
                length[cntr + 1] = oldLength[cntr] + 1;
            }
            int[] temp = old;
            old = current;
            current = temp;
            temp = oldLength;
            oldLength = length;
            length = temp;
        }
        return old[pattern.length()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void constructTrie(ByteArray array, List<URL> sources) throws IOException {
        TreeSet<CharSequence> data = new TreeSet<CharSequence>();
        for (URL u : sources) {
            FileObject f = URLMapper.findFileObject((URL)u);
            u = f != null ? URLMapper.findURL((FileObject)f, (int)1) : u;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    data.add(CharSequences.create((CharSequence)line));
                }
            }
        }
        TrieDictionary.constructTrieData(array, data);
    }

    private static void constructTrieData(ByteArray array, SortedSet<? extends CharSequence> data) throws IOException {
        array.put(0, 2);
        TrieDictionary.encodeOneLayer(array, 4, 0, data);
    }

    private static int encodeOneLayer(ByteArray array, int currentPointer, int currentChar, SortedSet<? extends CharSequence> data) throws IOException {
        TreeMap<Character, TreeSet<CharSequence>> char2Words = new TreeMap<Character, TreeSet<CharSequence>>();
        boolean representsFullWord = !data.isEmpty() && data.first().length() <= currentChar;
        Iterator dataIt = data.iterator();
        if (representsFullWord) {
            dataIt.next();
        }
        while (dataIt.hasNext()) {
            CharSequence word = (CharSequence)dataIt.next();
            char c = word.charAt(currentChar);
            TreeSet<CharSequence> words = (TreeSet<CharSequence>)char2Words.get(Character.valueOf(c));
            if (words == null) {
                words = new TreeSet<CharSequence>();
                char2Words.put(Character.valueOf(c), words);
            }
            words.add(word);
        }
        int entries = char2Words.size();
        byte flags = 0;
        if (representsFullWord) {
            flags = 1;
        }
        array.put(currentPointer, flags);
        array.put(currentPointer + 1, entries);
        int currentEntry = 0;
        int childPointer = currentPointer + 5 + entries * 6;
        for (Map.Entry e : char2Words.entrySet()) {
            array.put(currentPointer + 5 + currentEntry * 6, ((Character)e.getKey()).charValue());
            array.put(currentPointer + 5 + currentEntry * 6 + 2, childPointer - currentPointer);
            childPointer = TrieDictionary.encodeOneLayer(array, childPointer, currentChar + 1, (SortedSet)e.getValue());
            ++currentEntry;
        }
        return childPointer;
    }

    public static final class RunOnStop
    implements Runnable {
        @Override
        public void run() {
            WORKER.shutdown();
            while (!WORKER.isTerminated()) {
                try {
                    WORKER.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class ByteArray {
        private final RandomAccessFile out;

        public ByteArray(File out) throws FileNotFoundException {
            this.out = new RandomAccessFile(out, "rw");
        }

        public void put(int pos, char what) throws IOException {
            this.out.seek(pos);
            this.out.writeChar(what);
        }

        public void put(int pos, byte what) throws IOException {
            this.out.seek(pos);
            this.out.writeByte(what);
        }

        public void put(int pos, int what) throws IOException {
            this.out.seek(pos);
            this.out.writeInt(what);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class NullProposalAcceptor
    implements ProposalAcceptor {
        private NullProposalAcceptor() {
        }

        @Override
        public boolean add(String proposal) {
            return true;
        }
    }

    private static class ListProposalAcceptor
    extends ArrayList<String>
    implements ProposalAcceptor {
        private ListProposalAcceptor() {
        }
    }

    private static interface ProposalAcceptor {
        public boolean add(String var1);
    }

    private static final class FutureDictionary
    implements Dictionary,
    Runnable {
        private final File trie;
        private final List<URL> sources;
        private final AtomicReference<Dictionary> delegate = new AtomicReference();
        private final AtomicReference<RequestProcessor.Task> workingTask = new AtomicReference();
        private final AtomicBoolean wasBroken = new AtomicBoolean();

        public FutureDictionary(File trie, List<URL> sources) throws IOException {
            this.trie = trie;
            this.sources = sources;
            this.workingTask.set(WORKER.post((Runnable)this));
        }

        public ValidityType validateWord(CharSequence word) {
            this.waitDictionaryConstructed();
            Dictionary dict = this.delegate.get();
            if (dict != null) {
                try {
                    return dict.validateWord(word);
                }
                catch (IndexOutOfBoundsException ex) {
                    this.rebuild(ex);
                }
            }
            return ValidityType.VALID;
        }

        public List<String> findValidWordsForPrefix(CharSequence word) {
            this.waitDictionaryConstructed();
            Dictionary dict = this.delegate.get();
            if (dict != null) {
                try {
                    return dict.findValidWordsForPrefix(word);
                }
                catch (IndexOutOfBoundsException ex) {
                    this.rebuild(ex);
                }
            }
            return Collections.emptyList();
        }

        public List<String> findProposals(CharSequence word) {
            this.waitDictionaryConstructed();
            Dictionary dict = this.delegate.get();
            if (dict != null) {
                try {
                    return dict.findProposals(word);
                }
                catch (IndexOutOfBoundsException ex) {
                    this.rebuild(ex);
                }
            }
            return Collections.emptyList();
        }

        private void waitDictionaryConstructed() {
            RequestProcessor.Task t = this.workingTask.get();
            if (t != null) {
                t.waitFinished();
                this.workingTask.set(null);
            }
        }

        private void rebuild(Throwable t) {
            if (!this.wasBroken.getAndSet(true)) {
                LOG.log(Level.INFO, "An exception thrown while read dictionary cache, attempting to rebuild.", t);
                this.workingTask.set(WORKER.post((Runnable)this));
            } else {
                LOG.log(Level.INFO, "An exception thrown while read dictionary cache for second time, giving up.", t);
                this.delegate.set(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.trie.getParentFile().mkdirs();
            if (this.trie.canRead()) {
                try {
                    TrieDictionary d = new TrieDictionary(this.trie);
                    d.verifyDictionary();
                    this.delegate.set(d);
                    return;
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Dictionary file failed validation, attempting to rebuild", ex);
                }
                catch (IndexOutOfBoundsException ex) {
                    LOG.log(Level.INFO, "Dictionary file failed validation, attempting to rebuild", ex);
                }
            }
            this.trie.delete();
            File temp = new File(this.trie.getParentFile(), "dict.temp");
            temp.delete();
            ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(TrieDictionary.class, (String)"BuildingDictionary"));
            try {
                handle.start();
                ByteArray array = new ByteArray(temp);
                TrieDictionary.constructTrie(array, this.sources);
                array.close();
                LOG.log(Level.FINE, "trie file length: {0}", temp.length());
                temp.renameTo(this.trie);
                if (this.trie.canRead()) {
                    TrieDictionary d = new TrieDictionary(this.trie);
                    this.delegate.set(d);
                    try {
                        d.verifyDictionary();
                    }
                    catch (IndexOutOfBoundsException ex) {
                        LOG.log(Level.INFO, "Cannot read the dictionary file", ex);
                        this.wasBroken.set(true);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.workingTask.set(null);
                if (temp.exists()) {
                    LOG.log(Level.INFO, "Something went wrong during dictionary construction, the temporary file still exists - deleting.");
                    temp.delete();
                }
                handle.finish();
            }
        }
    }
}

