/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.runconfigs.RunConfigScript;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RunAsScript
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = 8423354564321210L;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JButton configureButton;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JLabel interpreterLabel;
    private JTextField interpreterTextField;
    private JComboBox<String> runAsCombo;
    private JLabel runAsLabel;

    public RunAsScript(ConfigManager manager, SourcesFolderProvider sourcesFolderProvider) {
        super(manager);
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.addListeners();
        this.labels = new JLabel[]{this.indexFileLabel};
        this.textFields = new JTextField[]{this.indexFileTextField};
        this.propertyNames = new String[]{"indexFile"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
    }

    private void addListeners() {
        this.interpreterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsScript.this.changeSupport.fireChange();
            }
        });
        this.runAsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunAsScript.this.changeSupport.fireChange();
            }
        });
    }

    public void loadPhpInterpreter() {
        String phpInterpreter = PhpOptions.getInstance().getPhpInterpreter();
        this.interpreterTextField.setText(phpInterpreter != null ? phpInterpreter : "");
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return RunConfigScript.getRunAsType();
    }

    @Override
    public String getDisplayName() {
        return RunConfigScript.getDisplayName();
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    public JComboBox<String> getRunAsCombo() {
        return this.runAsCombo;
    }

    @Override
    protected void loadFields() {
        this.loadPhpInterpreter();
    }

    @Override
    protected void validateFields() {
        this.changeSupport.fireChange();
    }

    public void addRunAsScriptListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeRunAsScriptListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public RunConfigScript createRunConfig() {
        return (RunConfigScript)((RunConfigScript)RunConfigScript.create().setUseDefaultInterpreter(false).setInterpreter(this.interpreterTextField.getText().trim()).setIndexParentDir(this.sourcesFolderProvider.getSourcesFolder())).setIndexRelativePath(this.indexFileTextField.getText().trim());
    }

    public void setIndexFile(String indexFile) {
        this.indexFileTextField.setText(indexFile);
    }

    public void hideIndexFile() {
        this.indexFileLabel.setVisible(false);
        this.indexFileTextField.setVisible(false);
        this.indexFileBrowseButton.setVisible(false);
    }

    private void initComponents() {
        this.interpreterLabel = new JLabel();
        this.interpreterTextField = new JTextField();
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.configureButton = new JButton();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.interpreterLabel.setLabelFor(this.interpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.interpreterLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_PhpInterpreter"));
        this.interpreterTextField.setEditable(false);
        this.interpreterTextField.setColumns(20);
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_RunAs"));
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Configure"));
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsScript.this.configureButtonActionPerformed(evt);
            }
        });
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_BrowseIndex"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsScript.this.indexFileBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.runAsLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.interpreterLabel).addComponent(this.indexFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runAsCombo, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.indexFileTextField).addComponent(this.interpreterTextField, -2, 1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configureButton, GroupLayout.Alignment.TRAILING).addComponent(this.indexFileBrowseButton, GroupLayout.Alignment.TRAILING))))));
        layout.linkSize(0, this.configureButton, this.indexFileBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsLabel).addComponent(this.runAsCombo, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interpreterLabel).addComponent(this.interpreterTextField, -2, -1, -2).addComponent(this.configureButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indexFileLabel).addComponent(this.indexFileBrowseButton).addComponent(this.indexFileTextField, -2, -1, -2))));
        this.interpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleName"));
        this.interpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleDescription"));
        this.interpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleName"));
        this.interpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleDescription"));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleDescription"));
        this.configureButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleName"));
        this.configureButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleDescription"));
    }

    private void configureButtonActionPerformed(ActionEvent evt) {
        Utils.showGeneralOptionsPanel();
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            Utils.browseFolderFile(PhpVisibilityQuery.getDefault(), this.sourcesFolderProvider.getSourcesFolder(), this.indexFileTextField);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(propName, label, field);
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsScript.this.getDefaultValue(this.getPropName());
        }
    }
}

