/**
 * TreeWalker objects are used to navigate a document tree or subtree using the view of the document defined by their whatToShow flags and filter (if any). Any function which performs navigation using a TreeWalker will automatically support any view defined by a TreeWalker.Omitting nodes from the logical view of a subtree can result in a structure that is substantially different from the same subtree in the complete, unfiltered document. Nodes that are siblings in the TreeWalker view may be children of different, widely separated nodes in the original view. For instance, consider a NodeFilter that skips all nodes except for Text nodes and the root node of a document. In the logical view that results, all text nodes will be siblings and appear as direct children of the root node, no matter how deeply nested the structure of the original document.
 */
var TreeWalker = {
}
/**
 * This attribute determines which node types are presented via the TreeWalker. The available set of constants is defined in the NodeFilter interface. Nodes not accepted by whatToShow will be skipped, but their children may still be considered. Note that this skip takes precedence over the filter, if any.
 * @syntax treeWalker.whatToShow
 * @returns {Number} 
 */
TreeWalker.prototype.whatToShow = new Number();

/**
 * Moves the TreeWalker to the previous sibling of the current node,
 * @syntax treeWalker.previousSibling()
 * @returns {Node} The new node, or null if the current node has no previous sibling. in the TreeWalker's logical view.
 */
TreeWalker.prototype.previousSibling = function() {};

/**
 * The root node of the TreeWalker, as specified when it was created.
 * @syntax treeWalker.root
 * @returns {Node} 
 */
TreeWalker.prototype.root = new Node();

/**
 * Moves to and returns the closest visible ancestor node of the current node. If the search for parentNode attempts to step upward from the TreeWalker's root node, or if it fails to find a visible ancestor node, this method retains the current position and returns null.
 * @syntax treeWalker.parentNode()
 * @returns {Node} The new parent node, or null if the current node has no parent in the TreeWalker's logical view.
 */
TreeWalker.prototype.parentNode = function() {};

/**
 * The value of this flag determines whether the children of entity reference nodes are visible to the TreeWalker. If false, they and their descendants will be rejected. Note that this rejection takes precedence over whatToShow and the filter, if any. To produce a view of the document that has entity references expanded and does not expose the entity reference node itself, use the whatToShow flags to hide the entity reference node and set expandEntityReferences to true when creating the TreeWalker. To produce a view of the document that has entity reference nodes but no entity expansion, use the whatToShow flags to show the entity reference node and set expandEntityReferences to false.
 * @syntax treeWalker.expandEntityReferences
 * @returns {boolean} 
 */
TreeWalker.prototype.expandEntityReferences = new boolean();

/**
 * The node at which the TreeWalker is currently positioned. Alterations to the DOM tree may cause the current node to no longer be accepted by the TreeWalker's associated filter. currentNode may also be explicitly set to any node, whether or not it is within the subtree specified by the root node or would be accepted by the filter and whatToShow flags. Further traversal occurs relative to currentNode even if it is not part of the current view, by applying the filters in the requested direction; if no traversal is possible, currentNode is not changed. Exceptions on setting DOMException NOT_SUPPORTED_ERR: Raised if an attempt is made to set currentNode to null.
 * @syntax treeWalker.currentNode
 * @returns {Node} 
 */
TreeWalker.prototype.currentNode = new Node();

/**
 * Moves the TreeWalker to the first visible child of the current node,
 * @syntax treeWalker.firstChild()
 * @returns {Node} The new node, or null if the current node has no visible children in the TreeWalker's logical view.
 */
TreeWalker.prototype.firstChild = function() {};

/**
 * Moves the TreeWalker to the next visible node in document order relative to the current node,
 * @syntax treeWalker.nextNode()
 * @returns {Node} The new node, or null if the current node has no next node in the TreeWalker's logical view.
 */
TreeWalker.prototype.nextNode = function() {};

/**
 * The filter used to screen nodes.
 * @syntax treeWalker.filter
 * @returns {NodeFilter} 
 */
TreeWalker.prototype.filter = new NodeFilter();

/**
 * Moves the TreeWalker to the next sibling of the current node,
 * @syntax treeWalker.nextSibling()
 * @returns {Node} The new node, or null if the current node has no next sibling. in the TreeWalker's logical view.
 */
TreeWalker.prototype.nextSibling = function() {};

/**
 * Moves the TreeWalker to the last visible child of the current node,
 * @syntax treeWalker.lastChild()
 * @returns {Node} The new node, or null if the current node has no children in the TreeWalker's logical view.
 */
TreeWalker.prototype.lastChild = function() {};

/**
 * Moves the TreeWalker to the previous visible node in document order relative to the current node,
 * @syntax treeWalker.previousNode()
 * @returns {Node} The new node, or null if the current node has no previous node in the TreeWalker's logical view.
 */
TreeWalker.prototype.previousNode = function() {};

/**
 * Represents the TreeWalker prototype object.
 * @syntax TreeWalker.prototype
 * @static
 */
TreeWalker.prototype;

