/**
 * @syntax [element0, element1, ..., elementN] new Array(element0, element1[, ...[, elementN]]) new Array(arrayLength)
 * @returns {Array}
 */
function Array(element0, element1) {
}
/**
 * @since ECMAScript6
 * @syntax arr.values()
 * @returns {Array}
 */
Array.prototype.values = function() {};

/**
 * @since ECMAScript6
 * @syntax arr.keys()
 * @returns {Array}
 */
Array.prototype.keys = function() {};

/**
 * @syntax arr.length
 * @returns {Number}
 */
Array.prototype.length = new Number();

/**
 * @syntax Array.isArray(obj)
 * @param {Object} obj
 * @returns {Boolean}
 * @static
 */
Array.isArray = function(obj) {};

/**
 * @syntax arr.filter(callback[, thisArg])
 * @param {Function} callback
 * @param {String} thisArg
 * @returns {Array}
 */
Array.prototype.filter = function(callback) {};

/**
 * @syntax arr.sort([compareFunction])
 * @param {Array} compareFunction
 * @returns {Array}
 */
Array.prototype.sort = function() {};

/**
 * @syntax arr.pop()
 * @returns {Object}
 */
Array.prototype.pop = function() {};

/**
 * @since ECMAScript6
 * @syntax arr.find(callback[, thisArg])
 * @param {Function} callback
 * @param {Object} thisArg
 * @returns {Object}
 */
Array.prototype.find = function(callback) {};

/**
 * @syntax arr.shift()
 * @returns {Object}
 */
Array.prototype.shift = function() {};

/**
 * @syntax arr.forEach(callback[, thisArg])
 * @param {Function} callback
 * @param {String} thisArg
 * @returns {undefined}
 */
Array.prototype.forEach = function(callback) {};

/**
 * @syntax arr.reduceRight(callback[, initialValue])
 * @param {Function} callback
 * @param {Object} initialValue
 * @returns {Object}
 */
Array.prototype.reduceRight = function(callback) {};

/**
 * @syntax arr.some(callback[, thisArg])
 * @param {Function} callback
 * @param {String} thisArg
 * @returns {Boolean}
 */
Array.prototype.some = function(callback) {};

/**
 * @syntax arr.toString()
 * @returns {String}
 */
Array.prototype.toString = function() {};

/**
 * @since ECMAScript6
 * @syntax arr.copyWithin(target[, start[, end]])
 * @param {String} target
 * @param {Number} start
 * @param {Number} end
 * @returns {undefined}
 */
Array.prototype.copyWithin = function(target) {};

/**
 * @syntax arr.indexOf(searchElement[, fromIndex = 0])
 * @param {Array} searchElement
 * @param {Number} fromIndex
 * @returns {Number}
 */
Array.prototype.indexOf = function(searchElement) {};

/**
 * @syntax str = arr.join([separator = ','])
 * @param {String} separator
 * @returns {String}
 */
Array.prototype.join = function() {};

/**
 * @since ECMAScript6
 * @syntax Array.from(arrayLike[, mapFn[, thisArg]])
 * @param {Object} arrayLike
 * @param {Array} mapFn
 * @param {String} thisArg
 * @returns {Array}
 * @static
 */
Array.from = function(arrayLike) {};

/**
 * @syntax arr.every(callback[, thisArg])
 * @param {Function} callback
 * @param {String} thisArg
 * @returns {Boolean}
 */
Array.prototype.every = function(callback) {};

/**
 * @since ECMAScript6
 * @syntax arr.fill(value[, start = 0[, end = this.length]])
 * @param {Array} value
 * @param {Number} start
 * @param {Number} end
 * @returns {undefined}
 */
Array.prototype.fill = function(value) {};

/**
 * @syntax array.splice(start, deleteCount[, item1[, item2[, ...]]])
 * @param {Number} start
 * @param {Array} deleteCount
 * @returns {Array}
 */
Array.prototype.splice = function(start, deleteCount) {};

/**
 * @syntax arr.lastIndexOf(searchElement[, fromIndex = arr.length - 1])
 * @param {Object} searchElement
 * @param {Number} fromIndex
 * @returns {Number}
 */
Array.prototype.lastIndexOf = function(searchElement) {};

/**
 * @syntax arr.toLocaleString()
 * @returns {String}
 */
Array.prototype.toLocaleString = function() {};

/**
 * @since ECMAScript6
 * @syntax arr.findIndex(callback[, thisArg])
 * @param {Function} callback
 * @param {Object} thisArg
 * @returns {Number}
 */
Array.prototype.findIndex = function(callback) {};

/**
 * @syntax arr.map(callback[, thisArg])
 * @param {Function} callback
 * @param {Object} thisArg
 * @returns {Array}
 */
Array.prototype.map = function(callback) {};

/**
 * @syntax arr.reverse()
 * @returns {Array}
 */
Array.prototype.reverse = function() {};

/**
 * @since ECMAScript6
 * @syntax arr.entries()
 * @returns {Array}
 */
Array.prototype.entries = function() {};

/**
 * @since ECMAScript6
 * @syntax Array.of(element0[, element1[, ...[, elementN]]])
 * @param {Array} elementN
 * @returns {Array}
 * @static
 */
Array.of = function(element0) {};

/**
 * @since ECMAScript7
 * @syntax var boolean = array.includes(searchElement[, fromIndex])
 * @param {String} searchElement
 * @param {Number} fromIndex
 * @returns {Boolean}
 */
Array.prototype.includes = function(searchElement) {};

/**
 * @syntax arr.reduce(callback[, initialValue])
 * @param {Function} callback
 * @param {String} initialValue
 * @returns {Object}
 */
Array.prototype.reduce = function(callback) {};

/**
 * @syntax var new_array = old_array.concat(value1[, value2[, ...[, valueN]]])
 * @param {Array} valueN
 * @returns {Array}
 */
Array.prototype.concat = function(value1) {};

/**
 * @syntax arr.push(element1, ..., elementN)
 * @param {Array} elementN
 * @returns {Number}
 */
Array.prototype.push = function(element1) {};

/**
 * @syntax arr.slice([begin[, end]])
 * @param {Number} begin
 * @param {Number} end
 * @returns {Array}
 */
Array.prototype.slice = function() {};

/**
 * @syntax arr.unshift([element1[, ...[, elementN]]])
 * @param {Array} elementN
 * @returns {Number}
 */
Array.prototype.unshift = function() {};

/**
 * Represents the Array prototype object.
 * @syntax Array.prototype
 * @static
 */
Array.prototype;

