/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class PropertyPatternNode
extends PatternNode {
    public PropertyPatternNode(PropertyPattern pattern, boolean writeable) {
        super(pattern, Children.LEAF, writeable);
        this.superSetName(pattern.getName());
    }

    String getTypeForHint() {
        return BeanUtils.getString("HINT_Property");
    }

    @Override
    public String getShortDescription() {
        String mode;
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                mode = BeanUtils.getString("HINT_ReadWriteProperty");
                break;
            }
            case 2: {
                mode = BeanUtils.getString("HINT_ReadOnlyProperty");
                break;
            }
            case 4: {
                mode = BeanUtils.getString("HINT_WriteOnlyProperty");
                break;
            }
            default: {
                mode = "";
            }
        }
        return mode + " " + this.getTypeForHint() + " : " + this.getName();
    }

    public Node cloneNode() {
        return new PropertyPatternNode((PropertyPattern)this.pattern, this.writeable);
    }

    @Override
    protected void setPatternName(String name) {
        if (this.pattern.getName().equals(name)) {
            return;
        }
        if (this.testNameValidity(name)) {
            ((PropertyPattern)this.pattern).setName(name);
        }
    }

    boolean testNameValidity(String name) {
        if (!Utilities.isJavaIdentifier((String)name)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)BeanUtils.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        return true;
    }

    void fire() {
        this.firePropertyChange(null, null, null);
    }
}

