/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ParamsPanel
extends JPanel {
    private ArrayList arguments = new ArrayList();
    private int editingRow = -1;
    private ParamsListModel model;
    private final ResourceBundle bundle = NbBundle.getBundle(ParamsPanel.class);
    static final long serialVersionUID = -3754019215574878093L;
    private JButton addParamButton;
    private JPanel addRemovePanel;
    private JLabel codeLabel;
    private JEditorPane codePane;
    private JScrollPane codeScroll;
    private JLabel paramLabel;
    private JList paramsList;
    private JScrollPane paramsScroll;
    private JButton removeParamButton;

    public ParamsPanel() {
        this.initComponents();
        this.initAccessibility();
        this.paramsList.setModel(this.getListModel());
        this.paramsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ParamsPanel.this.paramsList.getSelectedIndex() != -1) {
                    ParamsPanel.this.updateEditor(ParamsPanel.this.paramsList.getSelectedIndex());
                }
                ParamsPanel.this.removeParamButton.setEnabled(ParamsPanel.this.paramsList.getSelectedIndex() != -1);
            }
        });
        this.removeParamButton.setEnabled(this.paramsList.getSelectedIndex() != -1);
        HelpCtx.setHelpIDString((JComponent)this, (String)"internation.addparams");
    }

    public void setArguments(String[] args) {
        this.arguments.clear();
        for (int i = 0; i < args.length; ++i) {
            this.arguments.add(args[i]);
        }
        if (this.getListModel().getSize() > 0) {
            this.getListModel().fireIntervalAdded(0, this.getListModel().getSize() - 1);
        }
        if (this.getListModel().getSize() > 0) {
            this.editRow(0);
        } else {
            this.editRow(-1);
        }
    }

    public String[] getArguments() {
        this.commitChanges();
        int j = -1;
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (((String)this.arguments.get(i)).trim().length() <= 0) continue;
            j = i;
        }
        String[] args = new String[j + 1];
        for (int i = 0; i <= j; ++i) {
            args[i] = (String)this.arguments.get(i);
        }
        return args;
    }

    private void commitChanges() {
        if (this.editingRow != -1) {
            this.arguments.set(this.editingRow, this.codePane.getText());
            this.getListModel().fireContentsChanged(this.editingRow, this.editingRow);
        }
    }

    private void editRow(int row) {
        if (row != -1) {
            this.paramsList.setSelectedIndex(row);
        } else {
            this.paramsList.setSelectedIndices(new int[0]);
        }
    }

    private void updateEditor(int row) {
        this.commitChanges();
        this.editingRow = row;
        if (row == -1) {
            this.codePane.setText("");
            this.codePane.setEnabled(false);
        } else {
            this.codePane.setText((String)this.arguments.get(this.editingRow));
            this.codePane.setEnabled(true);
            this.codePane.requestFocus();
        }
    }

    private ParamsListModel getListModel() {
        if (this.model == null) {
            this.model = new ParamsListModel();
        }
        return this.model;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ParamsPanel"));
        this.removeParamButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_RemoveButton"));
        this.addParamButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_AddButton"));
        this.paramsList.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_paramsList"));
    }

    private void initComponents() {
        this.paramLabel = new JLabel();
        this.codeLabel = new JLabel();
        this.paramsScroll = new JScrollPane();
        this.paramsList = new JList();
        this.addRemovePanel = new JPanel();
        this.addParamButton = new JButton();
        this.removeParamButton = new JButton();
        this.codeScroll = new JScrollPane();
        this.codePane = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.paramLabel.setLabelFor(this.paramsList);
        Mnemonics.setLocalizedText((JLabel)this.paramLabel, (String)this.bundle.getString("LBL_Parameters"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
        this.codeLabel.setLabelFor(this.codePane);
        Mnemonics.setLocalizedText((JLabel)this.codeLabel, (String)this.bundle.getString("LBL_Code"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.codeLabel, gridBagConstraints);
        this.paramsList.setSelectionMode(0);
        this.paramsList.setVisibleRowCount(3);
        this.paramsScroll.setViewportView(this.paramsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 0, 0);
        this.add((Component)this.paramsScroll, gridBagConstraints);
        this.addRemovePanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addParamButton, (String)this.bundle.getString("CTL_AddButton"));
        this.addParamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParamsPanel.this.addParamButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.addRemovePanel.add((Component)this.addParamButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeParamButton, (String)this.bundle.getString("CTL_RemoveButton"));
        this.removeParamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParamsPanel.this.removeParamButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.addRemovePanel.add((Component)this.removeParamButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 11, 0, 11);
        this.add((Component)this.addRemovePanel, gridBagConstraints);
        this.codePane.setContentType("text/x-java");
        this.codePane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ParamsPanel.this.codePaneFocusLost(evt);
            }
        });
        this.codeScroll.setViewportView(this.codePane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 11, 0);
        this.add((Component)this.codeScroll, gridBagConstraints);
    }

    private void codePaneFocusLost(FocusEvent evt) {
        this.commitChanges();
    }

    private void removeParamButtonActionPerformed(ActionEvent evt) {
        int index = this.paramsList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.arguments.remove(index);
        this.getListModel().fireIntervalRemoved(index, index);
        if (index >= this.arguments.size()) {
            --index;
        }
        this.editingRow = -1;
        this.editRow(index);
    }

    private void addParamButtonActionPerformed(ActionEvent evt) {
        this.arguments.add("");
        this.getListModel().fireIntervalAdded(this.getListModel().getSize() - 1, this.getListModel().getSize() - 1);
        this.editRow(this.getListModel().getSize() - 1);
    }

    protected class ParamsListModel
    extends AbstractListModel {
        static final long serialVersionUID = 6832148996617470334L;

        @Override
        public int getSize() {
            return ParamsPanel.this.arguments.size();
        }

        @Override
        public Object getElementAt(int index) {
            return "{" + index + "}  " + (String)ParamsPanel.this.arguments.get(index);
        }

        public void fireContentsChanged(int index0, int index1) {
            super.fireContentsChanged(this, index0, index1);
        }

        public void fireIntervalAdded(int index0, int index1) {
            super.fireIntervalAdded(this, index0, index1);
        }

        public void fireIntervalRemoved(int index0, int index1) {
            super.fireIntervalRemoved(this, index0, index1);
        }
    }
}

