/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.locator.GavHelpedLocator;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactLocator
implements GavHelpedLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactLocator.class);
    private final ArtifactPackagingMapper mapper;

    public ArtifactLocator(ArtifactPackagingMapper mapper) {
        this.mapper = mapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File locate(File source, GavCalculator gavCalculator, Gav gav) {
        if (source == null) return null;
        if (!source.exists()) return null;
        if (gav == null) return null;
        if (gav.getArtifactId() == null) return null;
        if (gav.getVersion() == null) {
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);){
            Model model = new MavenXpp3Reader().read(inputStream, false);
            if (model == null) {
                File file = null;
                return file;
            }
            String artifactName = gav.getArtifactId() + "-" + gav.getVersion() + "." + this.mapper.getExtensionForPackaging(model.getPackaging());
            File artifact = new File(source.getParent(), artifactName);
            if (!artifact.exists()) {
                File file = null;
                return file;
            }
            File file = artifact;
            return file;
        }
        catch (IOException | XmlPullParserException e) {
            LOGGER.warn("skip error reading pom from file:" + source, e);
            return null;
        }
    }
}

