/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer.api;

import java.awt.Image;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public final class TreeItemData {
    public static final URI NO_URI;
    public static final String NO_COMMAND;
    private Image iconImage;
    private URI iconURI;
    private String[] contextValues;
    private String command;
    private URI resourceURI;

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public TreeItemData setResourceURI(URI resourceURI) {
        this.resourceURI = resourceURI;
        return this;
    }

    public String[] getContextValues() {
        return this.contextValues;
    }

    public TreeItemData addContextValues(String ... addValues) {
        if (addValues == null || addValues.length == 0) {
            return this;
        }
        if (this.contextValues == null) {
            this.contextValues = addValues;
        } else {
            String[] v = Arrays.copyOf(this.contextValues, this.contextValues.length + addValues.length);
            System.arraycopy(addValues, 0, v, this.contextValues.length, addValues.length);
            this.contextValues = v;
        }
        return this;
    }

    public TreeItemData setContextValues(String ... contextValues) {
        this.contextValues = contextValues;
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public TreeItemData setCommand(String command) {
        this.command = command;
        return this;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public TreeItemData setIconImage(Image iconImage) {
        this.iconImage = iconImage;
        this.iconURI = null;
        return this;
    }

    public URI getIconURI() {
        return this.iconURI;
    }

    public TreeItemData setIconURI(URI iconURI) {
        this.iconURI = iconURI;
        this.iconImage = null;
        return this;
    }

    public TreeItemData merge(TreeItemData data) {
        URI u;
        if (data.getResourceURI() != null) {
            u = data.getResourceURI();
            this.setResourceURI(u == NO_URI ? null : u);
        }
        if (data.getCommand() != null) {
            this.setCommand(data.getCommand());
        }
        if (data.getContextValues() != null) {
            String[] cvs = data.getContextValues();
            if (this.contextValues == null) {
                this.contextValues = cvs;
            } else {
                String[] n = Arrays.copyOf(this.contextValues, this.contextValues.length + cvs.length);
                System.arraycopy(cvs, 0, n, this.contextValues.length, cvs.length);
                this.contextValues = n;
            }
        }
        if (data.getIconImage() != null) {
            this.setIconImage(data.getIconImage());
        }
        if (data.getIconURI() != null) {
            u = data.getIconURI();
            this.setIconURI(u == NO_URI ? null : u);
        }
        return this;
    }

    static {
        NO_COMMAND = new String("<no command>");
        try {
            NO_URI = new URI("");
        }
        catch (URISyntaxException ex) {
            throw new UnsupportedOperationException();
        }
    }
}

