/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Image;
import java.util.StringTokenizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public class NestedNode
extends AbstractNode {
    private String resource = null;
    private String method = null;
    private int statusCode;
    private int[] index;

    public NestedNode(String resource, String method, int[] index, int statusCode) {
        super(Children.LEAF);
        this.resource = resource;
        this.method = method;
        this.index = index;
        this.statusCode = statusCode;
        this.setProperties();
    }

    public NestedNode(String resource, String method, Children ch, int[] index, int statusCode) {
        super(ch);
        this.resource = resource;
        this.method = method;
        this.index = index;
        this.statusCode = statusCode;
        this.setProperties();
    }

    public String getLongName() {
        return this.getName();
    }

    public Image getIcon(int type) {
        Image badge;
        Image base = this.method.equals("GET") ? ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/get.gif") : (this.method.equals("POST") ? ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/post.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/other.gif"));
        if (this.statusCode >= 400 || this.statusCode < 0) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/infoBadge.gif");
        } else if (this.statusCode >= 300) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/warningBadge.gif");
        } else {
            if (this.statusCode >= 200) {
                return base;
            }
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/errorBadge.gif");
        }
        return ImageUtilities.mergeImages((Image)base, (Image)badge, (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getResource() {
        return this.resource;
    }

    public int[] getIndex() {
        return this.index;
    }

    protected SystemAction[] createActions() {
        return new SystemAction[0];
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    private void setProperties() {
        this.setNameString();
    }

    public void setNameString() {
        String name = null;
        if (this.resource.equals("/")) {
            name = this.resource;
        } else {
            StringTokenizer st = new StringTokenizer(this.resource, "/");
            while (st.hasMoreTokens()) {
                name = st.nextToken();
            }
        }
        this.setName(name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("NestedNode: ");
        buf.append(this.getName());
        buf.append(", resource=");
        buf.append(this.resource);
        buf.append(", index=");
        for (int i = 0; i < this.index.length; ++i) {
            buf.append(this.index[i]);
            buf.append(',');
        }
        return buf.toString();
    }
}

