/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.api;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.java.source.ui.ElementIcons;

public final class MemberInfo<H> {
    private H member;
    private String htmlText;
    private Icon icon;
    private Group group;
    private Set<Modifier> modifiers;
    private boolean makeAbstract;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private MemberInfo(H member, String name, String htmlText, Icon icon) {
        this.member = member;
        this.htmlText = htmlText;
        this.icon = icon;
        this.name = name;
    }

    public H getElementHandle() {
        return this.member;
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public static <T extends TypeMirror> MemberInfo<TypeMirrorHandle<T>> create(T el, Tree t, CompilationInfo c) {
        MemberInfo<TypeMirrorHandle<T>> mi = new MemberInfo<TypeMirrorHandle<T>>(TypeMirrorHandle.create(el), t.toString(), "implements " + t.toString(), ElementIcons.getElementIcon((ElementKind)ElementKind.INTERFACE, null));
        mi.group = Group.IMPLEMENTS;
        return mi;
    }

    public static <T extends Element> MemberInfo<ElementHandle<T>> create(T el, CompilationInfo c) {
        String format = "%name%";
        Group g = Group.TYPE;
        if (el.getKind() == ElementKind.FIELD) {
            format = format + " : %type%";
            g = Group.FIELD;
        } else if (el.getKind() == ElementKind.METHOD) {
            format = format + "%parameters% : %type%";
            g = Group.METHOD;
        } else if (el.getKind() == ElementKind.CONSTRUCTOR) {
            format = format + "%parameters%";
            g = Group.METHOD;
        }
        MemberInfo<ElementHandle<T>> mi = new MemberInfo<ElementHandle<T>>(ElementHandle.create(el), el.getSimpleName().toString(), ElementHeaders.getHeader(el, (CompilationInfo)c, (String)format), ElementIcons.getElementIcon((ElementKind)el.getKind(), el.getModifiers()));
        mi.modifiers = el.getModifiers();
        mi.group = g;
        return mi;
    }

    public static <T extends Element> MemberInfo<ElementHandle<T>> create(T el, CompilationInfo c, Group group) {
        MemberInfo<ElementHandle<T>> mi = new MemberInfo<ElementHandle<T>>(ElementHandle.create(el), el.getSimpleName().toString(), ElementHeaders.getHeader(el, (CompilationInfo)c, (String)"%name%"), ElementIcons.getElementIcon((ElementKind)el.getKind(), el.getModifiers()));
        mi.group = group;
        mi.modifiers = el.getModifiers();
        return mi;
    }

    public static MemberInfo<TreePathHandle> create(TreePath tpath, CompilationInfo c) {
        String format = "%name%";
        Group g = null;
        Element el = c.getTrees().getElement(tpath);
        if (el == null) {
            return null;
        }
        if (el.getKind() == ElementKind.FIELD) {
            format = format + " : %type%";
            g = Group.FIELD;
        } else if (el.getKind() == ElementKind.METHOD) {
            format = format + "%parameters% : %type%";
            g = Group.METHOD;
        } else if (el.getKind().isInterface()) {
            g = Group.IMPLEMENTS;
            format = "implements " + format;
        }
        MemberInfo<TreePathHandle> mi = new MemberInfo<TreePathHandle>(TreePathHandle.create((TreePath)tpath, (CompilationInfo)c), el.getSimpleName().toString(), ElementHeaders.getHeader((Element)el, (CompilationInfo)c, (String)format), ElementIcons.getElementIcon((ElementKind)el.getKind(), el.getModifiers()));
        mi.modifiers = el.getModifiers();
        mi.group = g;
        return mi;
    }

    private MemberInfo(H handle, String htmlText, Icon icon, String name, Group group, Set<Modifier> modifiers, boolean makeAbstract) {
        this.member = handle;
        this.htmlText = htmlText;
        this.icon = icon;
        this.name = name;
        this.group = group;
        this.modifiers = modifiers;
        this.makeAbstract = makeAbstract;
    }

    public static <T extends TypeMirror> MemberInfo<TypeMirrorHandle<T>> createImplements(TypeMirrorHandle handle, String htmlText, Icon icon, String name) {
        return new MemberInfo<TypeMirrorHandle<T>>(handle, htmlText, icon, name, Group.IMPLEMENTS, Collections.emptySet(), false);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (o instanceof MemberInfo && ((MemberInfo)o).member instanceof ElementHandle) {
            return ((ElementHandle)((MemberInfo)o).member).signatureEquals((ElementHandle)this.member);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public boolean isMakeAbstract() {
        return this.makeAbstract;
    }

    public void setMakeAbstract(Boolean b) {
        this.makeAbstract = b;
    }

    public String toString() {
        return this.htmlText;
    }

    public static enum Group {
        IMPLEMENTS,
        METHOD,
        FIELD,
        TYPE;

    }
}

