/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.js.breakpoints.URLEquality;
import org.netbeans.modules.debugger.jpda.js.source.ObservableSet;
import org.netbeans.modules.debugger.jpda.js.source.Source;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.util.Exceptions;

public class JSJavaBreakpointsManager
extends DebuggerManagerAdapter {
    private static final String NASHORN_CONTEXT_CLASS = "jdk.nashorn.internal.runtime.Context";
    private static final String NASHORN_CONTEXT_SOURCE_BIND_METHOD = "cacheClass";
    private static final String NASHORN_SCRIPT_RUNTIME_CLASS = "jdk.nashorn.internal.runtime.ScriptRuntime";
    private static final String NASHORN_SCRIPT_RUNTIME_DEBUGGER_METHOD = "DEBUGGER";
    private static final String NASHORN_FUNCTION_NODE_CLASS = "jdk.nashorn.internal.ir.FunctionNode";
    private static final String NASHORN_FUNCTION_NODE_SET_CLASS = "setRootClass";
    private static final Logger LOG = Logger.getLogger(JSJavaBreakpointsManager.class.getName());
    private final Map<JPDADebugger, ScriptsHandler> scriptHandlers = new HashMap<JPDADebugger, ScriptsHandler>();
    private final Map<URLEquality, Set<JSLineBreakpoint>> breakpointsByURL = new HashMap<URLEquality, Set<JSLineBreakpoint>>();
    private ClassLoadUnloadBreakpoint scriptBP;
    private MethodBreakpoint sourceBindBP;
    private MethodBreakpoint functionClassBP;
    private MethodBreakpoint debuggerBP;
    private final Object sourceBreakpointsInitLock = new Object();

    public Breakpoint[] initBreakpoints() {
        this.initSourceBreakpoints();
        return new Breakpoint[]{this.scriptBP, this.sourceBindBP, this.functionClassBP, this.debuggerBP};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSourceBreakpoints() {
        Object object = this.sourceBreakpointsInitLock;
        synchronized (object) {
            if (this.scriptBP == null) {
                this.scriptBP = ClassLoadUnloadBreakpoint.create((String)"jdk.nashorn.internal.scripts.Script$*", (boolean)false, (int)1);
                this.scriptBP.setHidden(true);
                this.scriptBP.setSuspend(0);
                this.sourceBindBP = MethodBreakpoint.create((String)NASHORN_CONTEXT_CLASS, (String)NASHORN_CONTEXT_SOURCE_BIND_METHOD);
                this.sourceBindBP.setHidden(true);
                this.sourceBindBP.setSuspend(1);
                this.functionClassBP = MethodBreakpoint.create((String)NASHORN_FUNCTION_NODE_CLASS, (String)NASHORN_FUNCTION_NODE_SET_CLASS);
                this.functionClassBP.setHidden(true);
                this.functionClassBP.setSuspend(1);
                this.debuggerBP = MethodBreakpoint.create((String)NASHORN_SCRIPT_RUNTIME_CLASS, (String)NASHORN_SCRIPT_RUNTIME_DEBUGGER_METHOD);
                this.debuggerBP.setHidden(true);
                this.debuggerBP.setSuspend(1);
            }
        }
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints", "debuggerEngines"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof JSLineBreakpoint)) {
            return;
        }
        JSLineBreakpoint jslb = (JSLineBreakpoint)breakpoint;
        URL url = jslb.getURL();
        URLEquality urle = new URLEquality(url);
        Map<URLEquality, Object> map = this.breakpointsByURL;
        synchronized (map) {
            Set<JSLineBreakpoint> bpts = this.breakpointsByURL.get(urle);
            if (bpts == null) {
                bpts = new HashSet<JSLineBreakpoint>();
                this.breakpointsByURL.put(urle, bpts);
            }
            bpts.add(jslb);
        }
        map = this.scriptHandlers;
        synchronized (map) {
            for (ScriptsHandler sh : this.scriptHandlers.values()) {
                sh.addBreakpoint(jslb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof JSLineBreakpoint)) {
            return;
        }
        JSLineBreakpoint jslb = (JSLineBreakpoint)breakpoint;
        URL url = jslb.getURL();
        URLEquality urle = new URLEquality(url);
        Map<URLEquality, Object> map = this.breakpointsByURL;
        synchronized (map) {
            Set<JSLineBreakpoint> bpts = this.breakpointsByURL.get(urle);
            if (bpts != null) {
                bpts.remove(jslb);
                if (bpts.isEmpty()) {
                    this.breakpointsByURL.remove(urle);
                }
            }
        }
        map = this.scriptHandlers;
        synchronized (map) {
            for (ScriptsHandler sh : this.scriptHandlers.values()) {
                sh.removeBreakpoint(jslb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineAdded(DebuggerEngine engine) {
        JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        Map<JPDADebugger, ScriptsHandler> map = this.scriptHandlers;
        synchronized (map) {
            if (this.scriptHandlers.containsKey(debugger)) {
                return;
            }
        }
        this.initSourceBreakpoints();
        ScriptsHandler sh = new ScriptsHandler(debugger);
        this.scriptBP.addJPDABreakpointListener((JPDABreakpointListener)sh);
        this.sourceBindBP.addJPDABreakpointListener((JPDABreakpointListener)sh);
        this.functionClassBP.addJPDABreakpointListener((JPDABreakpointListener)sh);
        this.debuggerBP.addJPDABreakpointListener((JPDABreakpointListener)sh);
        Map<JPDADebugger, ScriptsHandler> map2 = this.scriptHandlers;
        synchronized (map2) {
            this.scriptHandlers.put(debugger, sh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineRemoved(DebuggerEngine engine) {
        ScriptsHandler sh;
        JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        Map<JPDADebugger, ScriptsHandler> map = this.scriptHandlers;
        synchronized (map) {
            sh = this.scriptHandlers.remove(debugger);
        }
        if (sh != null) {
            this.scriptBP.removeJPDABreakpointListener((JPDABreakpointListener)sh);
            this.sourceBindBP.removeJPDABreakpointListener((JPDABreakpointListener)sh);
            this.functionClassBP.removeJPDABreakpointListener((JPDABreakpointListener)sh);
            this.debuggerBP.removeJPDABreakpointListener((JPDABreakpointListener)sh);
            this.scriptBP.enable();
            sh.destroy();
        }
    }

    private static final class LineBreakpointHandler {
        private final JPDADebugger debugger;
        private final JSLineBreakpoint jslb;
        private final Source source;
        private final List<LineBreakpoint> lbs = Collections.synchronizedList(new LinkedList());
        private final List<PropertyChangeListener> bpPropertyListeners = Collections.synchronizedList(new LinkedList());
        private final PropertyChangeListener functionClassChangesListener;

        LineBreakpointHandler(JPDADebugger debugger, JSLineBreakpoint jslb, Source source) {
            this.debugger = debugger;
            this.jslb = jslb;
            this.source = source;
            LineBreakpoint lb = this.createLineBreakpoint(source.getClassType());
            this.lbs.add(lb);
            this.functionClassChangesListener = new FunctionClassChangesListener();
            ObservableSet<JPDAClassType> functionClassTypes = source.getFunctionClassTypes();
            functionClassTypes.addPropertyChangeListener(this.functionClassChangesListener);
            for (JPDAClassType fct : functionClassTypes) {
                LineBreakpoint flb = this.createLineBreakpoint(fct);
                this.lbs.add(flb);
            }
        }

        private LineBreakpoint createLineBreakpoint(JPDAClassType classType) {
            int lineNo = this.jslb.getLineNumber();
            LineBreakpoint lb = LineBreakpoint.create((String)"", (int)(lineNo += this.source.getContentLineShift()));
            lb.setHidden(true);
            this.setPreferredClassType(lb, classType);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("LineBreakpointHandler.createLineBreakpoint() classtype = " + this.source.getClassType().getName());
            }
            lb.setSuspend(1);
            lb.setSession(this.debugger);
            if (!this.jslb.isEnabled()) {
                lb.disable();
            }
            lb.setCondition(this.jslb.getCondition());
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lb);
            BPPropertyListener bpPropertyListener = new BPPropertyListener(lb);
            this.jslb.addPropertyChangeListener((PropertyChangeListener)bpPropertyListener);
            this.bpPropertyListeners.add(bpPropertyListener);
            return lb;
        }

        void destroy() {
            for (LineBreakpoint lb : this.lbs) {
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lb);
            }
            for (PropertyChangeListener bpPropertyListener : this.bpPropertyListeners) {
                this.jslb.removePropertyChangeListener(bpPropertyListener);
            }
            this.source.getFunctionClassTypes().removePropertyChangeListener(this.functionClassChangesListener);
        }

        private void setPreferredClassType(LineBreakpoint lb, JPDAClassType classType) {
            try {
                Method setPreferredClassTypeMethod = lb.getClass().getMethod("setPreferredClassType", JPDAClassType.class);
                setPreferredClassTypeMethod.setAccessible(true);
                setPreferredClassTypeMethod.invoke((Object)lb, classType);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                lb.setPreferredClassName(this.source.getClassType().getName());
            }
        }

        private static class BPPropertyListener
        implements PropertyChangeListener {
            private final LineBreakpoint lb;

            BPPropertyListener(LineBreakpoint lb) {
                this.lb = lb;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName;
                switch (propertyName = evt.getPropertyName()) {
                    case "enabled": {
                        if (Boolean.TRUE.equals(evt.getNewValue())) {
                            this.lb.enable();
                        }
                        if (!Boolean.FALSE.equals(evt.getNewValue())) break;
                        this.lb.disable();
                        break;
                    }
                    case "condition": {
                        this.lb.setCondition((String)evt.getNewValue());
                    }
                }
            }
        }

        private class FunctionClassChangesListener
        implements PropertyChangeListener {
            private FunctionClassChangesListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("elementAdded".equals(evt.getPropertyName())) {
                    JPDAClassType ct = (JPDAClassType)evt.getNewValue();
                    LineBreakpoint lb = LineBreakpointHandler.this.createLineBreakpoint(ct);
                    LineBreakpointHandler.this.lbs.add(lb);
                }
            }
        }
    }

    private final class ScriptsHandler
    implements JPDABreakpointListener {
        private final JPDADebugger debugger;
        private final Map<MethodBreakpoint, JPDAClassType> scriptAccessBreakpoints = new HashMap<MethodBreakpoint, JPDAClassType>();
        private final Map<URLEquality, Source> sourcesByURL = new HashMap<URLEquality, Source>();
        private final Map<Long, Source> sourcesById = new HashMap<Long, Source>();
        private final Map<JSLineBreakpoint, LineBreakpointHandler> lineBreakpointHandlers = new HashMap<JSLineBreakpoint, LineBreakpointHandler>();
        private boolean isSourceBind = false;

        ScriptsHandler(JPDADebugger debugger) {
            this.debugger = debugger;
            this.retrieveExistingSources();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addBreakpoint(JSLineBreakpoint jslb) {
            Source source;
            URLEquality urleq = new URLEquality(jslb.getURL());
            Map<URLEquality, Source> map = this.sourcesByURL;
            synchronized (map) {
                source = this.sourcesByURL.get(urleq);
            }
            if (source != null) {
                this.createSourceLineBreakpoints(jslb, source);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void breakpointReached(JPDABreakpointEvent event) {
            if (this.debugger != event.getDebugger()) {
                return;
            }
            Object eventSource = event.getSource();
            if (JSJavaBreakpointsManager.this.scriptBP == eventSource) {
                JPDAClassType scriptType;
                Variable scriptClass = event.getVariable();
                if (!(scriptClass instanceof ClassVariable)) {
                    return;
                }
                try {
                    scriptType = (JPDAClassType)scriptClass.getClass().getMethod("getReflectedType", new Class[0]).invoke((Object)scriptClass, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    scriptType = null;
                }
                if (scriptType != null) {
                    MethodBreakpoint scriptMethodBP = MethodBreakpoint.create((String)scriptType.getName(), (String)"*getMap");
                    scriptMethodBP.setHidden(true);
                    scriptMethodBP.setSuspend(1);
                    scriptMethodBP.setSession(this.debugger);
                    scriptMethodBP.addJPDABreakpointListener((JPDABreakpointListener)this);
                    DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)scriptMethodBP);
                    Map<MethodBreakpoint, JPDAClassType> map = this.scriptAccessBreakpoints;
                    synchronized (map) {
                        this.scriptAccessBreakpoints.put(scriptMethodBP, scriptType);
                    }
                }
            } else if (JSJavaBreakpointsManager.this.sourceBindBP == eventSource) {
                LocalVariable sourceVar = null;
                Object scriptClass = null;
                try {
                    LocalVariable[] localVariables;
                    CallStackFrame csf = event.getThread().getCallStack(0, 1)[0];
                    block35: for (LocalVariable lv : localVariables = csf.getLocalVariables()) {
                        switch (lv.getName()) {
                            case "source": {
                                sourceVar = lv;
                                continue block35;
                            }
                            case "clazz": {
                                scriptClass = lv;
                            }
                        }
                    }
                }
                catch (AbsentInformationException csf) {
                    // empty catch block
                }
                if (scriptClass instanceof ObjectVariable) {
                    try {
                        Object jdiVal = scriptClass.getClass().getMethod("getJDIValue", new Class[0]).invoke(scriptClass, new Object[0]);
                        scriptClass = (Variable)this.debugger.getClass().getMethod("getVariable", Value.class).invoke((Object)this.debugger, jdiVal);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (sourceVar instanceof ObjectVariable && scriptClass instanceof ClassVariable) {
                    Source source;
                    JPDAClassType scriptType;
                    try {
                        scriptType = (JPDAClassType)scriptClass.getClass().getMethod("getReflectedType", new Class[0]).invoke(scriptClass, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        scriptType = null;
                    }
                    if (scriptType != null && (source = Source.getSource(this.debugger, scriptType, (ObjectVariable)sourceVar)) != null) {
                        this.sourceCreated(source);
                    }
                    if (!this.isSourceBind) {
                        this.isSourceBind = true;
                        JSJavaBreakpointsManager.this.scriptBP.disable();
                    }
                }
            } else if (JSJavaBreakpointsManager.this.functionClassBP == eventSource) {
                Variable rootClass = null;
                Field sourceVar = null;
                try {
                    LocalVariable[] localVariables;
                    CallStackFrame csf = event.getThread().getCallStack(0, 1)[0];
                    block36: for (LocalVariable lv : localVariables = csf.getLocalVariables()) {
                        switch (lv.getName()) {
                            case "rootClass": {
                                try {
                                    Object classValue = lv.getClass().getMethod("getJDIValue", new Class[0]).invoke((Object)lv, new Object[0]);
                                    if (classValue == null) continue block36;
                                    rootClass = (Variable)this.debugger.getClass().getMethod("getVariable", Value.class).invoke((Object)this.debugger, classValue);
                                    continue block36;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    This thisVariable = csf.getThisVariable();
                    if (thisVariable != null) {
                        sourceVar = thisVariable.getField("source");
                    }
                }
                catch (AbsentInformationException csf) {
                    // empty catch block
                }
                if (rootClass instanceof ClassVariable && sourceVar instanceof ObjectVariable) {
                    Source source;
                    long sourceVarId = ((ObjectVariable)sourceVar).getUniqueID();
                    Map<URLEquality, Source> map = this.sourcesByURL;
                    synchronized (map) {
                        source = this.sourcesById.get(sourceVarId);
                    }
                    if (source != null) {
                        source.addFunctionClass((ClassVariable)rootClass);
                    }
                }
            } else if (JSJavaBreakpointsManager.this.debuggerBP == eventSource) {
                JPDAStep step = this.debugger.createJPDAStep(-2, 1);
                step.addStep(event.getThread());
            } else {
                JPDAClassType scriptType;
                MethodBreakpoint scriptMethodBP = (MethodBreakpoint)eventSource;
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)scriptMethodBP);
                Map<MethodBreakpoint, JPDAClassType> sourceVarId = this.scriptAccessBreakpoints;
                synchronized (sourceVarId) {
                    scriptType = this.scriptAccessBreakpoints.remove(scriptMethodBP);
                }
                Source source = Source.getSource(scriptType);
                if (source != null) {
                    this.sourceCreated(source);
                }
            }
            event.resume();
        }

        private void retrieveExistingSources() {
            if (this.debugger.getState() < 2) {
                this.debugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (Integer.valueOf(2).equals(evt.getNewValue())) {
                            ScriptsHandler.this.retrieveExistingSources();
                            ScriptsHandler.this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
                        }
                    }
                });
                return;
            }
            List classesByName = this.debugger.getClassesByName(JSJavaBreakpointsManager.NASHORN_CONTEXT_CLASS);
            if (classesByName.isEmpty()) {
                return;
            }
            JPDAClassType contextClass = (JPDAClassType)classesByName.get(0);
            List contextInstances = contextClass.getInstances(0L);
            if (contextInstances.isEmpty()) {
                return;
            }
            ObjectVariable context = (ObjectVariable)contextInstances.get(0);
            final ObjectVariable classCache = (ObjectVariable)context.getField("classCache");
            if (classCache == null) {
                LOG.log(Level.CONFIG, "No classCache field in " + context.getValue());
                return;
            }
            final MethodBreakpoint inNashorn = MethodBreakpoint.create((String)JSJavaBreakpointsManager.NASHORN_FUNCTION_NODE_CLASS, (String)"*");
            final AtomicBoolean retrieved = new AtomicBoolean(false);
            inNashorn.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    try {
                        if (!retrieved.getAndSet(true)) {
                            inNashorn.disable();
                            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)inNashorn);
                            ScriptsHandler.this.doRetrieveExistingSources(classCache);
                        }
                    }
                    finally {
                        event.resume();
                    }
                }
            });
            inNashorn.setSession(this.debugger);
            inNashorn.setHidden(true);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)inNashorn);
        }

        private void doRetrieveExistingSources(ObjectVariable classCache) {
            Field[] classReferences;
            ObjectVariable crArray;
            ObjectVariable crCollection;
            try {
                crCollection = (ObjectVariable)classCache.invokeMethod("values", "()Ljava/util/Collection;", new Variable[0]);
            }
            catch (NoSuchMethodException | InvalidExpressionException ex) {
                LOG.log(Level.CONFIG, "Problems retrieving values from ClassCache", ex);
                return;
            }
            try {
                crArray = (ObjectVariable)crCollection.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
            }
            catch (NoSuchMethodException | InvalidExpressionException ex) {
                LOG.log(Level.CONFIG, "Problems retrieving array values from ClassCache's collection", ex);
                return;
            }
            for (Field cr : classReferences = crArray.getFields(0, Integer.MAX_VALUE)) {
                Source source;
                JPDAClassType scriptType;
                Variable scriptClass;
                try {
                    scriptClass = ((ObjectVariable)cr).invokeMethod("get", "()Ljava/lang/Object;", new Variable[0]);
                }
                catch (NoSuchMethodException | InvalidExpressionException ex) {
                    LOG.log(Level.CONFIG, "Problems retrieving values from ClassCache", ex);
                    continue;
                }
                if (scriptClass == null) continue;
                Field sourceVar = ((ObjectVariable)cr).getField("source");
                if (scriptClass instanceof ObjectVariable) {
                    try {
                        Object jdiVal = scriptClass.getClass().getMethod("getJDIValue", new Class[0]).invoke((Object)scriptClass, new Object[0]);
                        scriptClass = (Variable)this.debugger.getClass().getMethod("getVariable", Value.class).invoke((Object)this.debugger, jdiVal);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (!(sourceVar instanceof ObjectVariable) || !(scriptClass instanceof ClassVariable)) continue;
                try {
                    scriptType = (JPDAClassType)scriptClass.getClass().getMethod("getReflectedType", new Class[0]).invoke((Object)scriptClass, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    scriptType = null;
                }
                if (scriptType == null || (source = Source.getSource(this.debugger, scriptType, (ObjectVariable)sourceVar)) == null) continue;
                this.sourceCreated(source);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sourceCreated(Source source) {
            URL url = source.getUrl();
            if (url != null) {
                URLEquality urleq = new URLEquality(url);
                Map<URLEquality, Source> map = this.sourcesByURL;
                synchronized (map) {
                    this.sourcesByURL.put(urleq, source);
                    this.sourcesById.put(source.getSourceVarId(), source);
                }
                this.createSourceLineBreakpoints(urleq, source);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSourceLineBreakpoints(JSLineBreakpoint jslb, Source source) {
            URL url = source.getUrl();
            if (url == null) {
                return;
            }
            URLEquality urle = new URLEquality(url);
            URLEquality bpurle = new URLEquality(jslb.getURL());
            if (urle.equals(bpurle)) {
                LineBreakpointHandler lbh = new LineBreakpointHandler(this.debugger, jslb, source);
                Map<JSLineBreakpoint, LineBreakpointHandler> map = this.lineBreakpointHandlers;
                synchronized (map) {
                    this.lineBreakpointHandlers.put(jslb, lbh);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSourceLineBreakpoints(URLEquality urle, Source source) {
            HashSet bpts;
            URL url = source.getUrl();
            if (url == null) {
                return;
            }
            Map map = JSJavaBreakpointsManager.this.breakpointsByURL;
            synchronized (map) {
                bpts = (HashSet)JSJavaBreakpointsManager.this.breakpointsByURL.get(urle);
                if (bpts != null) {
                    bpts = new HashSet(bpts);
                }
            }
            if (bpts != null) {
                for (JSLineBreakpoint bp : bpts) {
                    URLEquality bpurle = new URLEquality(bp.getURL());
                    if (!urle.equals(bpurle)) continue;
                    LineBreakpointHandler lbh = new LineBreakpointHandler(this.debugger, bp, source);
                    Map<JSLineBreakpoint, LineBreakpointHandler> map2 = this.lineBreakpointHandlers;
                    synchronized (map2) {
                        this.lineBreakpointHandlers.put(bp, lbh);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeBreakpoint(JSLineBreakpoint jslb) {
            LineBreakpointHandler lbh;
            Map<JSLineBreakpoint, LineBreakpointHandler> map = this.lineBreakpointHandlers;
            synchronized (map) {
                lbh = this.lineBreakpointHandlers.remove(jslb);
            }
            if (lbh != null) {
                lbh.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            HashSet<MethodBreakpoint> mbs;
            Map<URLEquality, Object> map = this.scriptAccessBreakpoints;
            synchronized (map) {
                mbs = new HashSet<MethodBreakpoint>(this.scriptAccessBreakpoints.keySet());
                this.scriptAccessBreakpoints.clear();
            }
            for (MethodBreakpoint mb : mbs) {
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb);
            }
            map = this.sourcesByURL;
            synchronized (map) {
                this.sourcesByURL.clear();
                this.sourcesById.clear();
            }
            map = this.lineBreakpointHandlers;
            synchronized (map) {
                for (LineBreakpointHandler lbh : this.lineBreakpointHandlers.values()) {
                    lbh.destroy();
                }
                this.lineBreakpointHandlers.clear();
            }
        }
    }
}

