/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.google.common.base.Function;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TransformingFuture<FROM, TO>
implements Future<TO> {
    private final Future<FROM> delegate;
    private final Function<FROM, TO> transformer;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public TO get() throws InterruptedException, ExecutionException {
        FROM from = this.delegate.get();
        return (TO)this.transformer.apply(from);
    }

    @Override
    public TO get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FROM from = this.delegate.get(timeout, unit);
        return (TO)this.transformer.apply(from);
    }

    @ConstructorProperties(value={"delegate", "transformer"})
    public TransformingFuture(Future<FROM> delegate, Function<FROM, TO> transformer) {
        this.delegate = delegate;
        this.transformer = transformer;
    }
}

