/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import org.apache.jasper.JasperException;
import org.apache.tomcat.context.AutoSetup;
import org.apache.tomcat.context.DefaultCMSetter;
import org.apache.tomcat.context.LoadOnStartupInterceptor;
import org.apache.tomcat.context.LoaderInterceptor;
import org.apache.tomcat.context.LogEvents;
import org.apache.tomcat.context.WebXmlReader;
import org.apache.tomcat.context.WorkDirInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.logging.LogHelper;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.request.SessionInterceptor;
import org.apache.tomcat.request.SimpleMapper1;
import org.apache.tomcat.service.PoolTcpConnector;
import org.apache.tomcat.service.http.HttpConnectionHandler;
import org.apache.tomcat.session.StandardSessionInterceptor;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.URLUtil;

public class ContextManager {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Vector requestInterceptors = new Vector();
    private Vector contextInterceptors = new Vector();
    ContextInterceptor[] cInterceptors;
    RequestInterceptor[] rInterceptors;
    private Object permissions;
    Vector connectors = new Vector();
    private Vector contextsV = new Vector();
    int debug = 0;
    String workDir = null;
    String workDirProperty = null;
    String home;
    String installDir;
    int securePort = -1;
    boolean showDebugInfo = true;
    public static final String DEFAULT_WORK_DIR = "work";
    private ClassLoader parentLoader;
    private int[] noteId = new int[4];
    public static final int MAX_NOTES = 32;
    public static final int RESERVED = 3;
    public static final int SERVER_NOTE = 0;
    public static final int CONTAINER_NOTE = 1;
    public static final int REQUEST_NOTE = 2;
    public static final int HANDLER_NOTE = 3;
    public static final int REQ_RE_NOTE = 0;
    String[][] noteName = new String[4][32];
    Object[] notes = new Object[32];
    boolean firstLog = true;
    LogHelper loghelper = new LogHelper("tc_log", "ContextManager");
    public static final int ACC_INIT_START = 0;
    public static final int ACC_INIT_END = 0;
    public static final int ACCOUNTS = 7;
    long[] accTable = new long[7];
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 8080;
    String hostname;
    int port;
    private Hashtable contexts = new Hashtable();

    public void setHome(String home) {
        this.home = FileUtil.getCanonicalPath(home);
        if (this.debug > 0) {
            this.logInt("Setting home to " + this.home);
        }
    }

    public String getHome() {
        if (this.debug > 20) {
            this.logInt("getHome " + this.home + " " + this.installDir + " " + System.getProperty("tomcat.home") + " " + FileUtil.getCanonicalPath("."));
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.home != null) {
            return this.home;
        }
        if (this.installDir != null) {
            this.home = FileUtil.getCanonicalPath(this.installDir);
        }
        if (this.home != null) {
            return this.home;
        }
        this.home = FileUtil.getCanonicalPath(System.getProperty("tomcat.home"));
        if (this.home != null) {
            return this.home;
        }
        this.home = FileUtil.getCanonicalPath(".");
        return this.home;
    }

    public String getInstallDir() {
        if (this.debug > 20) {
            this.logInt("getInstallDir " + this.installDir + " " + System.getProperty("tomcat.home"));
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.installDir != null) {
            return this.installDir;
        }
        this.installDir = System.getProperty("tomcat.home");
        if (this.installDir != null) {
            return this.installDir;
        }
        this.installDir = this.getHome();
        return this.installDir;
    }

    public void setInstallDir(String tH) {
        this.installDir = tH;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(int p) {
        this.securePort = p;
    }

    public void setWorkDir(String wd) {
        if (this.debug > 0) {
            this.logInt("set work dir " + wd);
        }
        this.workDirProperty = wd;
    }

    public String getWorkDir() {
        if (this.workDir == null) {
            File f = null;
            f = this.workDirProperty == null ? new File(DEFAULT_WORK_DIR) : new File(this.workDirProperty);
            if (!f.isAbsolute()) {
                f = this.getAbsolute(f);
            }
            this.workDir = f.getAbsolutePath();
            if (this.debug > 0) {
                this.logInt("calc work dir " + this.workDir);
            }
        }
        return this.workDir;
    }

    public Object getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Object permissions) {
        this.permissions = permissions;
    }

    public String getRandomClass() {
        String randomClass = System.getProperty("tomcat.sessionid.randomclass");
        return randomClass == null ? "java.security.SecureRandom" : randomClass;
    }

    public void setRandomClass(String randomClass) {
        Properties sysProp = System.getProperties();
        ((Hashtable)sysProp).put("tomcat.sessionid.randomclass", randomClass);
    }

    public boolean getShowDebugInfo() {
        return this.showDebugInfo;
    }

    public void setShowDebugInfo(boolean showDebugInfo) {
        this.showDebugInfo = showDebugInfo;
    }

    public void setParentClassLoader(ClassLoader cl) {
        this.parentLoader = cl;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentLoader;
    }

    public void setDefaults() {
        if (this.connectors.size() == 0) {
            if (this.debug > 5) {
                this.logInt("Setting default adapter");
            }
            PoolTcpConnector sc = new PoolTcpConnector();
            sc.setTcpConnectionHandler(new HttpConnectionHandler());
            this.addServerConnector(sc);
        }
        if (this.contextInterceptors.size() == 0) {
            if (this.debug > 5) {
                this.logInt("Setting default context interceptors");
            }
            this.addContextInterceptor(new LogEvents());
            this.addContextInterceptor(new AutoSetup());
            this.addContextInterceptor(new LoaderInterceptor());
            this.addContextInterceptor(new DefaultCMSetter());
            this.addContextInterceptor(new WorkDirInterceptor());
            this.addContextInterceptor(new WebXmlReader());
            this.addContextInterceptor(new LoadOnStartupInterceptor());
        }
        if (this.requestInterceptors.size() == 0) {
            if (this.debug > 5) {
                this.logInt("Setting default request interceptors");
            }
            this.addRequestInterceptor(new SessionInterceptor());
            SimpleMapper1 smap = new SimpleMapper1();
            smap.setContextManager(this);
            this.addRequestInterceptor(smap);
            this.addRequestInterceptor(new StandardSessionInterceptor());
        }
    }

    public void init() throws TomcatException {
        if (this.debug > 0) {
            this.logInt("Tomcat classpath = " + System.getProperty("java.class.path"));
        }
        this.setAccount(0, System.currentTimeMillis());
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].engineInit(this);
            ++i;
        }
        Enumeration enumeration = this.getContexts();
        while (enumeration.hasMoreElements()) {
            Context context = (Context)enumeration.nextElement();
            try {
                this.initContext(context);
            }
            catch (TomcatException ex) {
                if (context == null) continue;
                this.logInt("ERROR initializing " + context.toString());
                this.removeContext(context);
                Throwable ex1 = ex.getRootCause();
                if (ex1 == null) continue;
                ex.printStackTrace();
            }
        }
        this.setAccount(0, System.currentTimeMillis());
    }

    public void shutdown() throws TomcatException {
        while (!this.contextsV.isEmpty()) {
            this.removeContext((Context)this.contextsV.firstElement());
        }
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].engineShutdown(this);
            ++i;
        }
    }

    public void initContext(Context ctx) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].contextInit(ctx);
            ++i;
        }
    }

    public void shutdownContext(Context ctx) throws TomcatException {
        Enumeration enumeration = ctx.getServletNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ServletWrapper wrapper = ctx.getServletByName(key);
            ctx.removeServletByName(key);
            try {
                wrapper.destroy();
            }
            catch (Exception ex) {
                ctx.log("Error in destroy ", ex);
            }
        }
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].contextShutdown(ctx);
            ++i;
        }
    }

    public void start() throws Exception {
        Enumeration connE = this.getConnectors();
        while (connE.hasMoreElements()) {
            ((ServerConnector)connE.nextElement()).start();
        }
    }

    public void stop() throws Exception {
        if (this.debug > 0) {
            this.logInt("Stopping context manager ");
        }
        Enumeration connE = this.getConnectors();
        while (connE.hasMoreElements()) {
            ((ServerConnector)connE.nextElement()).stop();
        }
        this.shutdown();
    }

    public Enumeration getContexts() {
        return this.contextsV.elements();
    }

    public void addContext(Context ctx) throws TomcatException {
        ctx.setContextManager(this);
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].addContext(this, ctx);
            ++i;
        }
        String vhost = ctx.getHost();
        this.logInt("Adding context " + ctx.toString());
        if (vhost == null) {
            this.contexts.put(ctx.getPath(), ctx);
        }
        this.contextsV.addElement(ctx);
    }

    public void removeContext(Context context) throws TomcatException {
        if (context == null) {
            return;
        }
        this.logInt("Removing context " + context.toString());
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].removeContext(this, context);
            ++i;
        }
        this.shutdownContext(context);
        this.contextsV.removeElement(context);
    }

    void doReload(Request req, Context context) throws TomcatException {
        if (context == null) {
            return;
        }
        if (this.debug > 0) {
            this.logInt("Reloading context " + context.toString());
        }
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].reload(req, context);
            ++i;
        }
    }

    public void addContainer(Container container) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].addContainer(container);
            ++i;
        }
    }

    public void removeContainer(Container container) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].removeContainer(container);
            ++i;
        }
    }

    public synchronized void addServerConnector(ServerConnector con) {
        if (this.debug > 0) {
            this.logInt("Add connector javaClass=\"" + con.getClass().getName() + "\"");
        }
        con.setServer(this);
        this.connectors.addElement(con);
    }

    public Enumeration getConnectors() {
        return this.connectors.elements();
    }

    public void addRequestInterceptor(RequestInterceptor ri) {
        if (this.debug > 0) {
            this.logInt("Add requestInterceptor javaClass=\"" + ri.getClass().getName() + "\" ");
        }
        this.requestInterceptors.addElement(ri);
        if (ri instanceof ContextInterceptor) {
            this.contextInterceptors.addElement(ri);
        }
    }

    public RequestInterceptor[] getRequestInterceptors(Request req) {
        return this.getRequestInterceptors();
    }

    public RequestInterceptor[] getRequestInterceptors() {
        if (this.rInterceptors == null || this.rInterceptors.length != this.requestInterceptors.size()) {
            this.rInterceptors = new RequestInterceptor[this.requestInterceptors.size()];
            int i = 0;
            while (i < this.rInterceptors.length) {
                this.rInterceptors[i] = (RequestInterceptor)this.requestInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.rInterceptors;
    }

    public void addContextInterceptor(ContextInterceptor ci) {
        if (this.debug > 0) {
            this.logInt("Add contextInterceptor javaClass=\"" + ci.getClass().getName() + "\" ");
        }
        this.contextInterceptors.addElement(ci);
    }

    public ContextInterceptor[] getContextInterceptors() {
        if (this.contextInterceptors.size() == 0) {
            this.setDefaults();
        }
        if (this.cInterceptors == null || this.cInterceptors.length != this.contextInterceptors.size()) {
            this.cInterceptors = new ContextInterceptor[this.contextInterceptors.size()];
            int i = 0;
            while (i < this.cInterceptors.length) {
                this.cInterceptors[i] = (ContextInterceptor)this.contextInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.cInterceptors;
    }

    public void initRequest(Request req, Response resp) {
        resp.setRequest(req);
        req.setResponse(resp);
        req.setContextManager(this);
    }

    public void service(Request req, Response res) {
        req.setRequestURI(URLUtil.normalizeURI(req.getRequestURI()));
        this.internalService(req, res);
        try {
            res.finish();
            req.recycle();
            res.recycle();
        }
        catch (Throwable ex) {
            this.handleError(req, res, ex);
        }
    }

    private void internalService(Request req, Response res) {
        try {
            int status = res.getStatus();
            if (status >= 400) {
                if (this.debug > 0) {
                    this.log("Error reading request " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            status = this.processRequest(req);
            if (status != 0) {
                if (this.debug > 0) {
                    this.log("Error mapping the request " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            if (req.getWrapper() == null) {
                status = 404;
                if (this.debug > 0) {
                    this.log("No handler for request " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            String[] roles = req.getRequiredRoles();
            if (roles != null) {
                status = this.doAuthorize(req, res, roles);
            }
            if (status > 200) {
                if (this.debug > 0) {
                    this.log("Authorize error " + req + " " + status);
                }
                this.handleStatus(req, res, status);
                return;
            }
            req.getWrapper().service(req, res);
        }
        catch (Throwable t) {
            this.handleError(req, res, t);
        }
    }

    public int processRequest(Request req) {
        if (this.debug > 9) {
            this.logInt("ProcessRequest: " + req.toString());
        }
        int status = 0;
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            status = ((RequestInterceptor)this.requestInterceptors.elementAt(i)).contextMap(req);
            if (status != 0) {
                return status;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.requestInterceptors.size()) {
            status = ((RequestInterceptor)this.requestInterceptors.elementAt(i2)).requestMap(req);
            if (status != 0) {
                return status;
            }
            ++i2;
        }
        if (this.debug > 9) {
            this.logInt("After processing: " + req.toString());
        }
        return 0;
    }

    public int doAuthenticate(Request req, Response res) {
        int status = 0;
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            status = reqI[i].authenticate(req, res);
            if (status != 0) {
                if (this.debug > 0) {
                    this.logInt("Authenticate status " + status);
                }
                return status;
            }
            ++i;
        }
        return 0;
    }

    public int doAuthorize(Request req, Response res, String[] roles) {
        int status = 0;
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            status = reqI[i].authorize(req, res, roles);
            if (status != 0) {
                if (this.debug > 0) {
                    this.logInt("Authorize status " + status);
                }
                return status;
            }
            ++i;
        }
        return 0;
    }

    int doBeforeBody(Request req, Response res) {
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].beforeBody(req, res);
            ++i;
        }
        return 0;
    }

    int doBeforeCommit(Request req, Response res) {
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].beforeCommit(req, res);
            ++i;
        }
        return 0;
    }

    int doPreService(Request req, Response res) {
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].preService(req, res);
            ++i;
        }
        return 0;
    }

    int doPostService(Request req, Response res) {
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].postService(req, res);
            ++i;
        }
        return 0;
    }

    int doNewSessionRequest(Request req, Response res) {
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].newSessionRequest(req, res);
            ++i;
        }
        return 0;
    }

    int doAfterBody(Request req, Response res) {
        RequestInterceptor[] reqI = this.getRequestInterceptors(req);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].afterBody(req, res);
            ++i;
        }
        return 0;
    }

    public Request createRequest(Context ctx, String urlPath) {
        String contextPath = ctx.getPath();
        String origPath = urlPath;
        if (!"".equals(contextPath) && !"/".equals(contextPath)) {
            urlPath = urlPath.startsWith("/") ? contextPath + urlPath : contextPath + "/" + urlPath;
        } else if (!urlPath.startsWith("/")) {
            urlPath = "/" + urlPath;
        }
        if (this.debug > 4) {
            this.logInt("createRequest " + origPath + " " + urlPath);
        }
        Request req = this.createRequest(urlPath);
        String host = ctx.getHost();
        if (host != null) {
            req.setServerName(host);
        }
        return req;
    }

    public Request createRequest(String urlPath) {
        String queryString = null;
        int i = urlPath.indexOf("?");
        int len = urlPath.length();
        if (i > -1) {
            if (i < len) {
                queryString = urlPath.substring(i + 1, urlPath.length());
            }
            urlPath = urlPath.substring(0, i);
        }
        RequestImpl lr = new RequestImpl();
        lr.setRequestURI(urlPath);
        lr.setQueryString(queryString);
        return lr;
    }

    public void saveErrorURI(Request req, Response res) {
        if (res.getErrorURI() == null) {
            res.setErrorURI((String)req.getAttribute("javax.servlet.include.request_uri"));
        }
    }

    public void handleStatus(Request req, Response res, int code) {
        String errorPath = null;
        ServletWrapper errorServlet = null;
        try {
            res.resetBuffer();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (code == 0) {
            code = res.getStatus();
        } else {
            res.setStatus(code);
        }
        Context ctx = req.getContext();
        if (ctx == null) {
            ctx = this.getContext("");
        }
        if (ctx == null) {
            try {
                this.handleContextNotFound(req, res);
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        if (code != 302 && code != 401) {
            ctx.log(code + " " + req + " " + req.getAttribute("javax.servlet.error.message"));
        }
        if ((errorPath = ctx.getErrorPage(code)) != null) {
            errorServlet = this.getHandlerForPath(ctx, errorPath);
            if (errorPath.indexOf("tomcat.") != 0) {
                req.setAttribute("javax.servlet.include.request_uri", ctx.getPath() + "/" + errorPath);
                req.setAttribute("javax.servlet.include.servlet_path", errorPath);
            }
        }
        if (this.debug > 0) {
            ctx.log("Handler " + errorServlet + " " + errorPath);
        }
        if (this.statusLoop(ctx, req, code)) {
            this.log("Error loop for " + req + " error code " + code);
            return;
        }
        if (errorServlet == null) {
            errorServlet = code == 404 ? ctx.getServletByName("tomcat.notFoundHandler") : ctx.getServletByName("tomcat.statusHandler");
        }
        req.setAttribute("javax.servlet.error.status_code", new Integer(code));
        req.setAttribute("tomcat.servlet.error.request", req);
        try {
            ((Handler)errorServlet).service(req, res);
        }
        catch (IOException e) {
        }
        catch (ServletException e) {
            // empty catch block
        }
    }

    void handleError(Request req, Response res, Throwable t) {
        Context ctx = req.getContext();
        if (ctx == null) {
            ctx = this.getContext("");
        }
        if (t instanceof UnavailableException) {
            int unavailableTime = -1;
            if (!((UnavailableException)t).isPermanent()) {
                unavailableTime = ((UnavailableException)t).getUnavailableSeconds();
                if (unavailableTime <= 0) {
                    unavailableTime = 1;
                }
                res.setHeader("Retry-After", Integer.toString(unavailableTime));
            }
            String msg = t.getMessage();
            ctx.log("UnavailableException in: " + req + ", time remaining " + unavailableTime + " seconds : " + msg, t);
            req.setAttribute("javax.servlet.error.message", msg);
            req.setAttribute("tomcat.servlet.error.unavailableTime", new Integer(unavailableTime));
            res.setStatus(503);
            this.handleStatus(req, res, 503);
            return;
        }
        if (t instanceof IllegalStateException) {
            ctx.log("IllegalStateException in: " + req + " " + t.getMessage());
        } else if (t instanceof JasperException) {
            ctx.log("JasperException: " + req + " " + t.getMessage());
        } else if (t instanceof IOException) {
            if ("Broken pipe".equals(t.getMessage())) {
                return;
            }
            ctx.log("IOException in: " + req + " " + t.getMessage());
        } else {
            ctx.log("Exception in: " + req, t);
        }
        if (null != req.getAttribute("tomcat.servlet.error.defaultHandler")) {
            System.out.println("ERROR: can't find default error handler or error in default error page");
            t.printStackTrace();
        }
        String errorPath = null;
        ServletWrapper errorServlet = null;
        Class<?> clazz = t.getClass();
        while (errorPath == null && clazz != null) {
            String name = clazz.getName();
            errorPath = ctx.getErrorPage(name);
            clazz = clazz.getSuperclass();
        }
        if (errorPath != null) {
            errorServlet = this.getHandlerForPath(ctx, errorPath);
            req.setAttribute("javax.servlet.include.request_uri", ctx.getPath() + "/" + errorPath);
            req.setAttribute("javax.servlet.include.servlet_path", errorPath);
        }
        if (this.errorLoop(ctx, req) || errorServlet == null) {
            errorServlet = ctx.getServletByName("tomcat.exceptionHandler");
        } else {
            try {
                res.resetBuffer();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        req.setAttribute("javax.servlet.error.exception_type", t.getClass());
        req.setAttribute("javax.servlet.error.message", t.getMessage());
        req.setAttribute("javax.servlet.jsp.jspException", t);
        req.setAttribute("tomcat.servlet.error.throwable", t);
        req.setAttribute("tomcat.servlet.error.request", req);
        try {
            ((Handler)errorServlet).service(req, res);
        }
        catch (IOException e) {
        }
        catch (ServletException e) {
            // empty catch block
        }
    }

    public ServletWrapper getHandlerForPath(Context ctx, String path) {
        if (!path.startsWith("/")) {
            return ctx.getServletByName(path);
        }
        RequestImpl req1 = new RequestImpl();
        ResponseImpl res1 = new ResponseImpl();
        this.initRequest(req1, res1);
        req1.setServerName(ctx.getHost());
        req1.setRequestURI(ctx.getPath() + path);
        this.processRequest(req1);
        return req1.getWrapper();
    }

    private boolean errorLoop(Context ctx, Request req) {
        if (req.getAttribute("javax.servlet.error.status_code") != null || req.getAttribute("javax.servlet.error.exception_type") != null) {
            if (ctx.getDebug() > 0) {
                ctx.log("Error: exception inside exception servlet " + req.getAttribute("javax.servlet.error.status_code") + " " + req.getAttribute("javax.servlet.error.exception_type"));
            }
            return true;
        }
        return false;
    }

    private boolean statusLoop(Context ctx, Request req, int newCode) {
        Integer lastCode = (Integer)req.getAttribute("javax.servlet.error.status_code");
        if (lastCode != null && lastCode == newCode) {
            if (ctx.getDebug() > 0) {
                ctx.log("Error: nested error inside status servlet " + req.getAttribute("javax.servlet.error.status_code"));
            }
            return true;
        }
        return false;
    }

    private void handleContextNotFound(Request req, Response res) throws IOException {
        StringManager sm = StringManager.getManager("org.apache.tomcat.resources");
        res.setContentType("text/html");
        String requestURI = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null || res.isIncluded()) {
            requestURI = req.getRequestURI();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>").append(sm.getString("defaulterrorpage.notfound404")).append("</title></head>\r\n");
        buf.append("<body><h1>").append(sm.getString("defaulterrorpage.notfound404")).append("</h1>\r\n<b>");
        buf.append(sm.getString("defaulterrorpage.originalrequest")).append("</b> ").append(RequestUtil.filter(requestURI));
        if (this.getShowDebugInfo()) {
            if (res.isIncluded()) {
                requestURI = (String)req.getAttribute("javax.servlet.include.request_uri");
            }
            if (requestURI != null) {
                buf.append("<br><br>\r\n<b>").append(sm.getString("defaulterrorpage.notfoundrequest")).append("</b> ").append(RequestUtil.filter(requestURI));
            }
        }
        buf.append("</body>\r\n");
        String body = buf.toString();
        res.setContentLength(body.length());
        if (res.isUsingStream()) {
            ServletOutputStream out = res.getOutputStream();
            out.print(body);
            out.flush();
        } else {
            PrintWriter out = res.getWriter();
            out.print(body);
            out.flush();
        }
    }

    public synchronized int getNoteId(int noteType, String name) throws TomcatException {
        int i = 0;
        while (i < this.noteId[noteType]) {
            if (name.equals(this.noteName[noteType][i])) {
                return i;
            }
            ++i;
        }
        if (this.noteId[noteType] >= 32) {
            throw new TomcatException("Too many notes ");
        }
        if (this.noteId[noteType] < 3) {
            this.noteId[noteType] = 3;
        }
        this.noteName[noteType][this.noteId[noteType]] = name;
        int n = noteType;
        int n2 = this.noteId[n];
        this.noteId[n] = n2 + 1;
        return n2;
    }

    public String getNoteName(int noteType, int noteId) {
        return this.noteName[noteType][noteId];
    }

    public void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public Object getNote(int pos) {
        return this.notes[pos];
    }

    public void addLogger(Logger l) {
        File f;
        String path = l.getPath();
        if (path != null && !(f = new File(path)).isAbsolute()) {
            File wd = this.getAbsolute(f);
            l.setPath(wd.getAbsolutePath());
        }
        l.open();
    }

    public void setDebug(int level) {
        if (level != 0) {
            System.out.println("Setting level to " + level);
        }
        this.debug = level;
    }

    public int getDebug() {
        return this.debug;
    }

    public final void log(String msg) {
        this.loghelper.log(msg);
    }

    private final void logInt(String msg) {
        this.loghelper.log(msg);
    }

    public final void doLog(String msg) {
        this.loghelper.log(msg);
    }

    public final void doLog(String msg, Throwable t) {
        this.loghelper.log(msg, t);
    }

    public final void doLog(String msg, Throwable t, int level) {
        this.loghelper.log(msg, t, level);
    }

    public void setAccount(int pos, long value) {
        this.accTable[pos] = value;
    }

    public long getAccount(int pos) {
        return this.accTable[pos];
    }

    public void setPort(int port) {
        if (this.debug > 20) {
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.port = port;
    }

    public int getPort() {
        if (this.port == 0) {
            this.port = 8080;
        }
        return this.port;
    }

    public void setHostName(String host) {
        if (this.debug > 20) {
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.hostname = host;
    }

    public String getHostName() {
        if (this.hostname == null) {
            this.hostname = DEFAULT_HOSTNAME;
        }
        return this.hostname;
    }

    public Enumeration getContextNames() {
        if (this.debug > 20) {
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.contexts.keys();
    }

    public Context getContext(String name) {
        return (Context)this.contexts.get(name);
    }

    public void removeContext(String name) throws TomcatException {
        Context context = (Context)this.contexts.get(name);
        this.log("Removing context " + context.toString());
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].removeContext(this, context);
            ++i;
        }
        if (context != null) {
            this.shutdownContext(context);
            this.contexts.remove(name);
        }
    }

    public void doPreServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            try {
                cI[i].preServletInit(ctx, sw);
            }
            catch (TomcatException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public void doPostServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            try {
                cI[i].postServletInit(ctx, sw);
            }
            catch (TomcatException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public void doPreServletDestroy(Context ctx, ServletWrapper sw) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            try {
                cI[i].preServletDestroy(ctx, sw);
            }
            catch (TomcatException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public void doPostServletDestroy(Context ctx, ServletWrapper sw) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            try {
                cI[i].postServletDestroy(ctx, sw);
            }
            catch (TomcatException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public void setTomcatHome(String s) {
        this.setInstallDir(s);
    }

    public String getTomcatHome() {
        return this.getInstallDir();
    }

    public File getAbsolute(File f) {
        if (!f.isAbsolute()) {
            return new File(this.getHome(), f.getPath());
        }
        return f;
    }
}

