/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.ui;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.Authentication;
import org.openide.util.Exceptions;

public class SSHKeyFileFilter
implements FileFilter {
    private static final Pattern p = Pattern.compile("-+ *BEGIN.*PRIVATE.*KEY *-+.*");
    private static final Charset cs = Charset.forName("US-ASCII");
    private static final SSHKeyFileFilter instance = new SSHKeyFileFilter();

    private SSHKeyFileFilter() {
    }

    public static SSHKeyFileFilter getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (!file.canRead()) {
            return false;
        }
        long flen = file.length();
        if (flen < 100L || flen > 10000L) {
            return false;
        }
        FileInputStream fis = null;
        byte[] buffer = new byte[30];
        try {
            fis = new FileInputStream(file);
            fis.read(buffer, 0, 30);
            Matcher m = p.matcher(new String(buffer, 0, 30, cs));
            if (!m.matches()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Authentication.isValidSSHKeyFile((String)file.getAbsolutePath());
    }
}

