/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.BasicAggregateProgressFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.execute.cmd.ExecMojo;
import org.netbeans.modules.maven.execute.ui.Bundle;
import org.netbeans.modules.maven.nodes.DependencyNode;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

class GotoPluginSourceAction
extends AbstractAction {
    private final ExecMojo mojo;
    private final RunConfig config;

    public GotoPluginSourceAction(ExecMojo start, RunConfig conf) {
        this.putValue("Name", Bundle.ACT_GOTO_Plugin());
        this.mojo = start;
        this.config = conf;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GotoPluginSourceAction.this.doLoad(cancel);
            }
        }, (String)Bundle.TIT_GOTO_Plugin(), (AtomicBoolean)cancel, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad(AtomicBoolean cancel) {
        block17: {
            MavenEmbedder onlineEmbedder = EmbedderFactory.getOnlineEmbedder();
            Artifact art = onlineEmbedder.createArtifact(this.mojo.plugin.groupId, this.mojo.plugin.artifactId, this.mojo.plugin.version, "jar");
            Project prj = this.config.getProject();
            if (prj != null) {
                ProgressContributor contributor = BasicAggregateProgressFactory.createProgressContributor((String)"multi-1");
                AggregateProgressHandle handle = BasicAggregateProgressFactory.createHandle((String)"Downloading plugin sources", (ProgressContributor[])new ProgressContributor[]{contributor}, (Cancellable)ProgressTransferListener.cancellable(), null);
                handle.start();
                try {
                    ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                    NbMavenProject pr = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                    onlineEmbedder.resolve(art, pr.getMavenProject().getPluginArtifactRepositories(), onlineEmbedder.getLocalRepository());
                    if (art.getFile().exists() && !cancel.get()) {
                        String className;
                        Artifact sourceArt = DependencyNode.downloadJavadocSources(contributor, false, art, prj);
                        FileObject binaryRoot = FileUtil.toFileObject((File)art.getFile());
                        if (cancel.get() || binaryRoot == null || !FileUtil.isArchiveFile((FileObject)binaryRoot)) break block17;
                        binaryRoot = FileUtil.getArchiveRoot((FileObject)binaryRoot);
                        if (cancel.get() || (className = this.mojo.getImplementationClass()) == null) break block17;
                        FileObject fo = binaryRoot.getFileObject(className.replace(".", "/") + ".class");
                        if (cancel.get() || fo == null) break block17;
                        try {
                            OpenCookie cookie;
                            DataObject dobj = DataObject.find((FileObject)fo);
                            if (dobj != null && (cookie = (OpenCookie)dobj.getLookup().lookup(OpenCookie.class)) != null) {
                                cookie.open();
                            }
                            break block17;
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        break block17;
                    }
                    contributor.finish();
                }
                catch (ArtifactResolutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ArtifactNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ThreadDeath ex) {
                }
                catch (IllegalStateException ise) {
                    if (!(ise.getCause() instanceof ThreadDeath)) {
                        throw ise;
                    }
                }
                finally {
                    handle.finish();
                    ProgressTransferListener.clearAggregateHandle();
                }
            }
        }
    }
}

