/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.java.preprocessorbridge.spi.ImportProcessor;
import org.netbeans.modules.web.core.syntax.completion.Util;
import org.openide.util.Exceptions;

public abstract class JspTagLibImportProcessor
implements ImportProcessor {
    public void addImport(Document document, final String fqn) {
        final BaseDocument doc = (BaseDocument)document;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JspTagLibImportProcessor.this.processDocument(doc, fqn);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        });
    }

    protected abstract String createImportDirective(String var1);

    private void processDocument(BaseDocument doc, String fqn) throws BadLocationException {
        int insertPos = Util.findPositionForJspDirective(doc);
        doc.insertString(insertPos, this.createImportDirective(fqn), null);
    }

    public static class TagImportProcessor
    extends JspTagLibImportProcessor {
        @Override
        protected String createImportDirective(String fqn) {
            return "<%@tag import=\"" + fqn + "\"%>\n";
        }
    }

    public static class JspImportProcessor
    extends JspTagLibImportProcessor {
        @Override
        protected String createImportDirective(String fqn) {
            return "<%@page import=\"" + fqn + "\"%>\n";
        }
    }
}

