/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetIamWorkRequestRequest
extends BmcRequest<Void> {
    private String iamWorkRequestId;
    private String opcRequestId;

    @ConstructorProperties(value={"iamWorkRequestId", "opcRequestId"})
    GetIamWorkRequestRequest(String iamWorkRequestId, String opcRequestId) {
        this.iamWorkRequestId = iamWorkRequestId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().iamWorkRequestId(this.iamWorkRequestId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetIamWorkRequestRequest(super=" + super.toString() + ", iamWorkRequestId=" + this.getIamWorkRequestId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetIamWorkRequestRequest)) {
            return false;
        }
        GetIamWorkRequestRequest other = (GetIamWorkRequestRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$iamWorkRequestId = this.getIamWorkRequestId();
        String other$iamWorkRequestId = other.getIamWorkRequestId();
        if (this$iamWorkRequestId == null ? other$iamWorkRequestId != null : !this$iamWorkRequestId.equals(other$iamWorkRequestId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetIamWorkRequestRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $iamWorkRequestId = this.getIamWorkRequestId();
        result = result * 59 + ($iamWorkRequestId == null ? 43 : $iamWorkRequestId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getIamWorkRequestId() {
        return this.iamWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIamWorkRequestRequest, Void> {
        private String iamWorkRequestId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIamWorkRequestRequest o) {
            this.iamWorkRequestId(o.getIamWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIamWorkRequestRequest build() {
            GetIamWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder iamWorkRequestId(String iamWorkRequestId) {
            this.iamWorkRequestId = iamWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetIamWorkRequestRequest buildWithoutInvocationCallback() {
            return new GetIamWorkRequestRequest(this.iamWorkRequestId, this.opcRequestId);
        }

        public String toString() {
            return "GetIamWorkRequestRequest.Builder(iamWorkRequestId=" + this.iamWorkRequestId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

