/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.spi.editor.AbstractEditorAction;
import org.openide.util.Exceptions;

public class AddCaretSelectAllAction
extends AbstractEditorAction {
    private static final Logger LOGGER = Logger.getLogger(AddCaretSelectAllAction.class.getName());

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            Caret caret = target.getCaret();
            if (!Utilities.isSelectionShowing((Caret)caret)) {
                try {
                    int[] identifierBlock = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)target.getDocument()), (int)caret.getDot());
                    if (identifierBlock != null) {
                        caret.setDot(identifierBlock[0]);
                        caret.moveDot(identifierBlock[1]);
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
            }
            EditorFindSupport findSupport = EditorFindSupport.getInstance();
            HashMap<String, Object> props = new HashMap<String, Object>(findSupport.createDefaultFindProperties());
            String searchWord = target.getSelectedText();
            if (searchWord != null) {
                int n = searchWord.indexOf(10);
                if (n >= 0) {
                    searchWord = searchWord.substring(0, n);
                }
                props.put("find-what", searchWord);
                Document doc = target.getDocument();
                EditorUI eui = Utilities.getEditorUI((JTextComponent)target);
                if (eui.getComponent().getClientProperty("AsTextField") == null) {
                    findSupport.setFocusedTextComponent(eui.getComponent());
                }
                findSupport.putFindProperties(props);
                findSupport.find(null, false);
                if (caret instanceof EditorCaret) {
                    EditorCaret editorCaret = (EditorCaret)caret;
                    try {
                        int[] blocks = findSupport.getBlocks(new int[]{-1, -1}, doc, 0, doc.getLength());
                        if (blocks[0] >= 0 && blocks.length % 2 == 0) {
                            ArrayList<Position> newCarets = new ArrayList<Position>();
                            for (int i = 0; i < blocks.length; i += 2) {
                                int start = blocks[i];
                                int end = blocks[i + 1];
                                if (start == -1 || end == -1) break;
                                Position startPos = doc.createPosition(start);
                                Position endPos = doc.createPosition(end);
                                newCarets.add(endPos);
                                newCarets.add(startPos);
                            }
                            editorCaret.replaceCarets(newCarets, null);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }
}

