/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;

public final class ProjectBookmarks {
    private final URI projectURI;
    private volatile int lastBookmarkId;
    private final Map<URI, FileBookmarks> relativeURI2FileBookmarks;
    private boolean loaded;
    private boolean loadingScheduled;
    private boolean modified;
    private final Map<Object, Boolean> activeClients = new WeakHashMap<Object, Boolean>();
    private String projectDisplayName;

    public ProjectBookmarks(URI projectURI) {
        this.projectURI = projectURI;
        this.relativeURI2FileBookmarks = new HashMap<URI, FileBookmarks>();
        if (projectURI == null) {
            this.markLoadScheduled();
            this.markLoaded();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    void markLoaded() {
        this.loaded = true;
    }

    public boolean isLoadingScheduled() {
        return this.loadingScheduled;
    }

    void markLoadScheduled() {
        this.loadingScheduled = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    public URI getProjectURI() {
        return this.projectURI;
    }

    public int getLastBookmarkId() {
        return this.lastBookmarkId;
    }

    void setLastBookmarkId(int lastBookmarkId) {
        this.lastBookmarkId = lastBookmarkId;
        for (FileBookmarks fileBookmarks : this.relativeURI2FileBookmarks.values()) {
            for (BookmarkInfo bookmark : fileBookmarks.getBookmarks()) {
                bookmark.shiftId(lastBookmarkId);
            }
        }
    }

    public int generateBookmarkId() {
        return ++this.lastBookmarkId;
    }

    public void ensureBookmarkIdIsSkipped(int bookmarkId) {
        this.lastBookmarkId = Math.max(this.lastBookmarkId, bookmarkId);
    }

    public FileBookmarks getFileBookmarks(URI relativeURI) {
        return this.relativeURI2FileBookmarks.get(relativeURI);
    }

    void add(FileBookmarks fileBookmarks) {
        this.relativeURI2FileBookmarks.put(fileBookmarks.getRelativeURI(), fileBookmarks);
    }

    void remove(URI relativeURI) {
        this.relativeURI2FileBookmarks.remove(relativeURI);
    }

    public Collection<FileBookmarks> getFileBookmarks() {
        return this.relativeURI2FileBookmarks.values();
    }

    public boolean containsAnyBookmarks() {
        for (FileBookmarks fileBookmarks : this.relativeURI2FileBookmarks.values()) {
            if (!fileBookmarks.containsAnyBookmarks()) continue;
            return true;
        }
        return false;
    }

    public void activeClientNotify(Object activeClient) {
        this.activeClients.put(activeClient, Boolean.TRUE);
    }

    public boolean hasActiveClients() {
        return this.activeClients.size() > 0;
    }

    public String getProjectDisplayName() {
        return this.projectDisplayName;
    }

    void setProjectDisplayName(String projectDisplayName) {
        this.projectDisplayName = projectDisplayName;
    }

    public String toString() {
        return "project=" + this.projectURI + ", lastBId=" + this.lastBookmarkId + ", loaded=" + this.loaded + ", loadingScheduled=" + this.loadingScheduled + ", modified=" + this.modified;
    }
}

