/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.util.Collections;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.TomcatWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.DefaultServerEndpointConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TomcatRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private static final String SERVER_CONTAINER_ATTR = "javax.websocket.server.ServerContainer";
    @Nullable
    private Long asyncSendTimeout;
    @Nullable
    private Long maxSessionIdleTimeout;
    @Nullable
    private Integer maxTextMessageBufferSize;
    @Nullable
    private Integer maxBinaryMessageBufferSize;
    @Nullable
    private WsServerContainer serverContainer;

    public void setAsyncSendTimeout(Long timeoutInMillis) {
        this.asyncSendTimeout = timeoutInMillis;
    }

    @Nullable
    public Long getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    public void setMaxSessionIdleTimeout(Long timeoutInMillis) {
        this.maxSessionIdleTimeout = timeoutInMillis;
    }

    @Nullable
    public Long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxTextMessageBufferSize(Integer bufferSize) {
        this.maxTextMessageBufferSize = bufferSize;
    }

    @Nullable
    public Integer getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(Integer bufferSize) {
        this.maxBinaryMessageBufferSize = bufferSize;
    }

    @Nullable
    public Integer getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        HttpServletRequest servletRequest = TomcatRequestUpgradeStrategy.getNativeRequest(request);
        HttpServletResponse servletResponse = TomcatRequestUpgradeStrategy.getNativeResponse(response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory bufferFactory = response.bufferFactory();
        StandardWebSocketHandlerAdapter endpoint = new StandardWebSocketHandlerAdapter(handler, session -> new TomcatWebSocketSession((Session)session, handshakeInfo, bufferFactory));
        String requestURI = servletRequest.getRequestURI();
        DefaultServerEndpointConfig config = new DefaultServerEndpointConfig(requestURI, endpoint);
        config.setSubprotocols(subProtocol != null ? Collections.singletonList(subProtocol) : Collections.emptyList());
        return exchange.getResponse().setComplete().then(Mono.fromCallable(() -> {
            WsServerContainer container = this.getContainer(servletRequest);
            container.doUpgrade(servletRequest, servletResponse, (ServerEndpointConfig)config, Collections.emptyMap());
            return null;
        }));
    }

    private static HttpServletRequest getNativeRequest(ServerHttpRequest request) {
        if (request instanceof AbstractServerHttpRequest) {
            return (HttpServletRequest)((AbstractServerHttpRequest)request).getNativeRequest();
        }
        if (request instanceof ServerHttpRequestDecorator) {
            return TomcatRequestUpgradeStrategy.getNativeRequest(((ServerHttpRequestDecorator)request).getDelegate());
        }
        throw new IllegalArgumentException("Couldn't find HttpServletRequest in " + request.getClass().getName());
    }

    private static HttpServletResponse getNativeResponse(ServerHttpResponse response) {
        if (response instanceof AbstractServerHttpResponse) {
            return (HttpServletResponse)((AbstractServerHttpResponse)response).getNativeResponse();
        }
        if (response instanceof ServerHttpResponseDecorator) {
            return TomcatRequestUpgradeStrategy.getNativeResponse(((ServerHttpResponseDecorator)response).getDelegate());
        }
        throw new IllegalArgumentException("Couldn't find HttpServletResponse in " + response.getClass().getName());
    }

    private WsServerContainer getContainer(HttpServletRequest request) {
        if (this.serverContainer == null) {
            Object container = request.getServletContext().getAttribute(SERVER_CONTAINER_ATTR);
            Assert.state((boolean)(container instanceof WsServerContainer), (String)"ServletContext attribute 'javax.websocket.server.ServerContainer' not found.");
            this.serverContainer = (WsServerContainer)container;
            this.initServerContainer((ServerContainer)this.serverContainer);
        }
        return this.serverContainer;
    }

    private void initServerContainer(ServerContainer serverContainer) {
        if (this.asyncSendTimeout != null) {
            serverContainer.setAsyncSendTimeout(this.asyncSendTimeout.longValue());
        }
        if (this.maxSessionIdleTimeout != null) {
            serverContainer.setDefaultMaxSessionIdleTimeout(this.maxSessionIdleTimeout.longValue());
        }
        if (this.maxTextMessageBufferSize != null) {
            serverContainer.setDefaultMaxTextMessageBufferSize(this.maxTextMessageBufferSize.intValue());
        }
        if (this.maxBinaryMessageBufferSize != null) {
            serverContainer.setDefaultMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize.intValue());
        }
    }
}

