/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.connector.AJP12RequestAdapter;
import org.apache.tomcat.service.connector.AJP12ResponseAdapter;
import org.apache.tomcat.util.StringManager;

public class Ajp12ConnectionHandler
implements TcpConnectionHandler {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    ContextManager contextM;

    public Object[] init() {
        Object[] thData = new Object[2];
        AJP12RequestAdapter reqA = new AJP12RequestAdapter();
        AJP12ResponseAdapter resA = new AJP12ResponseAdapter();
        this.contextM.initRequest(reqA, resA);
        thData[0] = reqA;
        thData[1] = resA;
        return thData;
    }

    public void setAttribute(String name, Object value) {
        if ("context.manager".equals(name)) {
            this.contextM = (ContextManager)value;
        }
    }

    public void setServer(Object contextM) {
        this.contextM = (ContextManager)contextM;
    }

    public void processConnection(TcpConnection connection, Object[] thData) {
        try {
            if (connection == null) {
                return;
            }
            Socket socket = connection.getSocket();
            if (socket == null) {
                return;
            }
            socket.setSoLinger(true, 100);
            AJP12RequestAdapter reqA = null;
            AJP12ResponseAdapter resA = null;
            if (thData != null) {
                reqA = (AJP12RequestAdapter)thData[0];
                resA = (AJP12ResponseAdapter)thData[1];
                if (reqA != null) {
                    reqA.recycle();
                }
                if (resA != null) {
                    resA.recycle();
                }
            }
            if (reqA == null || resA == null) {
                reqA = new AJP12RequestAdapter();
                resA = new AJP12ResponseAdapter();
                this.contextM.initRequest(reqA, resA);
            }
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            reqA.setSocket(socket);
            resA.setOutputStream(out);
            reqA.readNextRequest();
            if (reqA.isPing) {
                return;
            }
            if (reqA.shutdown) {
                return;
            }
            if (resA.getStatus() >= 400) {
                resA.finish();
                socket.close();
                return;
            }
            int contentLength = reqA.getMimeHeaders().getIntHeader("content-length");
            if (contentLength != -1) {
                BufferedServletInputStream sis = (BufferedServletInputStream)reqA.getInputStream();
                sis.setLimit(contentLength);
            }
            this.contextM.service(reqA, resA);
            socket.close();
        }
        catch (Exception e) {
            System.out.println("HANDLER THREAD PROBLEM: " + e);
            e.printStackTrace();
        }
    }
}

