/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projectapi.SPIAccessor;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public interface ProjectManagerImplementation {
    public void init(@NonNull ProjectManagerCallBack var1);

    @NonNull
    public Mutex getMutex();

    @NonNull
    public Mutex getMutex(boolean var1, @NonNull Project var2, Project ... var3);

    @CheckForNull
    public Project findProject(@NonNull FileObject var1) throws IOException, IllegalArgumentException;

    @CheckForNull
    public ProjectManager.Result isProject(@NonNull FileObject var1) throws IllegalArgumentException;

    public void clearNonProjectCache();

    @NonNull
    public Set<Project> getModifiedProjects();

    public boolean isModified(@NonNull Project var1);

    public boolean isValid(@NonNull Project var1);

    public void saveProject(@NonNull Project var1) throws IOException;

    public void saveAllProjects() throws IOException;

    public static final class ProjectManagerCallBack {
        private ProjectManagerCallBack() {
        }

        public void notifyModified(@NonNull Project project) {
        }

        public void notifyDeleted(@NullAllowed Project project) {
            Collection col = Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class);
            for (FileOwnerQueryImplementation impl : col) {
                if (!(impl instanceof SimpleFileOwnerQueryImplementation)) continue;
                ((SimpleFileOwnerQueryImplementation)impl).resetLastFoundReferences();
            }
        }

        static {
            SPIAccessor.setInstance(new SPIAccessorImpl());
        }

        private static final class SPIAccessorImpl
        extends SPIAccessor {
            private SPIAccessorImpl() {
            }

            @Override
            @NonNull
            public ProjectManagerCallBack createProjectManagerCallBack() {
                return new ProjectManagerCallBack();
            }
        }
    }
}

