/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteOAuthClientCredentialRequest
extends BmcRequest<Void> {
    private String userId;
    private String oauth2ClientCredentialId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "oauth2ClientCredentialId", "ifMatch"})
    DeleteOAuthClientCredentialRequest(String userId, String oauth2ClientCredentialId, String ifMatch) {
        this.userId = userId;
        this.oauth2ClientCredentialId = oauth2ClientCredentialId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).oauth2ClientCredentialId(this.oauth2ClientCredentialId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteOAuthClientCredentialRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", oauth2ClientCredentialId=" + this.getOauth2ClientCredentialId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteOAuthClientCredentialRequest)) {
            return false;
        }
        DeleteOAuthClientCredentialRequest other = (DeleteOAuthClientCredentialRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$oauth2ClientCredentialId = this.getOauth2ClientCredentialId();
        String other$oauth2ClientCredentialId = other.getOauth2ClientCredentialId();
        if (this$oauth2ClientCredentialId == null ? other$oauth2ClientCredentialId != null : !this$oauth2ClientCredentialId.equals(other$oauth2ClientCredentialId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteOAuthClientCredentialRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $oauth2ClientCredentialId = this.getOauth2ClientCredentialId();
        result = result * 59 + ($oauth2ClientCredentialId == null ? 43 : $oauth2ClientCredentialId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getOauth2ClientCredentialId() {
        return this.oauth2ClientCredentialId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteOAuthClientCredentialRequest, Void> {
        private String userId;
        private String oauth2ClientCredentialId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.oauth2ClientCredentialId(o.getOauth2ClientCredentialId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteOAuthClientCredentialRequest build() {
            DeleteOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder oauth2ClientCredentialId(String oauth2ClientCredentialId) {
            this.oauth2ClientCredentialId = oauth2ClientCredentialId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            return new DeleteOAuthClientCredentialRequest(this.userId, this.oauth2ClientCredentialId, this.ifMatch);
        }

        public String toString() {
            return "DeleteOAuthClientCredentialRequest.Builder(userId=" + this.userId + ", oauth2ClientCredentialId=" + this.oauth2ClientCredentialId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

