/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintTokenId;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintsParser;
import org.netbeans.modules.java.hints.declarative.MethodInvocationContext;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class EmbeddingProviderImpl
extends EmbeddingProvider {
    private static final String GLOBAL_PATTERN_PACKAGE = "package $;\n";
    private static final String GLOBAL_PATTERN_CLASS = "class $ {\n";
    private static final String GLOBAL_PATTERN_SUFFIX = "\n}\n";
    private static final String SNIPPET_PATTERN_PREFIX_PART1 = "private void ${0}(";
    private static final String SNIPPET_PATTERN_PREFIX_PART2 = ") throws Throwable {\n";
    private static final String SNIPPET_PATTERN_SUFFIX = " ;\n}\n";
    private static final String CUSTOM_CONDITIONS_VARIABLES = "private final Context context = null;\nprivate final Matcher matcher = null;\n";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenSequence ts = snapshot.getTokenHierarchy().tokenSequence(DeclarativeHintTokenId.language());
        DeclarativeHintsParser.Result parsed = new DeclarativeHintsParser().parse(snapshot.getSource().getFileObject(), snapshot.getText(), (TokenSequence<DeclarativeHintTokenId>)ts);
        if (parsed.blocks.isEmpty()) {
            return Arrays.asList(Embedding.create(this.rules(snapshot, parsed)));
        }
        return Arrays.asList(Embedding.create(this.rules(snapshot, parsed)), Embedding.create(this.predicates(snapshot, parsed)));
    }

    private List<Embedding> rules(Snapshot snapshot, DeclarativeHintsParser.Result parsed) {
        int index = 0;
        LinkedList<Embedding> result = new LinkedList<Embedding>();
        result.add(snapshot.create((CharSequence)"//no-errors\n", "text/x-java"));
        result.add(snapshot.create((CharSequence)GLOBAL_PATTERN_PACKAGE, "text/x-java"));
        if (parsed.importsBlock != null) {
            result.add(snapshot.create(snapshot.getText().subSequence(parsed.importsBlock[0], parsed.importsBlock[1]), "text/x-java"));
            result.add(snapshot.create((CharSequence)"\n", "text/x-java"));
        }
        result.add(snapshot.create((CharSequence)GLOBAL_PATTERN_CLASS, "text/x-java"));
        for (DeclarativeHintsParser.HintTextDescription hint : parsed.hints) {
            result.add(snapshot.create((CharSequence)SNIPPET_PATTERN_PREFIX_PART1.replaceAll("\\{0\\}", "" + index++), "text/x-java"));
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (Condition c : hint.conditions) {
                if (!(c instanceof Condition.Instanceof)) continue;
                Condition.Instanceof i = (Condition.Instanceof)c;
                if (!first) {
                    result.add(snapshot.create((CharSequence)", ", "text/x-java"));
                    builder.append(", ");
                }
                Embedding e1 = snapshot.create(i.constraintSpan[0], i.constraintSpan[1] - i.constraintSpan[0], "text/x-java");
                Embedding e2 = snapshot.create((CharSequence)(" " + i.variable), "text/x-java");
                result.add(Embedding.create(Arrays.asList(e1, e2)));
                builder.append(i.constraint);
                builder.append(" " + i.variable);
                first = false;
            }
            result.add(snapshot.create((CharSequence)SNIPPET_PATTERN_PREFIX_PART2, "text/x-java"));
            result.add(snapshot.create(hint.textStart, hint.textEnd - hint.textStart, "text/x-java"));
            result.add(snapshot.create((CharSequence)SNIPPET_PATTERN_SUFFIX, "text/x-java"));
            for (DeclarativeHintsParser.FixTextDescription f : hint.fixes) {
                int[] fixes = f.fixSpan;
                result.add(snapshot.create((CharSequence)SNIPPET_PATTERN_PREFIX_PART1.replaceAll("\\{0\\}", "" + index++), "text/x-java"));
                result.add(snapshot.create((CharSequence)builder.toString(), "text/x-java"));
                result.add(snapshot.create((CharSequence)SNIPPET_PATTERN_PREFIX_PART2, "text/x-java"));
                result.add(snapshot.create(fixes[0], fixes[1] - fixes[0], "text/x-java"));
                result.add(snapshot.create((CharSequence)SNIPPET_PATTERN_SUFFIX, "text/x-java"));
            }
        }
        result.add(snapshot.create((CharSequence)GLOBAL_PATTERN_SUFFIX, "text/x-java"));
        return result;
    }

    private List<Embedding> predicates(Snapshot snapshot, DeclarativeHintsParser.Result parsed) {
        LinkedList<Embedding> result = new LinkedList<Embedding>();
        result.add(snapshot.create((CharSequence)GLOBAL_PATTERN_PACKAGE, "text/x-java"));
        if (parsed.importsBlock != null) {
            result.add(snapshot.create(parsed.importsBlock[0], parsed.importsBlock[1] - parsed.importsBlock[0], "text/x-java"));
            result.add(snapshot.create((CharSequence)"\n", "text/x-java"));
        }
        for (String imp : MethodInvocationContext.AUXILIARY_IMPORTS) {
            result.add(snapshot.create((CharSequence)(imp + "\n"), "text/x-java"));
        }
        result.add(snapshot.create((CharSequence)GLOBAL_PATTERN_CLASS, "text/x-java"));
        result.add(snapshot.create((CharSequence)CUSTOM_CONDITIONS_VARIABLES, "text/x-java"));
        for (int[] span : parsed.blocks) {
            result.add(snapshot.create(span[0], span[1] - span[0], "text/x-java"));
        }
        result.add(snapshot.create((CharSequence)GLOBAL_PATTERN_SUFFIX, "text/x-java"));
        return result;
    }

    public int getPriority() {
        return 100;
    }

    public void cancel() {
    }

    public static final class FactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new EmbeddingProviderImpl());
        }
    }
}

