/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DatabaseSoftwareImageSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDatabaseSoftwareImagesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private DatabaseSoftwareImageSummary.LifecycleState lifecycleState;
    private String displayName;
    private DatabaseSoftwareImageSummary.ImageType imageType;
    private DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily;
    private Boolean isUpgradeSupported;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "displayName", "imageType", "imageShapeFamily", "isUpgradeSupported"})
    ListDatabaseSoftwareImagesRequest(String compartmentId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, DatabaseSoftwareImageSummary.LifecycleState lifecycleState, String displayName, DatabaseSoftwareImageSummary.ImageType imageType, DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily, Boolean isUpgradeSupported) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.imageType = imageType;
        this.imageShapeFamily = imageShapeFamily;
        this.isUpgradeSupported = isUpgradeSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).displayName(this.displayName).imageType(this.imageType).imageShapeFamily(this.imageShapeFamily).isUpgradeSupported(this.isUpgradeSupported);
    }

    public String toString() {
        return "ListDatabaseSoftwareImagesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", displayName=" + this.getDisplayName() + ", imageType=" + (Object)((Object)this.getImageType()) + ", imageShapeFamily=" + (Object)((Object)this.getImageShapeFamily()) + ", isUpgradeSupported=" + this.getIsUpgradeSupported() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDatabaseSoftwareImagesRequest)) {
            return false;
        }
        ListDatabaseSoftwareImagesRequest other = (ListDatabaseSoftwareImagesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$isUpgradeSupported = this.getIsUpgradeSupported();
        Boolean other$isUpgradeSupported = other.getIsUpgradeSupported();
        if (this$isUpgradeSupported == null ? other$isUpgradeSupported != null : !((Object)this$isUpgradeSupported).equals(other$isUpgradeSupported)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        DatabaseSoftwareImageSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        DatabaseSoftwareImageSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        DatabaseSoftwareImageSummary.ImageType this$imageType = this.getImageType();
        DatabaseSoftwareImageSummary.ImageType other$imageType = other.getImageType();
        if (this$imageType == null ? other$imageType != null : !((Object)((Object)this$imageType)).equals((Object)other$imageType)) {
            return false;
        }
        DatabaseSoftwareImageSummary.ImageShapeFamily this$imageShapeFamily = this.getImageShapeFamily();
        DatabaseSoftwareImageSummary.ImageShapeFamily other$imageShapeFamily = other.getImageShapeFamily();
        return !(this$imageShapeFamily == null ? other$imageShapeFamily != null : !((Object)((Object)this$imageShapeFamily)).equals((Object)other$imageShapeFamily));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDatabaseSoftwareImagesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $isUpgradeSupported = this.getIsUpgradeSupported();
        result = result * 59 + ($isUpgradeSupported == null ? 43 : ((Object)$isUpgradeSupported).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        DatabaseSoftwareImageSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        DatabaseSoftwareImageSummary.ImageType $imageType = this.getImageType();
        result = result * 59 + ($imageType == null ? 43 : ((Object)((Object)$imageType)).hashCode());
        DatabaseSoftwareImageSummary.ImageShapeFamily $imageShapeFamily = this.getImageShapeFamily();
        result = result * 59 + ($imageShapeFamily == null ? 43 : ((Object)((Object)$imageShapeFamily)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public DatabaseSoftwareImageSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DatabaseSoftwareImageSummary.ImageType getImageType() {
        return this.imageType;
    }

    public DatabaseSoftwareImageSummary.ImageShapeFamily getImageShapeFamily() {
        return this.imageShapeFamily;
    }

    public Boolean getIsUpgradeSupported() {
        return this.isUpgradeSupported;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDatabaseSoftwareImagesRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private DatabaseSoftwareImageSummary.LifecycleState lifecycleState;
        private String displayName;
        private DatabaseSoftwareImageSummary.ImageType imageType;
        private DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily;
        private Boolean isUpgradeSupported;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDatabaseSoftwareImagesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.imageType(o.getImageType());
            this.imageShapeFamily(o.getImageShapeFamily());
            this.isUpgradeSupported(o.getIsUpgradeSupported());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDatabaseSoftwareImagesRequest build() {
            ListDatabaseSoftwareImagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(DatabaseSoftwareImageSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder imageType(DatabaseSoftwareImageSummary.ImageType imageType) {
            this.imageType = imageType;
            return this;
        }

        public Builder imageShapeFamily(DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily) {
            this.imageShapeFamily = imageShapeFamily;
            return this;
        }

        public Builder isUpgradeSupported(Boolean isUpgradeSupported) {
            this.isUpgradeSupported = isUpgradeSupported;
            return this;
        }

        public ListDatabaseSoftwareImagesRequest buildWithoutInvocationCallback() {
            return new ListDatabaseSoftwareImagesRequest(this.compartmentId, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.displayName, this.imageType, this.imageShapeFamily, this.isUpgradeSupported);
        }

        public String toString() {
            return "ListDatabaseSoftwareImagesRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ", imageType=" + (Object)((Object)this.imageType) + ", imageShapeFamily=" + (Object)((Object)this.imageShapeFamily) + ", isUpgradeSupported=" + this.isUpgradeSupported + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

